/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.MapperFactory;
import com.flagsmith.Trait;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IdentityTraits
implements Serializable {
    private String identifier;
    private List<Trait> traits;

    @JsonIgnore
    public void parse(String data) throws IOException {
        ObjectMapper mapper = MapperFactory.getMappper();
        IdentityTraits prototype = (IdentityTraits)mapper.readValue(data, IdentityTraits.class);
        this.fromPrototype(prototype);
    }

    @JsonIgnore
    private void fromPrototype(IdentityTraits prototype) {
        this.setIdentifier(prototype.getIdentifier());
        this.setTraits(prototype.getTraits());
    }

    @JsonIgnore
    public String toString() {
        ObjectMapper mapper = MapperFactory.getMappper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<Trait> getTraits() {
        return this.traits;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setTraits(List<Trait> traits) {
        this.traits = traits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityTraits)) {
            return false;
        }
        IdentityTraits other = (IdentityTraits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        List<Trait> this$traits = this.getTraits();
        List<Trait> other$traits = other.getTraits();
        return !(this$traits == null ? other$traits != null : !((Object)this$traits).equals(other$traits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdentityTraits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        List<Trait> $traits = this.getTraits();
        result = result * 59 + ($traits == null ? 43 : ((Object)$traits).hashCode());
        return result;
    }
}

