/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.flagsmith.FeatureUser;
import com.flagsmith.Flag;
import com.flagsmith.FlagsAndTraits;
import com.flagsmith.FlagsmithAPIWrapper;
import com.flagsmith.FlagsmithCache;
import com.flagsmith.FlagsmithCacheConfig;
import com.flagsmith.FlagsmithCachedAPIWrapper;
import com.flagsmith.FlagsmithConfig;
import com.flagsmith.FlagsmithLogger;
import com.flagsmith.FlagsmithLoggerLevel;
import com.flagsmith.FlagsmithSDK;
import com.flagsmith.Trait;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;
import org.slf4j.LoggerFactory;

public class FlagsmithClient {
    private final FlagsmithLogger logger = new FlagsmithLogger();
    private FlagsmithSDK flagsmithSDK;
    private Predicate<String> defaultFlagPredicate = flagName -> false;
    private Function<String, String> defaultFlagValueFunc = flagName -> null;

    private FlagsmithClient() {
    }

    public List<Flag> getFeatureFlags() {
        return this.getFeatureFlags(null);
    }

    public List<Flag> getFeatureFlags(FeatureUser user) {
        return this.getFeatureFlags(user, false);
    }

    public List<Flag> getFeatureFlags(FeatureUser user, boolean doThrow) {
        return this.flagsmithSDK.getFeatureFlags(user, doThrow).getFlags();
    }

    public boolean hasFeatureFlag(String featureId) {
        List<Flag> featureFlags = this.getFeatureFlags();
        return this.hasFeatureFlagByName(featureId, featureFlags);
    }

    public boolean hasFeatureFlag(String featureId, FeatureUser user) {
        List<Flag> featureFlags = this.getFeatureFlags(user);
        return this.hasFeatureFlagByName(featureId, featureFlags);
    }

    public boolean hasFeatureFlag(String featureId, FlagsAndTraits flagsAndTraits) {
        if (flagsAndTraits == null) {
            return this.defaultFlagPredicate.test(featureId);
        }
        return this.hasFeatureFlagByName(featureId, flagsAndTraits.getFlags());
    }

    private boolean hasFeatureFlagByName(String featureId, List<Flag> featureFlags) {
        if (featureFlags != null) {
            for (Flag flag : featureFlags) {
                if (!flag.getFeature().getName().equals(featureId)) continue;
                return flag.isEnabled();
            }
        }
        return this.defaultFlagPredicate.test(featureId);
    }

    public String getFeatureFlagValue(String featureId) {
        List<Flag> featureFlags = this.getFeatureFlags();
        return this.getFeatureFlagValueByName(featureId, featureFlags);
    }

    public String getFeatureFlagValue(String featureId, FeatureUser user) {
        List<Flag> featureFlags = this.getFeatureFlags(user);
        return this.getFeatureFlagValueByName(featureId, featureFlags);
    }

    public String getFeatureFlagValue(String featureId, FlagsAndTraits flagsAndTraits) {
        if (flagsAndTraits == null) {
            return this.defaultFlagValueFunc.apply(featureId);
        }
        return this.getFeatureFlagValueByName(featureId, flagsAndTraits.getFlags());
    }

    private String getFeatureFlagValueByName(String featureId, List<Flag> featureFlags) {
        if (featureFlags != null) {
            for (Flag flag : featureFlags) {
                if (!flag.getFeature().getName().equals(featureId)) continue;
                return flag.getStateValue();
            }
        }
        return this.defaultFlagValueFunc.apply(featureId);
    }

    public Trait getTrait(FeatureUser user, String key) {
        List<Trait> traits = this.getUserTraits(user);
        return FlagsmithClient.getTraitByKey(key, traits);
    }

    public static Trait getTrait(FlagsAndTraits flagsAndTraits, String key) {
        if (flagsAndTraits == null) {
            return null;
        }
        return FlagsmithClient.getTraitByKey(key, flagsAndTraits.getTraits());
    }

    private static Trait getTraitByKey(String key, List<Trait> traits) {
        if (traits != null) {
            for (Trait trait : traits) {
                if (!trait.getKey().equals(key)) continue;
                return trait;
            }
        }
        return null;
    }

    public List<Trait> getTraits(FeatureUser user, String ... keys) {
        return FlagsmithClient.getTraitsByKeys(this.getUserTraits(user), keys);
    }

    public static List<Trait> getTraits(FlagsAndTraits flagsAndTraits, String ... keys) {
        return flagsAndTraits == null ? null : FlagsmithClient.getTraitsByKeys(flagsAndTraits.getTraits(), keys);
    }

    private static List<Trait> getTraitsByKeys(List<Trait> traits, String[] keys) {
        if (keys == null || keys.length == 0 || traits == null) {
            return traits;
        }
        ArrayList<Trait> filteredTraits = new ArrayList<Trait>();
        for (Trait trait : traits) {
            if (!Arrays.asList(keys).contains(trait.getKey())) continue;
            filteredTraits.add(trait);
        }
        return filteredTraits;
    }

    private List<Trait> getUserTraits(FeatureUser user) {
        return this.getUserFlagsAndTraits(user).getTraits();
    }

    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user) {
        return this.getUserFlagsAndTraits(user, false);
    }

    public FlagsAndTraits getUserFlagsAndTraits(FeatureUser user, boolean doThrow) {
        return this.flagsmithSDK.getUserFlagsAndTraits(user, doThrow);
    }

    public Trait updateTrait(FeatureUser user, Trait toUpdate) {
        return this.updateTrait(user, toUpdate, false);
    }

    public Trait updateTrait(FeatureUser user, Trait toUpdate, boolean doThrow) {
        return this.flagsmithSDK.postUserTraits(user, toUpdate, doThrow);
    }

    public FlagsAndTraits identifyUserWithTraits(FeatureUser user, List<Trait> traits) {
        return this.identifyUserWithTraits(user, traits, false);
    }

    public FlagsAndTraits identifyUserWithTraits(FeatureUser user, List<Trait> traits, boolean doThrow) {
        return this.flagsmithSDK.identifyUserWithTraits(user, traits, doThrow);
    }

    public FlagsmithCache getCache() {
        return this.flagsmithSDK.getCache();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private FlagsmithClient client;
        private FlagsmithConfig configuration = FlagsmithConfig.newBuilder().build();
        private HashMap<String, String> customHeaders;
        private String apiKey;
        private FlagsmithCacheConfig cacheConfig;

        private Builder() {
            this.client = new FlagsmithClient();
        }

        public Builder setApiKey(String apiKey) {
            if (null == apiKey) {
                throw new IllegalArgumentException("Api key can not be null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public Builder setDefaultFlagPredicate(@NonNull Predicate<String> defaultFlagPredicate) {
            if (defaultFlagPredicate == null) {
                throw new IllegalArgumentException("defaultFlagPredicate is marked non-null but is null");
            }
            this.client.defaultFlagPredicate = defaultFlagPredicate;
            return this;
        }

        public Builder setDefaultFlagValueFunction(@NonNull Function<String, String> defaultFlagValueFunction) {
            if (defaultFlagValueFunction == null) {
                throw new IllegalArgumentException("defaultFlagValueFunction is marked non-null but is null");
            }
            this.client.defaultFlagValueFunc = defaultFlagValueFunction;
            return this;
        }

        public Builder enableLogging(FlagsmithLoggerLevel level) {
            this.client.logger.setLogger(LoggerFactory.getLogger(FlagsmithClient.class), level);
            return this;
        }

        public Builder enableLogging() {
            this.client.logger.setLogger(LoggerFactory.getLogger(FlagsmithClient.class));
            return this;
        }

        public Builder withConfiguration(FlagsmithConfig config) {
            if (config != null) {
                this.configuration = config;
            }
            return this;
        }

        public Builder withApiUrl(String apiUrl) {
            if (apiUrl != null) {
                this.configuration = FlagsmithConfig.newBuilder().baseURI(apiUrl).build();
            }
            return this;
        }

        public Builder withCustomHttpHeaders(HashMap<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public Builder withCache(FlagsmithCacheConfig cacheConfig) {
            this.cacheConfig = cacheConfig;
            return this;
        }

        public FlagsmithClient build() {
            FlagsmithAPIWrapper flagsmithAPIWrapper = new FlagsmithAPIWrapper(this.configuration, this.customHeaders, this.client.logger, this.apiKey);
            if (this.cacheConfig != null) {
                this.client.flagsmithSDK = new FlagsmithCachedAPIWrapper(this.cacheConfig.cache, flagsmithAPIWrapper);
            } else {
                this.client.flagsmithSDK = flagsmithAPIWrapper;
            }
            return this.client;
        }
    }
}

