/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class FlagsmithConfig {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_WRITE_TIMEOUT_MILLIS = 5000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 5000;
    private static final HttpUrl DEFAULT_BASE_URI = HttpUrl.parse((String)"https://api.flagsmith.com/api/v1/");
    private final HttpUrl baseURI;
    final HttpUrl flagsURI;
    final HttpUrl identitiesURI;
    final HttpUrl traitsURI;
    final OkHttpClient httpClient;

    protected FlagsmithConfig(Builder builder) {
        this.baseURI = builder.baseURI;
        this.flagsURI = this.baseURI.newBuilder("flags/").build();
        this.identitiesURI = this.baseURI.newBuilder("identities/").build();
        this.traitsURI = this.baseURI.newBuilder("traits/").build();
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder().connectTimeout((long)builder.connectTimeoutMillis, TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)builder.readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (builder.sslSocketFactory != null && builder.trustManager != null) {
            httpBuilder = httpBuilder.sslSocketFactory(builder.sslSocketFactory, builder.trustManager);
        }
        for (Interceptor interceptor : builder.interceptors) {
            httpBuilder = httpBuilder.addInterceptor(interceptor);
        }
        this.httpClient = httpBuilder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ HttpUrl access$800() {
        return DEFAULT_BASE_URI;
    }

    public static class Builder {
        private HttpUrl baseURI = FlagsmithConfig.access$800();
        private int connectTimeoutMillis = 2000;
        private int writeTimeoutMillis = 5000;
        private int readTimeoutMillis = 5000;
        private SSLSocketFactory sslSocketFactory;
        private X509TrustManager trustManager;
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>();

        private Builder() {
        }

        public Builder baseURI(String baseURI) {
            if (baseURI != null) {
                this.baseURI = HttpUrl.parse((String)baseURI);
            }
            return this;
        }

        public Builder connectTimeout(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder writeTimeout(int writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public Builder readTimeout(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        public Builder addHttpInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public FlagsmithConfig build() {
            return new FlagsmithConfig(this);
        }
    }
}

