/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.streaming;

import com.getindata.streaming.ThrowingFunction;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Collectors;
import org.apache.flink.client.python.PythonDriver;

public class FlinkPythonLoader {
    private static final String DEFAULT_FILE_PATH = "/flink/python_src/flink_app.py";

    public static void main(String[] args) throws Throwable {
        String filePath = args.length > 0 ? args[0] : DEFAULT_FILE_PATH;
        File pythonFile = FlinkPythonLoader.handleFile(filePath, is -> {
            File file = File.createTempFile("pyflink-", ".py");
            Files.write(file.toPath(), FlinkPythonLoader.getProgram(is).getBytes(), new OpenOption[0]);
            return file;
        });
        PythonDriver.main((String[])new String[]{"-py", pythonFile.getAbsolutePath()});
    }

    private static String getProgram(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
    }

    private static File handleFile(String filePath, ThrowingFunction<InputStream, File> handleStream) throws Throwable {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(filePath));){
            File file = handleStream.apply(is);
            return file;
        }
    }
}

