/*
 * Decompiled with CFR 0.152.
 */
package org.advisedtesting.junit4.objectfactory;

import java.util.Map;
import org.advisedtesting.core.internal.SimpleObjectFactory;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class TestSimpleObjectFactory {
    private static final String TEST_STRING3 = "testString3";
    private static final String TEST_STRING2 = "testString2";
    private static final String TEST_STRING1 = "testString1";
    private static final String TEST_LONG = "testLong";
    private static final String TEST_INT = "testInt";

    @Test
    public void getAndSetTests() {
        SimpleObjectFactory factory = new SimpleObjectFactory();
        factory.add(TEST_INT, (Object)1);
        factory.add(TEST_STRING1, (Object)"1");
        factory.add(TEST_LONG, (Object)1L);
        Assertions.assertThat((Integer)((Integer)factory.getObject(Integer.class))).isEqualTo(1);
        Assertions.assertThat((String)((String)factory.getObject(String.class))).isEqualTo((Object)"1");
        Assertions.assertThat((Long)((Long)factory.getObject(Long.class))).isEqualTo(1L);
        Assertions.assertThat((Double)((Double)factory.getObject(Double.class))).isEqualTo(null);
    }

    @Test
    public void getAndSetMultipleTests() {
        SimpleObjectFactory factory = new SimpleObjectFactory();
        factory.add(TEST_INT, (Object)1);
        factory.add(TEST_STRING1, (Object)"1");
        factory.add(TEST_STRING2, (Object)"2");
        factory.add(TEST_STRING3, (Object)"3");
        factory.add(TEST_LONG, (Object)1L);
        Assertions.assertThat((Integer)((Integer)factory.getObject(Integer.class))).isEqualTo(1);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)factory.getAllObjects(String.class)).containsEntry((Object)TEST_STRING1, (Object)"1")).containsEntry((Object)TEST_STRING2, (Object)"2")).containsEntry((Object)TEST_STRING3, (Object)"3");
        Assertions.assertThat((Long)((Long)factory.getObject(Long.class))).isEqualTo(1L);
        try {
            factory.getObject(String.class);
            Assertions.fail((String)"Expected runtime exception due to multiple beans of same type");
        }
        catch (RuntimeException re) {
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)re.getMessage()).contains(new CharSequence[]{TEST_STRING1})).contains(new CharSequence[]{TEST_STRING2})).contains(new CharSequence[]{TEST_STRING3});
        }
    }
}

