/*
 * Decompiled with CFR 0.152.
 */
package org.advisedtesting.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.advisedtesting.core.ConstraintException;
import org.advisedtesting.core.ContextAwareMethodInvocation;
import org.advisedtesting.core.ObjectFactory;
import org.advisedtesting.core.internal.AdviceAnnotationEvaluator;
import org.advisedtesting.core.internal.ExceptionEvaluator;
import org.advisedtesting.core.internal.ProviderAwareObjectFactoryAggregate;
import org.advisedtesting.core.internal.TestContext;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.AssumptionViolatedException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class Junit4AopClassRunner
extends BlockJUnit4ClassRunner {
    private static final TestContext CONTEXT = new TestContext();
    private final Class<?> targetClass;

    public Junit4AopClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.targetClass = klass;
    }

    protected void validateTestMethods(List<Throwable> errors) {
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.runContextualizedLeaf(method, notifier);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    private final void runContextualizedLeaf(FrameworkMethod frameworkMethod, RunNotifier notifier) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, this.describeChild(frameworkMethod));
        eachNotifier.fireTestStarted();
        ProviderAwareObjectFactoryAggregate registrar = new ProviderAwareObjectFactoryAggregate();
        List<Annotation> annotations = this.adviceAnnotations(frameworkMethod);
        Collections.reverse(annotations);
        DelayedConstructionStatement delayedStatement = new DelayedConstructionStatement(frameworkMethod, this.targetClass, registrar);
        Statement statement = delayedStatement;
        for (Annotation annotation : annotations) {
            statement = new AdvisedStatement(statement, CONTEXT, registrar, annotation);
        }
        try {
            try {
                statement.evaluate();
            }
            catch (Throwable th) {
                ConstraintException contraintException = (ConstraintException)ExceptionEvaluator.convertExceptionIfPossible((Throwable)th, ConstraintException.class);
                if (contraintException != null) {
                    eachNotifier.addFailedAssumption((org.junit.internal.AssumptionViolatedException)new AssumptionViolatedException(contraintException.getMessage(), (Throwable)contraintException));
                } else {
                    eachNotifier.addFailure(th);
                }
                eachNotifier.fireTestFinished();
            }
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    private List<Annotation> adviceAnnotations(FrameworkMethod frameworkMethod) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : AdviceAnnotationEvaluator.inspect((Annotation[])frameworkMethod.getMethod().getAnnotations())) {
            if (!CONTEXT.isAdviceAnnotation(annotation)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    protected List<TestRule> getTestRules(Object target) {
        TestClass testClass = new TestClass(target.getClass());
        List result = testClass.getAnnotatedMethodValues(target, Rule.class, TestRule.class);
        result.addAll(testClass.getAnnotatedFieldValues(target, Rule.class, TestRule.class));
        return result;
    }

    public static class AdvisedStatement
    extends Statement {
        private final Statement advised;
        private final TestContext context;
        private final ProviderAwareObjectFactoryAggregate registry;
        private final Annotation annotation;

        public AdvisedStatement(Statement advised, TestContext context, ProviderAwareObjectFactoryAggregate registry, Annotation annotation) {
            this.advised = advised;
            this.context = context;
            this.registry = registry;
            this.annotation = annotation;
        }

        public void evaluate() throws Throwable {
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            MethodInterceptor advisor = this.context.getAdviceFor(this.annotation, classloader);
            advisor.invoke((MethodInvocation)new ContextAwareMethodInvocation(){

                public void registerObjectFactory(ObjectFactory factory) {
                    registry.register(annotation, factory);
                }

                public ObjectFactory getCurrentContextFactory() {
                    return registry;
                }

                public Object proceed() throws Throwable {
                    advised.evaluate();
                    return null;
                }

                public Object getThis() {
                    return null;
                }

                public AccessibleObject getStaticPart() {
                    return null;
                }

                public Object[] getArguments() {
                    return new Object[0];
                }

                public Method getMethod() {
                    return null;
                }

                public Annotation getTargetAnnotation() {
                    return annotation;
                }
            });
        }
    }

    public class DelayedConstructionStatement
    extends Statement {
        private final String testName;
        private final List<String> parameterTypes;
        private final String targetClass;
        private final ProviderAwareObjectFactoryAggregate registry;
        private boolean wrapped = false;
        private Statement wrappedStatement = null;

        public DelayedConstructionStatement(FrameworkMethod fmethod, Class<?> targetClass, ProviderAwareObjectFactoryAggregate registry) {
            this.testName = fmethod.getMethod().getName();
            this.parameterTypes = Arrays.asList(fmethod.getMethod().getParameterTypes()).stream().map(clazz -> clazz.getName()).collect(Collectors.toList());
            this.targetClass = targetClass.getName();
            this.registry = registry;
        }

        public void evaluate() throws Throwable {
            if (this.wrapped) {
                this.wrappedStatement.evaluate();
            } else {
                this.wrapped = true;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> targetClassInLoader = Class.forName(this.targetClass, true, loader);
                Object target = targetClassInLoader.newInstance();
                ArrayList parameters = new ArrayList();
                for (String className : this.parameterTypes) {
                    parameters.add(Class.forName(className, true, loader));
                }
                Method method = targetClassInLoader.getMethod(this.testName, parameters.toArray(new Class[0]));
                FrameworkMethod fmethod = new FrameworkMethod(method);
                IvokationMethodWithArguments newTarget = new IvokationMethodWithArguments(target, fmethod, this.registry.getArgumentsFor(method));
                newTarget = Junit4AopClassRunner.this.possiblyExpectingExceptions(fmethod, target, newTarget);
                newTarget = Junit4AopClassRunner.this.withPotentialTimeout(fmethod, target, newTarget);
                newTarget = Junit4AopClassRunner.this.withBefores(fmethod, target, newTarget);
                newTarget = Junit4AopClassRunner.this.withAfters(fmethod, target, newTarget);
                List<TestRule> testRules = Junit4AopClassRunner.this.getTestRules(target);
                newTarget = new RunRules((Statement)newTarget, testRules, Junit4AopClassRunner.this.describeChild(fmethod));
                newTarget.evaluate();
            }
        }
    }

    public static class IvokationMethodWithArguments
    extends Statement {
        private final Object target;
        private final FrameworkMethod method;
        private final Object[] arguments;

        public IvokationMethodWithArguments(Object target, FrameworkMethod method, Object[] arguments) {
            this.target = target;
            this.method = method;
            this.arguments = arguments;
        }

        public void evaluate() throws Throwable {
            this.method.invokeExplosively(this.target, this.arguments);
        }
    }
}

