/*
 * Decompiled with CFR 0.152.
 */
package com.github.angleshq.angles.assertion.junit;

import com.github.angleshq.angles.assertion.AssertHelper;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.StringUtils;

public class AnglesJUnit5Assert {
    public void assertTrue(boolean condition) {
        AssertHelper.handleAssertEquals("AssertTrue", true, condition);
        Assertions.assertTrue((boolean)condition);
    }

    public void assertTrue(boolean condition, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertTrue", true, condition, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertTrue((boolean)condition, messageSupplier);
    }

    public void assertTrue(BooleanSupplier booleanSupplier) {
        AssertHelper.handleAssertEquals("AssertTrue", true, booleanSupplier.getAsBoolean());
        Assertions.assertTrue((BooleanSupplier)booleanSupplier);
    }

    public void assertTrue(BooleanSupplier booleanSupplier, String message) {
        AssertHelper.handleAssertEquals("AssertTrue", true, booleanSupplier.getAsBoolean(), message);
        Assertions.assertTrue((BooleanSupplier)booleanSupplier, (String)message);
    }

    public void assertTrue(boolean condition, String message) {
        AssertHelper.handleAssertEquals("AssertTrue", true, condition, message);
        Assertions.assertTrue((boolean)condition, (String)message);
    }

    public void assertTrue(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertTrue", true, booleanSupplier.getAsBoolean(), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertTrue((BooleanSupplier)booleanSupplier, messageSupplier);
    }

    public void assertFalse(boolean condition) {
        AssertHelper.handleAssertEquals("AssertFalse", false, condition);
        Assertions.assertFalse((boolean)condition);
    }

    public void assertFalse(boolean condition, String message) {
        AssertHelper.handleAssertEquals("AssertFalse", false, condition, message);
        Assertions.assertFalse((boolean)condition, (String)message);
    }

    public void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertFalse", false, condition, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertFalse((boolean)condition, messageSupplier);
    }

    public void assertFalse(BooleanSupplier booleanSupplier) {
        AssertHelper.handleAssertEquals("AssertFalse", false, booleanSupplier.getAsBoolean());
        Assertions.assertFalse((BooleanSupplier)booleanSupplier);
    }

    public void assertFalse(BooleanSupplier booleanSupplier, String message) {
        AssertHelper.handleAssertEquals("AssertFalse", false, booleanSupplier.getAsBoolean(), message);
        Assertions.assertFalse((BooleanSupplier)booleanSupplier, (String)message);
    }

    public void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertFalse", false, booleanSupplier.getAsBoolean(), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertFalse((BooleanSupplier)booleanSupplier, messageSupplier);
    }

    public void assertNull(Object actual) {
        AssertHelper.handleAssertEquals("AssertNull", null, actual);
        Assertions.assertNull((Object)actual);
    }

    public void assertNull(Object actual, String message) {
        AssertHelper.handleAssertEquals("AssertNull", null, actual, message);
        Assertions.assertNull((Object)actual, (String)message);
    }

    public void assertNull(Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertNull", null, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNull((Object)actual, messageSupplier);
    }

    public void assertNotNull(Object actual) {
        AssertHelper.handleAssertNotEquals("AssertNotNull", null, actual);
        Assertions.assertNotNull((Object)actual);
    }

    public void assertNotNull(Object actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotNull", null, actual, message);
        Assertions.assertNotNull((Object)actual, (String)message);
    }

    public void assertNotNull(Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotNull", null, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotNull((Object)actual, messageSupplier);
    }

    public void assertEquals(String expected, String actual) {
        AssertHelper.handleAssertEquals("AssertEquals (String/String)", expected, actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(String expected, String actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (String/String)", expected, actual, message);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
    }

    public void assertEquals(String expected, String actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (String/String)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertEquals(boolean expected, boolean actual) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean/boolean)", expected, actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, Boolean actual) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean/Boolean)", expected, actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, short actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Boolean/short)", expected, actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Boolean expected, Boolean actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Boolean/Boolean)", expected, actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(boolean expected, boolean actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean/boolean)", expected, actual, message);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
    }

    public void assertEquals(boolean expected, Boolean actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean/Boolean)", expected, actual, message);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
    }

    public void assertEquals(Boolean expected, boolean actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Boolean/boolean)", expected, actual, message);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
    }

    public void assertEquals(Boolean expected, Boolean actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Boolean/Boolean)", expected, actual, message);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
    }

    public void assertEquals(boolean expected, boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean/boolean)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertEquals(boolean expected, Boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean/Boolean)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertEquals(Boolean expected, boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Boolean/boolean)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertEquals(Boolean expected, Boolean actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Boolean/Boolean)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertEquals(short expected, short actual) {
        AssertHelper.handleAssertEquals("AssertEquals (short/short)", expected, actual);
        Assertions.assertEquals((short)expected, (short)actual);
    }

    public void assertEquals(short expected, Short actual) {
        AssertHelper.handleAssertEquals("AssertEquals (short/Short)", expected, actual);
        Assertions.assertEquals((short)expected, (Short)actual);
    }

    public void assertEquals(Short expected, short actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Short/short)", expected, actual);
        Assertions.assertEquals((Short)expected, (short)actual);
    }

    public void assertEquals(Short expected, Short actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Short/Short)", expected, actual);
        Assertions.assertEquals((Short)expected, (Short)actual);
    }

    public void assertEquals(short expected, short actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (short/short)", expected, actual, message);
        Assertions.assertEquals((short)expected, (short)actual, (String)message);
    }

    public void assertEquals(short expected, Short actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (short/Short)", expected, actual, message);
        Assertions.assertEquals((short)expected, (Short)actual, (String)message);
    }

    public void assertEquals(Short expected, short actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Short/short)", expected, actual, message);
        Assertions.assertEquals((Short)expected, (short)actual, (String)message);
    }

    public void assertEquals(Short expected, Short actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Short/Short)", expected, actual, message);
        Assertions.assertEquals((Short)expected, (Short)actual, (String)message);
    }

    public void assertEquals(short expected, short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (short/short)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((short)expected, (short)actual, messageSupplier);
    }

    public void assertEquals(short expected, Short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (short/Short)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((short)expected, (Short)actual, messageSupplier);
    }

    public void assertEquals(Short expected, short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Short/short)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Short)expected, (short)actual, messageSupplier);
    }

    public void assertEquals(Short expected, Short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Short/Short)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Short)expected, (Short)actual, messageSupplier);
    }

    public void assertEquals(byte expected, byte actual) {
        AssertHelper.handleAssertEquals("AssertEquals (byte/byte)", expected, actual);
        Assertions.assertEquals((byte)expected, (byte)actual);
    }

    public void assertEquals(byte expected, Byte actual) {
        AssertHelper.handleAssertEquals("AssertEquals (byte/Byte)", expected, actual);
        Assertions.assertEquals((byte)expected, (Byte)actual);
    }

    public void assertEquals(Byte expected, byte actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Byte/byte)", expected, actual);
        Assertions.assertEquals((Byte)expected, (byte)actual);
    }

    public void assertEquals(Byte expected, Byte actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Byte/Byte)", expected, actual);
        Assertions.assertEquals((Byte)expected, (Byte)actual);
    }

    public void assertEquals(byte expected, byte actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (byte/byte)", expected, actual, message);
        Assertions.assertEquals((byte)expected, (byte)actual, (String)message);
    }

    public void assertEquals(byte expected, Byte actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (byte/Byte)", expected, actual, message);
        Assertions.assertEquals((byte)expected, (Byte)actual, (String)message);
    }

    public void assertEquals(Byte expected, byte actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Byte/byte)", expected, actual, message);
        Assertions.assertEquals((Byte)expected, (byte)actual, (String)message);
    }

    public void assertEquals(Byte expected, Byte actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Byte/Byte)", expected, actual, message);
        Assertions.assertEquals((Byte)expected, (Byte)actual, (String)message);
    }

    public void assertEquals(byte expected, byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (byte/byte)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((byte)expected, (byte)actual, messageSupplier);
    }

    public void assertEquals(byte expected, Byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (byte/Byte)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((byte)expected, (Byte)actual, messageSupplier);
    }

    public void assertEquals(Byte expected, byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Byte/byte)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Byte)expected, (byte)actual, messageSupplier);
    }

    public void assertEquals(Byte expected, Byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Byte/Byte)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Byte)expected, (Byte)actual, messageSupplier);
    }

    public void assertEquals(int expected, int actual) {
        AssertHelper.handleAssertEquals("AssertEquals (int/int)", expected, actual);
        Assertions.assertEquals((int)expected, (int)actual);
    }

    public void assertEquals(int expected, Integer actual) {
        AssertHelper.handleAssertEquals("AssertEquals (int/Integer)", expected, actual);
        Assertions.assertEquals((int)expected, (Integer)actual);
    }

    public void assertEquals(Integer expected, int actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Integer/int)", expected, actual);
        Assertions.assertEquals((Integer)expected, (int)actual);
    }

    public void assertEquals(Integer expected, Integer actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Integer/Integer)", expected, actual);
        Assertions.assertEquals((Integer)expected, (Integer)actual);
    }

    public void assertEquals(int expected, int actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (int/int)", expected, actual, message);
        Assertions.assertEquals((int)expected, (int)actual, (String)message);
    }

    public void assertEquals(int expected, Integer actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (int/Integer)", expected, actual, message);
        Assertions.assertEquals((int)expected, (Integer)actual, (String)message);
    }

    public void assertEquals(Integer expected, int actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Integer/int)", expected, actual, message);
        Assertions.assertEquals((Integer)expected, (int)actual, (String)message);
    }

    public void assertEquals(Integer expected, Integer actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Integer/Integer)", expected, actual, message);
        Assertions.assertEquals((Integer)expected, (Integer)actual, (String)message);
    }

    public void assertEquals(int expected, int actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (int/int)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((int)expected, (int)actual, messageSupplier);
    }

    public void assertEquals(int expected, Integer actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (int/Integer)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((int)expected, (Integer)actual, messageSupplier);
    }

    public void assertEquals(Integer expected, int actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Integer/int)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Integer)expected, (int)actual, messageSupplier);
    }

    public void assertEquals(Integer expected, Integer actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Integer/Integer)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Integer)expected, (Integer)actual, messageSupplier);
    }

    public void assertEquals(long expected, long actual) {
        AssertHelper.handleAssertEquals("AssertEquals (long/long)", expected, actual);
        Assertions.assertEquals((long)expected, (long)actual);
    }

    public void assertEquals(long expected, Long actual) {
        AssertHelper.handleAssertEquals("AssertEquals (long/Long)", expected, actual);
        Assertions.assertEquals((long)expected, (Long)actual);
    }

    public void assertEquals(Long expected, long actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Long/long)", expected, actual);
        Assertions.assertEquals((Long)expected, (long)actual);
    }

    public void assertEquals(Long expected, Long actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Long/Long)", expected, actual);
        Assertions.assertEquals((Long)expected, (Long)actual);
    }

    public void assertEquals(long expected, long actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (long/long)", expected, actual, message);
        Assertions.assertEquals((long)expected, (long)actual, (String)message);
    }

    public void assertEquals(long expected, Long actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (long/Long)", expected, actual, message);
        Assertions.assertEquals((long)expected, (Long)actual, (String)message);
    }

    public void assertEquals(Long expected, long actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Long/long)", expected, actual, message);
        Assertions.assertEquals((Long)expected, (long)actual, (String)message);
    }

    public void assertEquals(Long expected, Long actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Long/Long)", expected, actual, message);
        Assertions.assertEquals((Long)expected, (Long)actual, (String)message);
    }

    public void assertEquals(long expected, long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (long/long)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((long)expected, (long)actual, messageSupplier);
    }

    public void assertEquals(long expected, Long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (long/Long)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((long)expected, (Long)actual, messageSupplier);
    }

    public void assertEquals(Long expected, long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Long/long)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Long)expected, (long)actual, messageSupplier);
    }

    public void assertEquals(Long expected, Long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Long/Long)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Long)expected, (Long)actual, messageSupplier);
    }

    public void assertEquals(float expected, float actual) {
        AssertHelper.handleAssertEquals("AssertEquals (float/float)", Float.valueOf(expected), Float.valueOf(actual));
        Assertions.assertEquals((float)expected, (float)actual);
    }

    public void assertEquals(float expected, Float actual) {
        AssertHelper.handleAssertEquals("AssertEquals (float/Float)", Float.valueOf(expected), actual);
        Assertions.assertEquals((float)expected, (Float)actual);
    }

    public void assertEquals(Float expected, float actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Float/float)", expected, Float.valueOf(actual));
        Assertions.assertEquals((Float)expected, (float)actual);
    }

    public void assertEquals(Float expected, Float actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Float/Float)", expected, actual);
        Assertions.assertEquals((Float)expected, (Float)actual);
    }

    public void assertEquals(float expected, float actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (float/float)", Float.valueOf(expected), Float.valueOf(actual), message);
        Assertions.assertEquals((float)expected, (float)actual, (String)message);
    }

    public void assertEquals(float expected, Float actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (float/Float)", Float.valueOf(expected), actual, message);
        Assertions.assertEquals((float)expected, (Float)actual, (String)message);
    }

    public void assertEquals(Float expected, float actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Float/float)", expected, Float.valueOf(actual), message);
        Assertions.assertEquals((Float)expected, (float)actual, (String)message);
    }

    public void assertEquals(Float expected, Float actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Float/Float)", expected, actual, message);
        Assertions.assertEquals((Float)expected, (Float)actual, (String)message);
    }

    public void assertEquals(float expected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (float/float)", Float.valueOf(expected), Float.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((float)expected, (float)actual, messageSupplier);
    }

    public void assertEquals(float expected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (float/Float)", Float.valueOf(expected), actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((float)expected, (Float)actual, messageSupplier);
    }

    public void assertEquals(Float expected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Float/float)", expected, Float.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Float)expected, (float)actual, messageSupplier);
    }

    public void assertEquals(Float expected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Float/Float)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Float)expected, (Float)actual, messageSupplier);
    }

    public void assertEquals(double expected, double actual) {
        AssertHelper.handleAssertEquals("AssertEquals (double/double)", expected, actual);
        Assertions.assertEquals((double)expected, (double)actual);
    }

    public void assertEquals(double expected, Double actual) {
        AssertHelper.handleAssertEquals("AssertEquals (double/Double)", expected, actual);
        Assertions.assertEquals((double)expected, (Double)actual);
    }

    public void assertEquals(Double expected, double actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Double/double)", expected, actual);
        Assertions.assertEquals((Double)expected, (double)actual);
    }

    public void assertEquals(Double expected, Double actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Double/Double)", expected, actual);
        Assertions.assertEquals((Double)expected, (Double)actual);
    }

    public void assertEquals(double expected, double actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (double/double)", expected, actual, message);
        Assertions.assertEquals((double)expected, (double)actual, (String)message);
    }

    public void assertEquals(double expected, Double actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (double/Double)", expected, actual, message);
        Assertions.assertEquals((double)expected, (Double)actual, (String)message);
    }

    public void assertEquals(Double expected, double actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Double/double)", expected, actual, message);
        Assertions.assertEquals((Double)expected, (double)actual, (String)message);
    }

    public void assertEquals(Double expected, Double actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Double/Double)", expected, actual, message);
        Assertions.assertEquals((Double)expected, (Double)actual, (String)message);
    }

    public void assertEquals(double expected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (double/double)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((double)expected, (double)actual, messageSupplier);
    }

    public void assertEquals(double expected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (double/Double)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((double)expected, (Double)actual, messageSupplier);
    }

    public void assertEquals(Double expected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Double/double)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Double)expected, (double)actual, messageSupplier);
    }

    public void assertEquals(Double expected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Double/Double)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Double)expected, (Double)actual, messageSupplier);
    }

    public void assertEquals(char expected, char actual) {
        AssertHelper.handleAssertEquals("AssertEquals (char/char)", Character.valueOf(expected), Character.valueOf(actual));
        Assertions.assertEquals((char)expected, (char)actual);
    }

    public void assertEquals(char expected, Character actual) {
        AssertHelper.handleAssertEquals("AssertEquals (char/Character)", Character.valueOf(expected), actual);
        Assertions.assertEquals((char)expected, (Character)actual);
    }

    public void assertEquals(Character expected, char actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Character/char)", expected, Character.valueOf(actual));
        Assertions.assertEquals((Character)expected, (char)actual);
    }

    public void assertEquals(Character expected, Character actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Character/Character)", expected, actual);
        Assertions.assertEquals((Character)expected, (Character)actual);
    }

    public void assertEquals(char expected, char actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (char/char)", Character.valueOf(expected), Character.valueOf(actual), message);
        Assertions.assertEquals((char)expected, (char)actual, (String)message);
    }

    public void assertEquals(char expected, Character actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (char/Character)", Character.valueOf(expected), actual, message);
        Assertions.assertEquals((char)expected, (Character)actual, (String)message);
    }

    public void assertEquals(Character expected, char actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Character/char)", expected, Character.valueOf(actual), message);
        Assertions.assertEquals((Character)expected, (char)actual, (String)message);
    }

    public void assertEquals(Character expected, Character actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Character/Character)", expected, actual, message);
        Assertions.assertEquals((Character)expected, (Character)actual, (String)message);
    }

    public void assertEquals(char expected, char actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (char/char)", Character.valueOf(expected), Character.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((char)expected, (char)actual, messageSupplier);
    }

    public void assertEquals(char expected, Character actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (char/Character)", Character.valueOf(expected), actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((char)expected, (Character)actual, messageSupplier);
    }

    public void assertEquals(Character expected, char actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Character/char)", expected, Character.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Character)expected, (char)actual, messageSupplier);
    }

    public void assertEquals(Character expected, Character actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Character/Character)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Character)expected, (Character)actual, messageSupplier);
    }

    public void assertEquals(Object expected, Object actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Object/Object)", expected, actual);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public void assertEquals(Object expected, Object actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Object/Object)", expected, actual, message);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
    }

    public void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Object/Object)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertEquals((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertArrayEquals(boolean[] expected, boolean[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean[]/boolean[])", expected, actual);
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual);
    }

    public void assertArrayEquals(boolean[] expected, boolean[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean[]/boolean[])", expected, actual, message);
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual, (String)message);
    }

    public void assertArrayEquals(boolean[] expected, boolean[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (boolean[]/boolean[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual, messageSupplier);
    }

    public void assertArrayEquals(char[] expected, char[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (char[]/char[])", expected, actual);
        Assertions.assertArrayEquals((char[])expected, (char[])actual);
    }

    public void assertArrayEquals(char[] expected, char[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (char[]/char[])", expected, actual, message);
        Assertions.assertArrayEquals((char[])expected, (char[])actual, (String)message);
    }

    public void assertArrayEquals(char[] expected, char[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (char[]/char[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((char[])expected, (char[])actual, messageSupplier);
    }

    public void assertArrayEquals(byte[] expected, byte[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (byte[]/byte[])", expected, actual);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    public void assertArrayEquals(byte[] expected, byte[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (byte[]/byte[])", expected, actual, message);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)message);
    }

    public void assertArrayEquals(byte[] expected, byte[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (byte[]/byte[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual, messageSupplier);
    }

    public void assertArrayEquals(short[] expected, short[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (short[]/short[])", expected, actual);
        Assertions.assertArrayEquals((short[])expected, (short[])actual);
    }

    public void assertArrayEquals(short[] expected, short[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (short[]/short[])", expected, actual, message);
        Assertions.assertArrayEquals((short[])expected, (short[])actual, (String)message);
    }

    public void assertArrayEquals(short[] expected, short[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (short[]/short[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((short[])expected, (short[])actual, messageSupplier);
    }

    public void assertArrayEquals(int[] expected, int[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (int[]/int[])", expected, actual);
        Assertions.assertArrayEquals((int[])expected, (int[])actual);
    }

    public void assertArrayEquals(int[] expected, int[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (int[]/int[])", expected, actual, message);
        Assertions.assertArrayEquals((int[])expected, (int[])actual, (String)message);
    }

    public void assertArrayEquals(int[] expected, int[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (int[]/int[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((int[])expected, (int[])actual, messageSupplier);
    }

    public void assertArrayEquals(long[] expected, long[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (long[]/long[])", expected, actual);
        Assertions.assertArrayEquals((long[])expected, (long[])actual);
    }

    public void assertArrayEquals(long[] expected, long[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (long[]/long[])", expected, actual, message);
        Assertions.assertArrayEquals((long[])expected, (long[])actual, (String)message);
    }

    public void assertArrayEquals(long[] expected, long[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (long[]/long[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((long[])expected, (long[])actual, messageSupplier);
    }

    public void assertArrayEquals(float[] expected, float[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (float[]/float[])", expected, actual);
        Assertions.assertArrayEquals((float[])expected, (float[])actual);
    }

    public void assertArrayEquals(float[] expected, float[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (float[]/float[])", expected, actual, message);
        Assertions.assertArrayEquals((float[])expected, (float[])actual, (String)message);
    }

    public void assertArrayEquals(float[] expected, float[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (float[]/float[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((float[])expected, (float[])actual, messageSupplier);
    }

    public void assertArrayEquals(double[] expected, double[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (double[]/double[])", expected, actual);
        Assertions.assertArrayEquals((double[])expected, (double[])actual);
    }

    public void assertArrayEquals(double[] expected, double[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (double[]/double[])", expected, actual, message);
        Assertions.assertArrayEquals((double[])expected, (double[])actual, (String)message);
    }

    public void assertArrayEquals(double[] expected, double[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (double[]/double[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((double[])expected, (double[])actual, messageSupplier);
    }

    public void assertArrayEquals(Object[] expected, Object[] actual) {
        AssertHelper.handleAssertEquals("AssertEquals (Object[]/Object[])", expected, actual);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    public void assertArrayEquals(Object[] expected, Object[] actual, String message) {
        AssertHelper.handleAssertEquals("AssertEquals (Object[]/Object[])", expected, actual, message);
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)message);
    }

    public void assertArrayEquals(Object[] expected, Object[] actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertEquals("AssertEquals (Object[]/Object[])", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, messageSupplier);
    }

    public void assertNotEquals(byte unexpected, byte actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (byte/byte)", unexpected, actual);
        Assertions.assertNotEquals((byte)unexpected, (byte)actual);
    }

    public void assertNotEquals(byte unexpected, Byte actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (byte/Byte)", unexpected, actual);
        Assertions.assertNotEquals((byte)unexpected, (Byte)actual);
    }

    public void assertNotEquals(Byte unexpected, byte actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Byte/byte)", unexpected, actual);
        Assertions.assertNotEquals((Byte)unexpected, (byte)actual);
    }

    public void assertNotEquals(Byte unexpected, Byte actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Byte/Byte)", unexpected, actual);
        Assertions.assertNotEquals((Byte)unexpected, (Byte)actual);
    }

    public void assertNotEquals(byte unexpected, byte actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (byte/byte)", unexpected, actual, message);
        Assertions.assertNotEquals((byte)unexpected, (byte)actual, (String)message);
    }

    public void assertNotEquals(byte unexpected, Byte actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (byte/Byte)", unexpected, actual, message);
        Assertions.assertNotEquals((byte)unexpected, (Byte)actual, (String)message);
    }

    public void assertNotEquals(Byte unexpected, byte actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Byte/byte)", unexpected, actual, message);
        Assertions.assertNotEquals((Byte)unexpected, (byte)actual, (String)message);
    }

    public void assertNotEquals(Byte unexpected, Byte actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Byte/Byte)", unexpected, actual, message);
        Assertions.assertNotEquals((Byte)unexpected, (Byte)actual, (String)message);
    }

    public void assertNotEquals(byte unexpected, byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (byte/byte)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((byte)unexpected, (byte)actual, messageSupplier);
    }

    public void assertNotEquals(byte unexpected, Byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (byte/Byte)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((byte)unexpected, (Byte)actual, messageSupplier);
    }

    public void assertNotEquals(Byte unexpected, byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Byte/byte)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Byte)unexpected, (byte)actual, messageSupplier);
    }

    public void assertNotEquals(Byte unexpected, Byte actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Byte/Byte)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Byte)unexpected, (Byte)actual, messageSupplier);
    }

    public void assertNotEquals(short unexpected, short actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (short/short)", unexpected, actual);
        Assertions.assertNotEquals((short)unexpected, (short)actual);
    }

    public void assertNotEquals(short unexpected, Short actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (short/Short)", unexpected, actual);
        Assertions.assertNotEquals((short)unexpected, (Short)actual);
    }

    public void assertNotEquals(Short unexpected, short actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Short/short)", unexpected, actual);
        Assertions.assertNotEquals((Short)unexpected, (short)actual);
    }

    public void assertNotEquals(Short unexpected, Short actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Short/Short)", unexpected, actual);
        Assertions.assertNotEquals((Short)unexpected, (Short)actual);
    }

    public void assertNotEquals(short unexpected, short actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (short/short)", unexpected, actual, message);
        Assertions.assertNotEquals((short)unexpected, (short)actual, (String)message);
    }

    public void assertNotEquals(short unexpected, Short actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (short/Short)", unexpected, actual, message);
        Assertions.assertNotEquals((short)unexpected, (Short)actual, (String)message);
    }

    public void assertNotEquals(Short unexpected, short actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Short/short)", unexpected, actual, message);
        Assertions.assertNotEquals((Short)unexpected, (short)actual, (String)message);
    }

    public void assertNotEquals(Short unexpected, Short actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Short/Short)", unexpected, actual, message);
        Assertions.assertNotEquals((Short)unexpected, (Short)actual, (String)message);
    }

    public void assertNotEquals(short unexpected, short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (short/short)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((short)unexpected, (short)actual, messageSupplier);
    }

    public void assertNotEquals(short unexpected, Short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (short/Short)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((short)unexpected, (Short)actual, messageSupplier);
    }

    public void assertNotEquals(Short unexpected, short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Short/short)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Short)unexpected, (short)actual, messageSupplier);
    }

    public void assertNotEquals(Short unexpected, Short actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Short/Short)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Short)unexpected, (Short)actual, messageSupplier);
    }

    public void assertNotEquals(int unexpected, int actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (int/int)", unexpected, actual);
        Assertions.assertNotEquals((int)unexpected, (int)actual);
    }

    public void assertNotEquals(int unexpected, Integer actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (int/Integer)", unexpected, actual);
        Assertions.assertNotEquals((int)unexpected, (Integer)actual);
    }

    public void assertNotEquals(Integer unexpected, int actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Integer/int)", unexpected, actual);
        Assertions.assertNotEquals((Integer)unexpected, (int)actual);
    }

    public void assertNotEquals(Integer unexpected, Integer actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Integer/Integer)", unexpected, actual);
        Assertions.assertNotEquals((Integer)unexpected, (Integer)actual);
    }

    public void assertNotEquals(int unexpected, int actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (int/int)", unexpected, actual, message);
        Assertions.assertNotEquals((int)unexpected, (int)actual, (String)message);
    }

    public void assertNotEquals(int unexpected, Integer actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (int/Integer)", unexpected, actual, message);
        Assertions.assertNotEquals((int)unexpected, (Integer)actual, (String)message);
    }

    public void assertNotEquals(Integer unexpected, int actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Integer/int)", unexpected, actual, message);
        Assertions.assertNotEquals((Integer)unexpected, (int)actual, (String)message);
    }

    public void assertNotEquals(Integer unexpected, Integer actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Integer/Integer)", unexpected, actual, message);
        Assertions.assertNotEquals((Integer)unexpected, (Integer)actual, (String)message);
    }

    public void assertNotEquals(int unexpected, int actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (int/int)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((int)unexpected, (int)actual, messageSupplier);
    }

    public void assertNotEquals(int unexpected, Integer actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (int/Integer)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((int)unexpected, (Integer)actual, messageSupplier);
    }

    public void assertNotEquals(Integer unexpected, int actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Integer/int)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Integer)unexpected, (int)actual, messageSupplier);
    }

    public void assertNotEquals(Integer unexpected, Integer actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Integer/Integer)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Integer)unexpected, (Integer)actual, messageSupplier);
    }

    public void assertNotEquals(long unexpected, long actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (long/long)", unexpected, actual);
        Assertions.assertNotEquals((long)unexpected, (long)actual);
    }

    public void assertNotEquals(long unexpected, Long actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (long/Long)", unexpected, actual);
        Assertions.assertNotEquals((long)unexpected, (Long)actual);
    }

    public void assertNotEquals(Long unexpected, long actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Long/long)", unexpected, actual);
        Assertions.assertNotEquals((Long)unexpected, (long)actual);
    }

    public void assertNotEquals(Long unexpected, Long actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Long/Long)", unexpected, actual);
        Assertions.assertNotEquals((Long)unexpected, (Long)actual);
    }

    public void assertNotEquals(long unexpected, long actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (long/long)", unexpected, actual, message);
        Assertions.assertNotEquals((long)unexpected, (long)actual, (String)message);
    }

    public void assertNotEquals(long unexpected, Long actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (long/Long)", unexpected, actual, message);
        Assertions.assertNotEquals((long)unexpected, (Long)actual, (String)message);
    }

    public void assertNotEquals(Long unexpected, long actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Long/long)", unexpected, actual, message);
        Assertions.assertNotEquals((Long)unexpected, (long)actual, (String)message);
    }

    public void assertNotEquals(Long unexpected, Long actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Long/Long)", unexpected, actual, message);
        Assertions.assertNotEquals((Long)unexpected, (Long)actual, (String)message);
    }

    public void assertNotEquals(long unexpected, long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (long/long)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((long)unexpected, (long)actual, messageSupplier);
    }

    public void assertNotEquals(long unexpected, Long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (long/Long)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((long)unexpected, (Long)actual, messageSupplier);
    }

    public void assertNotEquals(Long unexpected, long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Long/long)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Long)unexpected, (long)actual, messageSupplier);
    }

    public void assertNotEquals(Long unexpected, Long actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Long/Long)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Long)unexpected, (Long)actual, messageSupplier);
    }

    public void assertNotEquals(float unexpected, float actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (float/float)", Float.valueOf(unexpected), Float.valueOf(actual));
        Assertions.assertNotEquals((float)unexpected, (float)actual);
    }

    public void assertNotEquals(float unexpected, Float actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (float/Float)", Float.valueOf(unexpected), actual);
        Assertions.assertNotEquals((float)unexpected, (Float)actual);
    }

    public void assertNotEquals(Float unexpected, float actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Float/float)", unexpected, Float.valueOf(actual));
        Assertions.assertNotEquals((Float)unexpected, (float)actual);
    }

    public void assertNotEquals(Float unexpected, Float actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Float/Float)", unexpected, actual);
        Assertions.assertNotEquals((Float)unexpected, (Float)actual);
    }

    public void assertNotEquals(float unexpected, float actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (float/float)", Float.valueOf(unexpected), Float.valueOf(actual), message);
        Assertions.assertNotEquals((float)unexpected, (float)actual, (String)message);
    }

    public void assertNotEquals(float unexpected, Float actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (float/Float)", Float.valueOf(unexpected), actual, message);
        Assertions.assertNotEquals((float)unexpected, (Float)actual, (String)message);
    }

    public void assertNotEquals(Float unexpected, float actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Float/float)", unexpected, Float.valueOf(actual), message);
        Assertions.assertNotEquals((Float)unexpected, (float)actual, (String)message);
    }

    public void assertNotEquals(Float unexpected, Float actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Float/Float)", unexpected, actual, message);
        Assertions.assertNotEquals((Float)unexpected, (Float)actual, (String)message);
    }

    public void assertNotEquals(float unexpected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (float/float)", Float.valueOf(unexpected), Float.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((float)unexpected, (float)actual, messageSupplier);
    }

    public void assertNotEquals(float unexpected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (float/Float)", Float.valueOf(unexpected), actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((float)unexpected, (Float)actual, messageSupplier);
    }

    public void assertNotEquals(Float unexpected, float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Float/float)", unexpected, Float.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Float)unexpected, (float)actual, messageSupplier);
    }

    public void assertNotEquals(Float unexpected, Float actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Float/Float)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Float)unexpected, (Float)actual, messageSupplier);
    }

    public void assertNotEquals(double unexpected, double actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (double/double)", unexpected, actual);
        Assertions.assertNotEquals((double)unexpected, (double)actual);
    }

    public void assertNotEquals(double unexpected, Double actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (double/Double)", unexpected, actual);
        Assertions.assertNotEquals((double)unexpected, (Double)actual);
    }

    public void assertNotEquals(Double unexpected, double actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Double/double)", unexpected, actual);
        Assertions.assertNotEquals((Double)unexpected, (double)actual);
    }

    public void assertNotEquals(Double unexpected, Double actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Double/Double)", unexpected, actual);
        Assertions.assertNotEquals((Double)unexpected, (Double)actual);
    }

    public void assertNotEquals(double unexpected, double actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (double/double)", unexpected, actual, message);
        Assertions.assertNotEquals((double)unexpected, (double)actual, (String)message);
    }

    public void assertNotEquals(double unexpected, Double actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (double/Double)", unexpected, actual, message);
        Assertions.assertNotEquals((double)unexpected, (Double)actual, (String)message);
    }

    public void assertNotEquals(Double unexpected, double actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Double/double)", unexpected, actual, message);
        Assertions.assertNotEquals((Double)unexpected, (double)actual, (String)message);
    }

    public void assertNotEquals(Double unexpected, Double actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Double/Double)", unexpected, actual, message);
        Assertions.assertNotEquals((Double)unexpected, (Double)actual, (String)message);
    }

    public void assertNotEquals(double unexpected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (double/double)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((double)unexpected, (double)actual, messageSupplier);
    }

    public void assertNotEquals(double unexpected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (double/Double)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((double)unexpected, (Double)actual, messageSupplier);
    }

    public void assertNotEquals(Double unexpected, double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Double/double)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Double)unexpected, (double)actual, messageSupplier);
    }

    public void assertNotEquals(Double unexpected, Double actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Double/Double)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Double)unexpected, (Double)actual, messageSupplier);
    }

    public void assertNotEquals(char unexpected, char actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (char/char)", Character.valueOf(unexpected), Character.valueOf(actual));
        Assertions.assertNotEquals((char)unexpected, (char)actual);
    }

    public void assertNotEquals(char unexpected, Character actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (char/Character)", Character.valueOf(unexpected), actual);
        Assertions.assertNotEquals((char)unexpected, (Character)actual);
    }

    public void assertNotEquals(Character unexpected, char actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Character/char)", unexpected, Character.valueOf(actual));
        Assertions.assertNotEquals((Character)unexpected, (char)actual);
    }

    public void assertNotEquals(Character unexpected, Character actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Character/Character)", unexpected, actual);
        Assertions.assertNotEquals((Character)unexpected, (Character)actual);
    }

    public void assertNotEquals(char unexpected, char actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (char/char)", Character.valueOf(unexpected), Character.valueOf(actual), message);
        Assertions.assertNotEquals((char)unexpected, (char)actual, (String)message);
    }

    public void assertNotEquals(char unexpected, Character actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (char/Character)", Character.valueOf(unexpected), actual, message);
        Assertions.assertNotEquals((char)unexpected, (Character)actual, (String)message);
    }

    public void assertNotEquals(Character unexpected, char actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Character/char)", unexpected, Character.valueOf(actual), message);
        Assertions.assertNotEquals((Character)unexpected, (char)actual, (String)message);
    }

    public void assertNotEquals(Character unexpected, Character actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Character/Character)", unexpected, actual, message);
        Assertions.assertNotEquals((Character)unexpected, (Character)actual, (String)message);
    }

    public void assertNotEquals(char unexpected, char actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (char/char)", Character.valueOf(unexpected), Character.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((char)unexpected, (char)actual, messageSupplier);
    }

    public void assertNotEquals(char unexpected, Character actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (char/Character)", Character.valueOf(unexpected), actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((char)unexpected, (Character)actual, messageSupplier);
    }

    public void assertNotEquals(Character unexpected, char actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Character/char)", unexpected, Character.valueOf(actual), this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Character)unexpected, (char)actual, messageSupplier);
    }

    public void assertNotEquals(Character unexpected, Character actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Character/Character)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Character)unexpected, (Character)actual, messageSupplier);
    }

    public void assertNotEquals(Object unexpected, Object actual) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Object/Object)", unexpected, actual);
        Assertions.assertNotEquals((Object)unexpected, (Object)actual);
    }

    public void assertNotEquals(Object unexpected, Object actual, String message) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Object/Object)", unexpected, actual, message);
        Assertions.assertNotEquals((Object)unexpected, (Object)actual, (String)message);
    }

    public void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotEquals("AssertNotEquals (Object/Object)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotEquals((Object)unexpected, (Object)actual, messageSupplier);
    }

    public void assertSame(Object expected, Object actual) {
        AssertHelper.handleAssertSame("AssertSame (Object/Object)", expected, actual);
        Assertions.assertSame((Object)expected, (Object)actual);
    }

    public void assertSame(Object expected, Object actual, String message) {
        AssertHelper.handleAssertSame("AssertSame (Object/Object)", expected, actual, message);
        Assertions.assertSame((Object)expected, (Object)actual, (String)message);
    }

    public void assertSame(Object expected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertSame("AssertSame (Object/Object)", expected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertSame((Object)expected, (Object)actual, messageSupplier);
    }

    public void assertNotSame(Object unexpected, Object actual) {
        AssertHelper.handleAssertNotSame("AssertNotSame (Object/Object)", unexpected, actual);
        Assertions.assertNotSame((Object)unexpected, (Object)actual);
    }

    public void assertNotSame(Object unexpected, Object actual, String message) {
        AssertHelper.handleAssertNotSame("AssertNotSame (Object/Object)", unexpected, actual, message);
        Assertions.assertNotSame((Object)unexpected, (Object)actual, (String)message);
    }

    public void assertNotSame(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        AssertHelper.handleAssertNotSame("AssertNotSame (Object/Object)", unexpected, actual, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertNotSame((Object)unexpected, (Object)actual, messageSupplier);
    }

    public void assertDoesNotThrow(Executable executable) {
        AssertHelper.handleDoesNotThrow("AssertDoesNotThrow", executable);
        Assertions.assertDoesNotThrow((Executable)executable);
    }

    public void assertDoesNotThrow(Executable executable, String message) {
        AssertHelper.handleDoesNotThrow("AssertDoesNotThrow", executable, message);
        Assertions.assertDoesNotThrow((Executable)executable, (String)message);
    }

    public void assertDoesNotThrow(Executable executable, Supplier<String> messageSupplier) {
        AssertHelper.handleDoesNotThrow("AssertDoesNotThrow", executable, this.buildPrefix(this.nullSafeGet(messageSupplier)));
        Assertions.assertDoesNotThrow((Executable)executable, messageSupplier);
    }

    public void assertThrowsException(Class expected, Executable executable, String ... info) {
        String message = info.length > 0 ? info[0] : "";
        Assertions.assertThrows((Class)expected, (Executable)AssertHelper.handleThrows("AssertThrows " + expected.toString(), expected, executable, message));
    }

    public void assertGreaterThan(Double value1, Double value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan(value1, value2));
    }

    public void assertLessThan(Double value1, Double value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan(value1, value2));
    }

    public void assertGreaterThan(Integer value1, Integer value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan(value1, value2));
    }

    public void assertLessThan(Integer value1, Integer value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan(value1, value2));
    }

    public void assertGreaterThan(Float value1, Float value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan(value1, value2));
    }

    public void assertLessThan(Float value1, Float value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan(value1, value2));
    }

    public void assertGreaterThan(String value1, String value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertGreaterThan(value1, value2));
    }

    public void assertLessThan(String value1, String value2) {
        Assertions.assertEquals((Object)true, (Object)AssertHelper.anglesAssertLessThan(value1, value2));
    }

    private String buildPrefix(String message) {
        return StringUtils.isNotBlank((String)message) ? message + " ==> " : "";
    }

    private String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

