package timber.log;

public enum Level {

    OFF(0, ""),
    FATAL(1, "FATAL"),
    ERROR(2, "ERROR"),
    WARN(3, "WARN"),
    INFO(4, "INFO"),
    DEBUG(5, "DEBUG"),
    TRACE(6, "TRACE");

    private final String levelName;
    private final Integer levelCode;

    Level(Integer levelCode, String levelName) {
        this.levelCode = levelCode;
        this.levelName = levelName;
    }

    public Integer getLevelCode() {
        return levelCode;
    }

    public String getLevelName() {
        return levelName;
    }

    /**
     * Compare two levels.
     * <br/>
     * • If result is positive, {@code l1} < {@code l2}.<br/>
     * • If result is negative, {@code l1} > {@code l2}.<br/>
     * • If result is zero, {@code l1} = {@code l2}
     *
     * @param l1 The first level to compare
     * @param l2 The second level to compare
     * @return The difference between each codes.
     */
    public static int compare(Level l1, Level l2) {
        return l1.getLevelCode() - l2.getLevelCode();
    }

}
