/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.binary;

public class Base64 {
    private static final char[] baseChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static String encode(byte[] value) {
        return Base64.encode(value, false);
    }

    public static String encode(byte[] value, boolean format) {
        int byte1;
        if (value == null) {
            return null;
        }
        int length = value.length;
        int tripletNum = length / 3;
        int tripletRest = length % 3;
        int linelen = 0;
        StringBuilder sb = new StringBuilder(tripletNum * 4 + 4);
        int index = 0;
        for (int i = 0; i < tripletNum; ++i) {
            byte1 = value[index++] & 0xFF;
            int byte2 = value[index++] & 0xFF;
            int byte3 = value[index++] & 0xFF;
            int char1 = byte1 >> 2;
            int char2 = byte1 << 4 & 0x3F | byte2 >> 4;
            int char3 = byte2 << 2 & 0x3F | byte3 >> 6;
            int char4 = byte3 & 0x3F;
            sb.append(baseChars[char1]);
            sb.append(baseChars[char2]);
            sb.append(baseChars[char3]);
            sb.append(baseChars[char4]);
            if (!format || (linelen += 4) < 76) continue;
            linelen = 0;
            sb.append('\n');
        }
        if (tripletRest > 0) {
            int byte0 = value[index++] & 0xFF;
            sb.append(baseChars[byte0 >> 2]);
            if (tripletRest == 1) {
                sb.append(baseChars[byte0 << 4 & 0x3F]);
                sb.append("==");
            } else {
                byte1 = value[index++] & 0xFF;
                sb.append(baseChars[byte0 << 4 & 0x3F | byte1 >> 4]);
                sb.append(baseChars[byte1 << 2 & 0x3F]);
                sb.append('=');
            }
        }
        return sb.toString();
    }

    public static byte[] decode(String value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return new byte[0];
        }
        int pos = value.indexOf(10);
        if (pos > -1) {
            int lastpos = 0;
            StringBuilder sb = new StringBuilder(value.length());
            while (pos > -1) {
                sb.append(value.substring(lastpos, pos).trim());
                lastpos = pos + 1;
                pos = value.indexOf(10, lastpos);
            }
            sb.append(value.substring(lastpos).trim());
            value = sb.toString();
        }
        value = value.trim();
        int length = value.length();
        int quaternionNum = length / 4;
        if (length % 4 != 0) {
            throw new IllegalArgumentException("The input string is not valid base64 string. Length must be devided by four");
        }
        int lastQuaternionsize = 0;
        int lastQuaternionbytesize = 0;
        if (value.charAt(length - 2) == '=') {
            lastQuaternionsize = 2;
            lastQuaternionbytesize = 1;
            --quaternionNum;
        } else if (value.charAt(length - 1) == '=') {
            lastQuaternionsize = 3;
            lastQuaternionbytesize = 2;
            --quaternionNum;
        }
        byte[] buff = new byte[3 * quaternionNum + lastQuaternionbytesize];
        int sIndex = 0;
        int bIndex = 0;
        for (int i = 0; i < quaternionNum; ++i) {
            int char1 = Base64.char2int(value.charAt(sIndex++));
            int char2 = Base64.char2int(value.charAt(sIndex++));
            int char3 = Base64.char2int(value.charAt(sIndex++));
            int char4 = Base64.char2int(value.charAt(sIndex++));
            buff[bIndex++] = (byte)(char1 << 2 | char2 >> 4);
            buff[bIndex++] = (byte)(char2 << 4 | char3 >> 2);
            buff[bIndex++] = (byte)(char3 << 6 | char4);
        }
        if (lastQuaternionsize > 0) {
            int char1 = Base64.char2int(value.charAt(sIndex++));
            int char2 = Base64.char2int(value.charAt(sIndex++));
            buff[bIndex++] = (byte)(char1 << 2 | char2 >> 4);
            if (lastQuaternionsize > 2) {
                int char3 = Base64.char2int(value.charAt(sIndex++));
                buff[bIndex++] = (byte)(char2 << 4 | char3 >> 2);
            }
        }
        return buff;
    }

    private static int char2int(char c) {
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 0;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        throw new IllegalArgumentException("The char '" + c + "' is not valid base64 char.");
    }
}

