/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import sk.antons.jaul.Is;

public class FromString {
    private String value;
    private boolean defaultEmptyValue = true;
    private boolean ignoreBadValue = false;

    public FromString(String value) {
        this.value = value;
    }

    public FromString(String value, boolean defaultEmptyValue, boolean ignoreBadValue) {
        this.value = value;
        this.defaultEmptyValue = defaultEmptyValue;
        this.ignoreBadValue = ignoreBadValue;
    }

    public int intValue(int defaultValue) {
        int rv;
        block4: {
            if (Is.empty(this.value)) {
                if (this.defaultEmptyValue) {
                    return defaultValue;
                }
                throw new NumberFormatException("Unable to tarse int from empty value");
            }
            rv = defaultValue;
            try {
                rv = Integer.parseInt(this.value);
            }
            catch (NumberFormatException e) {
                if (this.ignoreBadValue) break block4;
                throw e;
            }
        }
        return rv;
    }

    public int intValue() {
        return this.intValue(0);
    }

    public long longValue(long defaultValue) {
        long rv;
        block4: {
            if (Is.empty(this.value)) {
                if (this.defaultEmptyValue) {
                    return defaultValue;
                }
                throw new NumberFormatException("Unable to tarse long from empty value");
            }
            rv = defaultValue;
            try {
                rv = Long.parseLong(this.value);
            }
            catch (NumberFormatException e) {
                if (this.ignoreBadValue) break block4;
                throw e;
            }
        }
        return rv;
    }

    public long longValue() {
        return this.longValue(0L);
    }

    public float floatValue(float defaultValue) {
        float rv;
        block4: {
            if (Is.empty(this.value)) {
                if (this.defaultEmptyValue) {
                    return defaultValue;
                }
                throw new NumberFormatException("Unable to tarse float from empty value");
            }
            rv = defaultValue;
            this.value = this.value.replace(',', '.');
            try {
                rv = Float.parseFloat(this.value);
            }
            catch (NumberFormatException e) {
                if (this.ignoreBadValue) break block4;
                throw e;
            }
        }
        return rv;
    }

    public float floatValue() {
        return this.floatValue(0.0f);
    }

    public double doubleValue(double defaultValue) {
        double rv;
        block4: {
            if (Is.empty(this.value)) {
                if (this.defaultEmptyValue) {
                    return defaultValue;
                }
                throw new NumberFormatException("Unable to tarse double from empty value");
            }
            rv = defaultValue;
            this.value = this.value.replace(',', '.');
            try {
                rv = Double.parseDouble(this.value);
            }
            catch (NumberFormatException e) {
                if (this.ignoreBadValue) break block4;
                throw e;
            }
        }
        return rv;
    }

    public double doubleValue() {
        return this.doubleValue(0.0);
    }

    public boolean booleanValue(boolean defaultValue) {
        if (Is.empty(this.value)) {
            if (this.defaultEmptyValue) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Unable to tarse boolean from empty value");
        }
        boolean rv = defaultValue;
        this.value = this.value.toLowerCase();
        if ("true".equals(this.value)) {
            return true;
        }
        if ("yes".equals(this.value)) {
            return true;
        }
        return "1".equals(this.value);
    }

    public boolean booleanValue() {
        return this.booleanValue(false);
    }

    public Date dateValue(Date defaultValue, String format) {
        Date rv;
        block5: {
            if (Is.empty(this.value)) {
                if (this.defaultEmptyValue) {
                    return defaultValue;
                }
                throw new IllegalArgumentException("Unable to tarse date from empty value");
            }
            if (Is.empty(format)) {
                throw new IllegalArgumentException("Unable to tarse date using empty format");
            }
            rv = defaultValue;
            this.value = this.value.replace(',', '.');
            try {
                SimpleDateFormat df = new SimpleDateFormat(format);
                rv = df.parse(this.value);
            }
            catch (ParseException e) {
                if (this.ignoreBadValue) break block5;
                throw new IllegalArgumentException(e);
            }
        }
        return rv;
    }

    public Date dateValue(String format) {
        return this.dateValue(null, format);
    }
}

