/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.binary;

import java.util.Arrays;

public class Any64 {
    private char[] charset;
    private Node root;

    public Any64(char[] charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Null charset");
        }
        if (charset.length != 64) {
            throw new IllegalArgumentException("Charset has no 64 characters but " + charset.length);
        }
        this.charset = new char[64];
        System.arraycopy(charset, 0, this.charset, 0, 64);
        Arrays.sort(this.charset);
        this.root = this.buildtree();
    }

    public static Any64 instance(char[] charset) {
        return new Any64(charset);
    }

    public static Any64 instance(char plus, char slash) {
        char[] baseChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', plus, slash};
        return new Any64(baseChars);
    }

    public String encode(byte[] value) {
        int byte1;
        if (value == null) {
            return null;
        }
        int length = value.length;
        int tripletNum = length / 3;
        int tripletRest = length % 3;
        int linelen = 0;
        StringBuilder sb = new StringBuilder(tripletNum * 4 + 4);
        int index = 0;
        for (int i = 0; i < tripletNum; ++i) {
            byte1 = value[index++] & 0xFF;
            int byte2 = value[index++] & 0xFF;
            int byte3 = value[index++] & 0xFF;
            int char1 = byte1 >> 2;
            int char2 = byte1 << 4 & 0x3F | byte2 >> 4;
            int char3 = byte2 << 2 & 0x3F | byte3 >> 6;
            int char4 = byte3 & 0x3F;
            sb.append(this.charset[char1]);
            sb.append(this.charset[char2]);
            sb.append(this.charset[char3]);
            sb.append(this.charset[char4]);
            linelen += 4;
        }
        if (tripletRest > 0) {
            int byte0 = value[index++] & 0xFF;
            sb.append(this.charset[byte0 >> 2]);
            if (tripletRest == 1) {
                sb.append(this.charset[byte0 << 4 & 0x3F]);
            } else {
                byte1 = value[index++] & 0xFF;
                sb.append(this.charset[byte0 << 4 & 0x3F | byte1 >> 4]);
                sb.append(this.charset[byte1 << 2 & 0x3F]);
            }
        }
        return sb.toString();
    }

    public byte[] decode(String value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value)) {
            return new byte[0];
        }
        int length = value.length();
        int quaternionNum = length / 4;
        int quaternionRest = length % 4;
        int lastQuaternionsize = 0;
        int lastQuaternionbytesize = 0;
        if (quaternionRest == 1) {
            throw new IllegalArgumentException("Illegal length of encoded string");
        }
        if (quaternionRest == 2) {
            lastQuaternionsize = 2;
            lastQuaternionbytesize = 1;
        } else if (quaternionRest == 3) {
            lastQuaternionsize = 3;
            lastQuaternionbytesize = 2;
        }
        byte[] buff = new byte[3 * quaternionNum + lastQuaternionbytesize];
        int sIndex = 0;
        int bIndex = 0;
        for (int i = 0; i < quaternionNum; ++i) {
            int char1 = this.char2int(value.charAt(sIndex++));
            int char2 = this.char2int(value.charAt(sIndex++));
            int char3 = this.char2int(value.charAt(sIndex++));
            int char4 = this.char2int(value.charAt(sIndex++));
            buff[bIndex++] = (byte)(char1 << 2 | char2 >> 4);
            buff[bIndex++] = (byte)(char2 << 4 | char3 >> 2);
            buff[bIndex++] = (byte)(char3 << 6 | char4);
        }
        if (lastQuaternionsize > 0) {
            int char1 = this.char2int(value.charAt(sIndex++));
            int char2 = this.char2int(value.charAt(sIndex++));
            buff[bIndex++] = (byte)(char1 << 2 | char2 >> 4);
            if (lastQuaternionsize > 2) {
                int char3 = this.char2int(value.charAt(sIndex++));
                buff[bIndex++] = (byte)(char2 << 4 | char3 >> 2);
            }
        }
        return buff;
    }

    private int char2int(char c) {
        return this.char2int(c, this.root);
    }

    private int char2int(char c, int lindex, int uindex) {
        int isize = uindex - lindex;
        if (isize < 2) {
            if (c == this.charset[lindex]) {
                return lindex;
            }
            throw new IllegalArgumentException("The char '" + c + "' is not valid base64 char.");
        }
        int pivot = lindex + isize / 2;
        char cc = this.charset[pivot];
        if (c == cc) {
            return pivot;
        }
        if (c < cc) {
            return this.char2int(c, lindex, pivot);
        }
        return this.char2int(c, pivot + 1, uindex);
    }

    private int char2int(char c, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The char '" + c + "' is not valid base64 char.");
        }
        if (c == node.c) {
            return node.index;
        }
        if (c < node.c) {
            return this.char2int(c, node.left);
        }
        return this.char2int(c, node.right);
    }

    private Node buildtree() {
        Node node0 = new Node(this.charset[0], 0, null, null);
        Node node1 = new Node(this.charset[1], 1, node0, null);
        Node node3 = new Node(this.charset[3], 3, null, null);
        Node node2 = new Node(this.charset[2], 2, node1, node3);
        Node node5 = new Node(this.charset[5], 5, null, null);
        Node node7 = new Node(this.charset[7], 7, null, null);
        Node node6 = new Node(this.charset[6], 6, node5, node7);
        Node node4 = new Node(this.charset[4], 4, node2, node6);
        Node node9 = new Node(this.charset[9], 9, null, null);
        Node node11 = new Node(this.charset[11], 11, null, null);
        Node node10 = new Node(this.charset[10], 10, node9, node11);
        Node node13 = new Node(this.charset[13], 13, null, null);
        Node node15 = new Node(this.charset[15], 15, null, null);
        Node node14 = new Node(this.charset[14], 14, node13, node15);
        Node node12 = new Node(this.charset[12], 12, node10, node14);
        Node node8 = new Node(this.charset[8], 8, node4, node12);
        Node node17 = new Node(this.charset[17], 17, null, null);
        Node node19 = new Node(this.charset[19], 19, null, null);
        Node node18 = new Node(this.charset[18], 18, node17, node19);
        Node node21 = new Node(this.charset[21], 21, null, null);
        Node node23 = new Node(this.charset[23], 23, null, null);
        Node node22 = new Node(this.charset[22], 22, node21, node23);
        Node node20 = new Node(this.charset[20], 20, node18, node22);
        Node node25 = new Node(this.charset[25], 25, null, null);
        Node node27 = new Node(this.charset[27], 27, null, null);
        Node node26 = new Node(this.charset[26], 26, node25, node27);
        Node node29 = new Node(this.charset[29], 29, null, null);
        Node node31 = new Node(this.charset[31], 31, null, null);
        Node node30 = new Node(this.charset[30], 30, node29, node31);
        Node node28 = new Node(this.charset[28], 28, node26, node30);
        Node node24 = new Node(this.charset[24], 24, node20, node28);
        Node node16 = new Node(this.charset[16], 16, node8, node24);
        Node node33 = new Node(this.charset[33], 33, null, null);
        Node node35 = new Node(this.charset[35], 35, null, null);
        Node node34 = new Node(this.charset[34], 34, node33, node35);
        Node node37 = new Node(this.charset[37], 37, null, null);
        Node node39 = new Node(this.charset[39], 39, null, null);
        Node node38 = new Node(this.charset[38], 38, node37, node39);
        Node node36 = new Node(this.charset[36], 36, node34, node38);
        Node node41 = new Node(this.charset[41], 41, null, null);
        Node node43 = new Node(this.charset[43], 43, null, null);
        Node node42 = new Node(this.charset[42], 42, node41, node43);
        Node node45 = new Node(this.charset[45], 45, null, null);
        Node node47 = new Node(this.charset[47], 47, null, null);
        Node node46 = new Node(this.charset[46], 46, node45, node47);
        Node node44 = new Node(this.charset[44], 44, node42, node46);
        Node node40 = new Node(this.charset[40], 40, node36, node44);
        Node node49 = new Node(this.charset[49], 49, null, null);
        Node node51 = new Node(this.charset[51], 51, null, null);
        Node node50 = new Node(this.charset[50], 50, node49, node51);
        Node node53 = new Node(this.charset[53], 53, null, null);
        Node node55 = new Node(this.charset[55], 55, null, null);
        Node node54 = new Node(this.charset[54], 54, node53, node55);
        Node node52 = new Node(this.charset[52], 52, node50, node54);
        Node node57 = new Node(this.charset[57], 57, null, null);
        Node node59 = new Node(this.charset[59], 59, null, null);
        Node node58 = new Node(this.charset[58], 58, node57, node59);
        Node node61 = new Node(this.charset[61], 61, null, null);
        Node node63 = new Node(this.charset[63], 63, null, null);
        Node node62 = new Node(this.charset[62], 62, node61, node63);
        Node node60 = new Node(this.charset[60], 60, node58, node62);
        Node node56 = new Node(this.charset[56], 56, node52, node60);
        Node node48 = new Node(this.charset[48], 48, node40, node56);
        Node node32 = new Node(this.charset[32], 32, node16, node48);
        return node32;
    }

    private static class Node {
        private char c;
        private int index;
        private Node left;
        private Node right;

        private Node(char c, int index, Node left, Node right) {
            this.c = c;
            this.index = index;
            this.left = left;
            this.right = right;
        }

        private void print(String prefix) {
            if (this.left != null) {
                this.left.print(prefix + "  ");
            }
            System.out.println(prefix + " " + this.c + " " + this.index);
            if (this.right != null) {
                this.right.print(prefix + "  ");
            }
        }
    }
}

