/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.ds;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import sk.antons.jdbc.log.LogConfig;
import sk.antons.jdbc.log.invocation.JdbcWrapper;

public class LogDataSource
implements DataSource {
    private DataSource ds;
    private LogConfig config;

    public LogDataSource(DataSource ds, LogConfig config) {
        this.ds = ds;
        this.config = config;
    }

    public static LogDataSource wrap(DataSource ds, LogConfig config) {
        return new LogDataSource(ds, config);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.ds.getConnection();
        return JdbcWrapper.wrap(conn, this.config);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = this.ds.getConnection(username, password);
        return JdbcWrapper.wrap(conn, this.config);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.ds.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

