/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.log.invocation;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import sk.antons.jdbc.log.LogConfig;
import sk.antons.jdbc.log.invocation.CommonHandler;
import sk.antons.jdbc.log.invocation.Identities;
import sk.antons.jdbc.log.invocation.JdbcWrapper;

public class ConnectionHandler
extends CommonHandler {
    Connection conn = null;

    public ConnectionHandler(Connection conn, LogConfig config) {
        super(conn, config, Identities.nextConnection(), 0);
        this.conn = conn;
    }

    public static ConnectionHandler instance(Connection conn, LogConfig config) {
        return new ConnectionHandler(conn, config);
    }

    @Override
    protected void preInvoke(Method method, Object[] args) {
    }

    @Override
    protected Object postInvoke(Method method, Object[] args, Object o) {
        if (this.config.consumerStatus().isConsumerOn()) {
            String name = method.getName();
            if ("createStatement".equals(name)) {
                if (this.config.logStatement()) {
                    o = JdbcWrapper.wrap((Statement)o, this.config, this.connidentity);
                }
            } else if ("prepareStatement".equals(name)) {
                if (this.config.logStatement()) {
                    o = JdbcWrapper.wrap((PreparedStatement)o, (String)args[0], this.config, this.connidentity);
                }
            } else if ("commit".equals(name) || "rollback".equals(name)) {
                StringBuilder sb = new StringBuilder();
                this.consumerPrefix(sb);
                sb.append(" ").append(name);
                this.consumerPostfix(sb);
                this.config.consumer().consume(sb.toString());
            }
        }
        return o;
    }
}

