/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.log.invocation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sk.antons.jdbc.log.LogConfig;

public abstract class CommonHandler
implements InvocationHandler {
    protected Object wrapped = null;
    protected LogConfig config = null;
    protected int connidentity;
    protected int stmidentity;
    protected long invocationTime;
    protected Throwable error;

    public CommonHandler(Object wrapped, LogConfig config, int connidentity, int stmidentity) {
        this.wrapped = wrapped;
        this.config = config;
        this.connidentity = connidentity;
        this.stmidentity = stmidentity;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.preInvoke(method, args);
        Object o = null;
        this.error = null;
        long starttime = System.currentTimeMillis();
        try {
            o = method.invoke(this.wrapped, args);
        }
        catch (Throwable e) {
            this.error = e;
        }
        long endtime = System.currentTimeMillis();
        this.invocationTime = endtime - starttime;
        o = this.postInvoke(method, args, o);
        if (this.error != null) {
            throw this.error;
        }
        return o;
    }

    protected abstract void preInvoke(Method var1, Object[] var2);

    protected abstract Object postInvoke(Method var1, Object[] var2, Object var3);

    protected void consumerPrefix(StringBuilder sb) {
        sb.append("jdbc");
        if (this.connidentity > 0 && this.stmidentity > 0) {
            sb.append(" [").append(this.connidentity).append("][").append(this.stmidentity).append(']');
        } else if (this.connidentity > 0) {
            sb.append(" [").append(this.connidentity).append(']');
        }
    }

    protected void consumerPostfix(StringBuilder sb) {
        sb.append(" time: ").append(this.invocationTime);
        if (this.error != null) {
            sb.append(" error: ").append(this.toError(this.error));
        }
    }

    protected boolean isFail() {
        return this.error != null;
    }

    protected String toError(Throwable t) {
        if (t == null) {
            return "";
        }
        while (t instanceof InvocationTargetException && (t = t.getCause()) != null) {
        }
        if (t == null) {
            return "InvocationTargetException";
        }
        return t.toString();
    }
}

