/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.log.invocation;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import sk.antons.jdbc.log.LogConfig;
import sk.antons.jdbc.log.invocation.CommonHandler;

public class ResultSetHandler
extends CommonHandler {
    ResultSet rs = null;
    private long nextstartTime;
    private long nextfirstTime;
    private long nextlastTime;
    private int count = -1;

    public ResultSetHandler(ResultSet rs, LogConfig config, int connidentity, int stmidentity) {
        super(rs, config, connidentity, stmidentity);
        this.rs = rs;
    }

    public static ResultSetHandler instance(ResultSet rs, LogConfig config, int connidentity, int stmidentity) {
        return new ResultSetHandler(rs, config, connidentity, stmidentity);
    }

    @Override
    protected void preInvoke(Method method, Object[] args) {
        if (this.config.consumerStatus().isConsumerOn() && "next".equals(method.getName()) && this.nextstartTime == 0L) {
            this.nextstartTime = System.currentTimeMillis();
        }
    }

    @Override
    protected Object postInvoke(Method method, Object[] args, Object o) {
        if (this.config.consumerStatus().isConsumerOn()) {
            String name = method.getName();
            if ("next".equals(name)) {
                if (this.nextfirstTime == 0L) {
                    this.nextfirstTime = System.currentTimeMillis();
                }
                ++this.count;
            } else if ("close".equals(name)) {
                this.nextlastTime = System.currentTimeMillis();
                StringBuilder sb = new StringBuilder();
                this.consumerPrefix(sb);
                sb.append(" resultset row count: ").append(this.count);
                sb.append(" first row time: ").append(this.nextfirstTime - this.nextstartTime);
                sb.append(" all rows time: ").append(this.nextlastTime - this.nextstartTime);
                sb.append(" close");
                this.consumerPostfix(sb);
                this.config.consumer().consume(sb.toString());
            }
        }
        return o;
    }
}

