/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jdbc.log.invocation;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Statement;
import sk.antons.jdbc.log.JdbcWrapper;
import sk.antons.jdbc.log.LogConfig;
import sk.antons.jdbc.log.invocation.CommonHandler;
import sk.antons.jdbc.log.invocation.Identities;

public class StatementHandler
extends CommonHandler {
    Statement stm = null;

    public StatementHandler(Statement stm, LogConfig config, int connidentity) {
        super(stm, config, connidentity, Identities.nextStatement());
        this.stm = stm;
    }

    public static StatementHandler instance(Statement stm, LogConfig config, int connidentity) {
        return new StatementHandler(stm, config, connidentity);
    }

    @Override
    protected void preInvoke(Method method, Object[] args) {
    }

    @Override
    protected Object postInvoke(Method method, Object[] args, Object o) {
        if (this.config.consumerStatus().isConsumerOn()) {
            String name = method.getName();
            if ("executeQuery".equals(name)) {
                StringBuilder sb = new StringBuilder();
                this.consumerPrefix(sb);
                sb.append(" statement: ").append(args[0]);
                this.consumerPostfix(sb);
                this.config.consumer().consume(sb.toString());
                if (this.config.logResult() && o != null) {
                    o = JdbcWrapper.wrap((ResultSet)o, this.config, this.connidentity, this.stmidentity);
                }
            } else if ("executeUpdate".equals(name)) {
                StringBuilder sb = new StringBuilder();
                this.consumerPrefix(sb);
                sb.append(" statement: ").append(args[0]);
                sb.append(" result: ").append(o);
                this.consumerPostfix(sb);
                this.config.consumer().consume(sb.toString());
            }
        }
        return o;
    }
}

