/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.maven.plugin.logging.Log;

public class Copy {
    private String from;
    private String to;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void copy(Log log) {
        log.info((CharSequence)("[SB split] copy from " + this.from));
        File fromFile = new File(this.from);
        if (!fromFile.exists()) {
            log.info((CharSequence)"[SB split] copy from not exists");
            return;
        }
        log.info((CharSequence)("[SB split] copy to " + this.to));
        File toFile = new File(this.to);
        int count = 0;
        if (fromFile.isDirectory()) {
            count = this.copyFolder(log, fromFile, toFile);
        } else {
            if (toFile.exists() && toFile.isDirectory()) {
                log.error((CharSequence)"[SB split] copy file must target another file");
                throw new IllegalArgumentException("copy to " + this.to + " must be a file");
            }
            this.copyFile(log, fromFile, toFile);
            count = 1;
        }
        log.info((CharSequence)("[SB split] copy file count: " + count));
    }

    private void copyFile(Log log, File fromFile, File toFile) {
        File parent = toFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            FileInputStream is = new FileInputStream(fromFile);
            FileOutputStream os = new FileOutputStream(toFile);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
            os.flush();
            os.close();
            is.close();
            toFile.setLastModified(fromFile.lastModified());
        }
        catch (Exception e) {
            log.error((CharSequence)("[SB split] unable to copy " + fromFile + " " + toFile));
            throw new IllegalArgumentException(e);
        }
    }

    private int copyFolder(Log log, File fromFile, File toFile) {
        File[] children;
        if (!toFile.exists()) {
            toFile.mkdirs();
        }
        if ((children = fromFile.listFiles()) == null) {
            return 0;
        }
        int count = 0;
        for (File file : children) {
            if (file.isDirectory()) {
                count += this.copyFolder(log, file, new File(toFile.getAbsolutePath() + "/" + file.getName()));
                continue;
            }
            this.copyFile(log, file, new File(toFile.getAbsolutePath() + "/" + file.getName()));
            ++count;
        }
        return count;
    }
}

