/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sbsplitter;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import sk.antons.sbsplitter.Copy;
import sk.antons.sbsplitter.SBSplitter;

@Mojo(name="split", defaultPhase=LifecyclePhase.PACKAGE)
public class SBSplitterMojo
extends AbstractMojo {
    @Parameter(property="sbFile", defaultValue="target/${project.build.finalName}.jar", required=false)
    private String filename;
    @Parameter(property="destDir", defaultValue="target/sb/", required=false)
    private String destDir;
    @Parameter(property="sourceLibFolder", defaultValue="BOOT-INF/lib/", required=false)
    private String sourceLibFolder;
    @Parameter(property="destLibFolder", defaultValue="BOOT-INF/lib/", required=false)
    private String destLibFolder;
    @Parameter(property="destAppFolder", defaultValue="BOOT-INF/app/", required=false)
    private String destAppFolder;
    @Parameter(property="cpFile", defaultValue="BOOT-INF/classes/classpath.txt", required=false)
    private String cpFile;
    @Parameter(property="cpScript", defaultValue="BOOT-INF/classpath.sh", required=false)
    private String cpScript;
    @Parameter(property="cpClassesPrefix", defaultValue="./", required=false)
    private String cpClassesPrefix;
    @Parameter(property="cpAppPrefix", defaultValue="app/", required=false)
    private String cpAppPrefix;
    @Parameter(property="cpLibPrefix", defaultValue="lib/", required=false)
    private String cpLibPrefix;
    @Parameter(property="appModuleNames", required=false)
    private String[] appModuleNames = null;
    @Parameter(property="appModulePackages", required=false)
    private String[] appModulePackages = null;
    @Parameter(property="copies", required=false)
    private Copy[] copies = null;

    private static String initProperty(String value, String defaultValue, boolean endswithslash) {
        if (value == null) {
            value = defaultValue;
        }
        if (endswithslash && !value.endsWith("/")) {
            value = value + "/";
        }
        return value;
    }

    private void initProperties() {
        this.destDir = SBSplitterMojo.initProperty(this.destDir, "target/sb/", true);
        this.sourceLibFolder = SBSplitterMojo.initProperty(this.sourceLibFolder, "BOOT-INF/lib/", true);
        this.destLibFolder = SBSplitterMojo.initProperty(this.destLibFolder, "BOOT-INF/lib/", true);
        this.destAppFolder = SBSplitterMojo.initProperty(this.destAppFolder, "BOOT-INF/app/", true);
        this.cpFile = SBSplitterMojo.initProperty(this.cpFile, "BOOT-INF/classes/classpath.txt", false);
        this.cpScript = SBSplitterMojo.initProperty(this.cpScript, "BOOT-INF/classpath.sh", false);
        this.cpClassesPrefix = SBSplitterMojo.initProperty(this.cpClassesPrefix, "./", true);
        this.cpAppPrefix = SBSplitterMojo.initProperty(this.cpAppPrefix, "app/", true);
        this.cpLibPrefix = SBSplitterMojo.initProperty(this.cpLibPrefix, "lib/", true);
    }

    public void execute() throws MojoExecutionException {
        this.initProperties();
        SBSplitter splitter = new SBSplitter();
        splitter.setAppModuleNames(this.appModuleNames);
        splitter.setAppModulePackages(this.appModulePackages);
        splitter.setCpAppPrefix(this.cpAppPrefix);
        splitter.setCpClassesPrefix(this.cpClassesPrefix);
        splitter.setCpFile(this.cpFile);
        splitter.setCpLibPrefix(this.cpLibPrefix);
        splitter.setCpScript(this.cpScript);
        splitter.setDestAppFolder(this.destAppFolder);
        splitter.setDestDir(this.destDir);
        splitter.setDestLibFolder(this.destLibFolder);
        splitter.setFilename(this.filename);
        splitter.setSourceLibFolder(this.sourceLibFolder);
        this.printConf();
        this.getLog().info((CharSequence)("[SB split] splitting " + splitter.getFilename() + " to " + splitter.getDestDir()));
        splitter.split(this.getLog());
        this.getLog().info((CharSequence)"[SB split] splitting done");
        if (this.copies != null) {
            for (Copy copy : this.copies) {
                this.getLog().info((CharSequence)"");
                copy.copy(this.getLog());
            }
        }
    }

    private void printConf() {
        this.getLog().info((CharSequence)("[SB split] conf sbFile: " + this.filename));
        this.getLog().info((CharSequence)("[SB split] conf destDir: " + this.destDir));
        this.getLog().info((CharSequence)("[SB split] conf sourceLibFolder: " + this.sourceLibFolder));
        this.getLog().info((CharSequence)("[SB split] conf destLibFolder: " + this.destLibFolder));
        this.getLog().info((CharSequence)("[SB split] conf destAppFolder: " + this.destAppFolder));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("[SB split] conf cpFile: " + this.cpFile));
        this.getLog().info((CharSequence)("[SB split] conf cpScript: " + this.cpScript));
        this.getLog().info((CharSequence)("[SB split] conf cpClassesPrefix: " + this.cpClassesPrefix));
        this.getLog().info((CharSequence)("[SB split] conf cpAppPrefix: " + this.cpAppPrefix));
        this.getLog().info((CharSequence)("[SB split] conf cpLibPrefix: " + this.cpLibPrefix));
        if (this.appModuleNames != null && this.appModuleNames.length > 0) {
            this.getLog().info((CharSequence)"");
            for (String string : this.appModuleNames) {
                this.getLog().info((CharSequence)("[SB split] conf appModuleName: " + (String)string));
            }
        }
        if (this.appModulePackages != null && this.appModulePackages.length > 0) {
            this.getLog().info((CharSequence)"");
            for (String string : this.appModulePackages) {
                this.getLog().info((CharSequence)("[SB split] conf appModulePackage: " + (String)string));
            }
        }
        if (this.copies != null && this.copies.length > 0) {
            this.getLog().info((CharSequence)"");
            for (Copy copy : this.copies) {
                this.getLog().info((CharSequence)"[SB split] conf copy");
                this.getLog().info((CharSequence)("           from: " + copy.getFrom()));
                this.getLog().info((CharSequence)("           to:   " + copy.getTo()));
            }
        }
        this.getLog().info((CharSequence)"");
    }
}

