/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSplitter {
    private final String text;

    public StringSplitter(String text) {
        this.text = text;
    }

    public Iterator<String> bySubstring(String substring) {
        if (this.text == null) {
            return new EmptyIterator();
        }
        if (substring == null) {
            return new EmptyIterator();
        }
        if ("".equals(substring)) {
            return new EmptyIterator();
        }
        return new SubstringIterator(substring);
    }

    public List<String> bySubstringToList(String substring) {
        return StringSplitter.toList(this.bySubstring(substring));
    }

    private static boolean areSubstringsValid(String[] substrings) {
        if (substrings == null) {
            return false;
        }
        for (String substring : substrings) {
            if (substring == null) {
                return false;
            }
            if (!"".equals(substring)) continue;
            return false;
        }
        return true;
    }

    public Iterator<String> bySubstrings(String ... substring) {
        if (this.text == null) {
            return new EmptyIterator();
        }
        if (substring == null) {
            return new EmptyIterator();
        }
        if (!StringSplitter.areSubstringsValid(substring)) {
            return new EmptyIterator();
        }
        return new SubstringsIterator(substring);
    }

    public List<String> bySubstringsToList(String ... substring) {
        return StringSplitter.toList(this.bySubstrings(substring));
    }

    private static List<String> toList(Iterator<String> iterator) {
        ArrayList<String> rv = new ArrayList<String>();
        while (iterator.hasNext()) {
            String next = iterator.next();
            rv.add(next);
        }
        return rv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubstringsIterator
    implements Iterator<String> {
        private String[] substrings = null;
        private int pos = 0;
        private int nearestPos = -1;
        private int nearestIndex = -1;

        public SubstringsIterator(String[] substrings) {
            this.substrings = substrings;
        }

        @Override
        public boolean hasNext() {
            return this.pos <= StringSplitter.this.text.length();
        }

        private void findNext() {
            int minpos = -1;
            int minindex = -1;
            String text = StringSplitter.this.text;
            for (int i = 0; i < this.substrings.length; ++i) {
                int p = text.indexOf(this.substrings[i], this.pos);
                if (p < 0 || minpos >= 0 && minpos <= p) continue;
                minpos = p;
                minindex = i;
            }
            this.nearestPos = minpos;
            this.nearestIndex = minindex;
        }

        @Override
        public String next() {
            String text = StringSplitter.this.text;
            if (this.pos > text.length()) {
                throw new NoSuchElementException("No moere elements");
            }
            if (this.pos == text.length()) {
                this.pos = text.length() + 1;
                return "";
            }
            this.findNext();
            if (this.nearestPos < 0) {
                String rv = text.substring(this.pos);
                this.pos = text.length() + 1;
                return rv;
            }
            String rv = text.substring(this.pos, this.nearestPos);
            this.pos = this.nearestPos + this.substrings[this.nearestIndex].length();
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubstringIterator
    implements Iterator<String> {
        private String substring = null;
        private int pos = 0;

        public SubstringIterator(String substring) {
            this.substring = substring;
        }

        @Override
        public boolean hasNext() {
            return this.pos <= StringSplitter.this.text.length();
        }

        @Override
        public String next() {
            String text = StringSplitter.this.text;
            if (this.pos > text.length()) {
                throw new NoSuchElementException("No moere elements");
            }
            if (this.pos == text.length()) {
                this.pos = text.length() + 1;
                return "";
            }
            int p = text.indexOf(this.substring, this.pos);
            if (p < 0) {
                String rv = text.substring(this.pos);
                this.pos = text.length() + 1;
                return rv;
            }
            String rv = text.substring(this.pos, p);
            this.pos = p + this.substring.length();
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator
    implements Iterator<String> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            throw new NoSuchElementException("Empty iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

