/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops;

import java.io.InputStream;
import java.util.Properties;
import sk.antons.sprops.AbstractEncoder;
import sk.antons.sprops.SimpleEncoder;

public class PropertiesEncoder
extends AbstractEncoder {
    Properties props = new Properties();

    public static PropertiesEncoder instance(byte[] password) {
        PropertiesEncoder encoder = new PropertiesEncoder();
        encoder.password(password);
        return encoder;
    }

    public static PropertiesEncoder instance(String password) {
        PropertiesEncoder encoder = new PropertiesEncoder();
        encoder.password(password);
        return encoder;
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (Object object : props.keySet()) {
            this.props.put(object, props.get(object));
        }
    }

    public void addProperties(InputStream propsis) {
        if (this.props == null) {
            return;
        }
        Properties p = new Properties();
        try {
            p.load(propsis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load properties", e);
        }
        this.addProperties(p);
    }

    public String getProperty(String name) {
        String value = this.props.getProperty(name);
        if (value == null) {
            return null;
        }
        if (value.startsWith("sprops:")) {
            SimpleEncoder se = SimpleEncoder.instance(this.rawPassword);
            value = se.decode(value);
        }
        return value;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Properties decode() {
        Properties p = new Properties();
        SimpleEncoder se = SimpleEncoder.instance(this.rawPassword);
        for (Object object : this.props.keySet()) {
            String s;
            Object value = this.props.get(object);
            if (value instanceof String && (s = (String)value).startsWith("sprops:")) {
                value = se.decode(s);
            }
            p.put(object, value);
        }
        return p;
    }
}

