/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops;

import sk.antons.jaul.Is;
import sk.antons.jaul.binary.Base64;
import sk.antons.sprops.AbstractEncoder;
import sk.antons.sprops.alg.SpropsAlg;
import sk.antons.sprops.alg.SpropsAlgFactory;
import sk.antons.sprops.model.SpropsData;

public class SimpleEncoder
extends AbstractEncoder {
    public static SimpleEncoder instance(byte[] password) {
        SimpleEncoder encoder = new SimpleEncoder();
        encoder.password(password);
        return encoder;
    }

    public static SimpleEncoder instance(String password) {
        SimpleEncoder encoder = new SimpleEncoder();
        encoder.password(password);
        return encoder;
    }

    public String encode(String value) {
        StringBuilder result = new StringBuilder("sprops:");
        if (!Is.empty(value)) {
            try {
                byte[] rawData = value.getBytes("UTF-8");
                SpropsAlg alg = SpropsAlgFactory.algorithm(this.algorithm);
                alg.password(this.rawPassword);
                SpropsData sdata = alg.prepare(rawData);
                byte[] encodeddata = alg.encode(sdata);
                result.append(Base64.encode(encodeddata, false));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to encode string " + value, e);
            }
        }
        return result.toString();
    }

    public String decode(String value) {
        if (Is.empty(value)) {
            throw new IllegalArgumentException("Unable to decode - no sprops format");
        }
        if (!value.startsWith("sprops:")) {
            throw new IllegalArgumentException("Unable to decode - no sprops format");
        }
        StringBuilder result = new StringBuilder();
        try {
            value = value.substring(7);
            byte[] encodedData = Base64.decode(value);
            SpropsAlg alg = SpropsAlgFactory.algorithm(this.algorithm);
            alg.password(this.rawPassword);
            SpropsData sdata = alg.decode(encodedData, 0, encodedData.length);
            String resultString = new String(sdata.getData(), "UTF-8");
            result.append(resultString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to decode input data ", e);
        }
        return result.toString();
    }
}

