/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.util.logging.appender;

import java.util.logging.LogRecord;

public abstract class AbstractAppender {
    protected int minLength = 0;
    protected boolean minLeft = true;
    protected int maxLength = 0;
    protected boolean maxLeft = true;
    protected String param = null;

    public void consolidate() {
        if (this.minLength < 0) {
            this.minLength = Math.abs(this.minLength);
            this.minLeft = true;
        } else {
            this.minLeft = false;
        }
        if (this.maxLength < 0) {
            this.maxLength = Math.abs(this.maxLength);
            this.maxLeft = true;
        } else {
            this.maxLeft = false;
        }
    }

    protected abstract String format(LogRecord var1);

    public void append(StringBuilder sb, LogRecord record) {
        String text = this.format(record);
        this.append(sb, text);
    }

    protected void append(StringBuilder sb, String text) {
        if (text == null) {
            text = "null";
        }
        if (this.maxLength > 0 && text.length() > this.maxLength) {
            text = !this.maxLeft ? text.substring(0, this.maxLength) : text.substring(text.length() - this.maxLength);
        }
        if (this.minLength <= 0) {
            sb.append(text);
        } else if (text.length() < this.minLength) {
            int length = this.minLength - text.length();
            if (this.minLeft) {
                for (int i = 0; i < length; ++i) {
                    sb.append(' ');
                }
                sb.append(text);
            } else {
                sb.append(text);
                for (int i = 0; i < length; ++i) {
                    sb.append(' ');
                }
            }
        } else {
            sb.append(text);
        }
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setParam(String param) {
        this.param = param;
    }
}

