/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.path;

import sk.antons.web.path.element.ElementMatcher;
import sk.antons.web.path.element.ElementMatcherFactory;

public class PathMatcher {
    private String pattern;
    private int maxSize = 64;
    private char[] patternChars = null;
    private int[] elements = null;
    private int elementSize = 0;
    private int matcherSize = 0;
    private ElementMatcher[] matchers = null;

    public PathMatcher(String pattern, int maxSize) {
        this.pattern = pattern;
        this.maxSize = maxSize;
        this.init();
    }

    public static PathMatcher instance(String pattern) {
        return new PathMatcher(pattern, 64);
    }

    public static PathMatcher instance(String pattern, int maxSize) {
        return new PathMatcher(pattern, maxSize);
    }

    private void init() {
        if (this.pattern == null) {
            throw new IllegalArgumentException("Null path pattern is not allowed");
        }
        if (this.pattern.length() == 0) {
            throw new IllegalArgumentException("Empty path pattern is not allowed");
        }
        this.patternChars = this.pattern.toCharArray();
        this.elements = new int[this.maxSize + 1];
        this.matchers = new ElementMatcher[this.maxSize];
        this.elementSize = this.elementize(this.patternChars, this.elements);
        for (int i = 0; i < this.elementSize; ++i) {
            ElementMatcher m = ElementMatcherFactory.matcher(this.patternChars, this.elements[i] + 1, this.elements[i + 1]);
            if (m == null) continue;
            this.matchers[this.matcherSize++] = m;
        }
    }

    private int elementize(char[] chars, int[] elements) {
        int pos = 0;
        int startpos = 0;
        if (chars.length == 0) {
            return pos;
        }
        if (chars[0] == '/') {
            elements[pos++] = 0;
            startpos = 1;
        } else {
            elements[pos++] = -1;
        }
        int len = chars.length;
        for (int i = startpos; i < len; ++i) {
            if (chars[i] != '/') continue;
            elements[pos++] = i;
        }
        if (chars[len - 1] != '/') {
            elements[pos++] = len;
        }
        return pos - 1;
    }

    public boolean match(String path) {
        if (path == null) {
            path = "/";
        }
        char[] partChars = path.toCharArray();
        int[] parts = new int[this.maxSize + 1];
        int partSize = this.elementize(partChars, parts);
        return this.matchImpl(partChars, parts, partSize, 0, 0);
    }

    private boolean matchImpl(char[] chars, int[] parts, int partSize, int partIndex, int matcherIndex) {
        if (partIndex >= partSize && matcherIndex >= this.matcherSize) {
            return true;
        }
        if (matcherIndex >= this.matcherSize) {
            return false;
        }
        ElementMatcher matcher = this.matchers[matcherIndex];
        if (matcher.isWild()) {
            for (int i = partSize - partIndex; i >= 0; --i) {
                boolean result = this.matchImpl(chars, parts, partSize, partIndex + i, matcherIndex + 1);
                if (!result) continue;
                return true;
            }
            return false;
        }
        if (matcher.match(chars, parts[partIndex] + 1, parts[partIndex + 1])) {
            return this.matchImpl(chars, parts, partSize, partIndex + 1, matcherIndex + 1);
        }
        return false;
    }

    public String toString() {
        return "PathMatcher{pattern=" + this.pattern + ", maxSize=" + this.maxSize + '}';
    }
}

