/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import no.unit.nva.auth.CachedValueProvider;
import no.unit.nva.auth.CognitoAuthenticator;

public class CachedJwtProvider
extends CachedValueProvider<DecodedJWT> {
    private final CognitoAuthenticator cognitoAuthenticator;
    private final Clock clock;

    public CachedJwtProvider(CognitoAuthenticator cognitoAuthenticator, Clock clock) {
        this.cognitoAuthenticator = cognitoAuthenticator;
        this.clock = clock;
    }

    @Override
    protected boolean isExpired() {
        Instant in5sec = this.clock.instant().plusMillis(5000L);
        Date expiresAtDate = ((DecodedJWT)this.cachedValue).getExpiresAt();
        Date dateIn5Secs = Date.from(in5sec);
        return expiresAtDate.before(dateIn5Secs);
    }

    @Override
    protected DecodedJWT getNewValue() {
        return this.cognitoAuthenticator.fetchBearerToken();
    }
}

