/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Supplier;
import no.unit.nva.auth.CognitoUserInfo;
import nva.commons.core.attempt.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchUserInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchUserInfo.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHORIZATION_ERROR_MESSAGE = "Could not authorize user";
    private final HttpClient httpClient;
    private final Supplier<URI> cognitoUri;
    private final String authorizationHeader;

    public FetchUserInfo(HttpClient httpClient, Supplier<URI> cognitoUri, String authorizationHeader) {
        this.httpClient = httpClient;
        this.cognitoUri = cognitoUri;
        this.authorizationHeader = authorizationHeader;
    }

    public CognitoUserInfo fetch() {
        HttpRequest request = HttpRequest.newBuilder(this.cognitoUri.get()).header(AUTHORIZATION_HEADER, this.authorizationHeader).GET().build();
        return (CognitoUserInfo)Try.attempt(() -> this.httpClient.send(request, HttpResponse.BodyHandlers.ofString())).map(this::responseIsSuccessful).map(HttpResponse::body).map(CognitoUserInfo::fromString).orElseThrow(fail -> this.handleFailure(request.uri(), fail.getException()));
    }

    private HttpResponse<String> responseIsSuccessful(HttpResponse<String> response) {
        if (200 != response.statusCode()) {
            LOGGER.error("Failed to look up UserInfo from Cognito. Got status code {} with body '{}'", (Object)response.statusCode(), (Object)response.body());
            throw new RuntimeException(AUTHORIZATION_ERROR_MESSAGE);
        }
        return response;
    }

    private RuntimeException handleFailure(URI uri, Exception exception) {
        LOGGER.error("Failed to look up UserInfo from Cognito (" + String.valueOf(uri) + ")", (Throwable)exception);
        return new RuntimeException(AUTHORIZATION_ERROR_MESSAGE, exception);
    }
}

