/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.doi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.Objects;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;
import nva.commons.core.paths.UnixPath;
import nva.commons.core.paths.UriWrapper;

public class Doi {
    public static final String DEFAULT_HOST = "doi.org";
    public static final String NULL_ARGUMENT_ERROR = "No argument should be blank";
    private static final String DOI_SCHEME = "doi";
    private static final String DOC_SCHEME = "doc";
    private final URI uri;

    protected Doi(URI doiUri) {
        this.uri = doiUri;
    }

    @JsonCreator
    public static Doi fromUriString(String uriString) {
        return Doi.fromUri(URI.create(uriString));
    }

    public static Doi fromUri(URI doiUri) {
        return new Doi(doiUri);
    }

    public static Doi fromDoiIdentifier(String doiHost, String doiIdentifier) {
        return new Doi(UriWrapper.fromHost((String)doiHost).addChild(new String[]{doiIdentifier}).getUri());
    }

    public static Doi fromPrefixAndSuffix(String doiHost, String prefix, String suffix) {
        if (StringUtils.isBlank((String)doiHost) || StringUtils.isBlank((String)prefix) || StringUtils.isBlank((String)suffix)) {
            throw new IllegalArgumentException(NULL_ARGUMENT_ERROR);
        }
        return new Doi(UriWrapper.fromHost((String)doiHost).addChild(new String[]{prefix}).addChild(new String[]{suffix}).getUri());
    }

    public static Doi fromDoiIdentifier(String doiIdentifier) {
        return new Doi(UriWrapper.fromHost((String)DEFAULT_HOST).addChild(new String[]{doiIdentifier}).getUri());
    }

    public URI getUri() {
        return this.uri;
    }

    public Doi changeHost(String host) {
        URI newUri = UriWrapper.fromHost((String)host).addChild(new String[]{this.uri.getPath()}).getUri();
        return Doi.fromUri(newUri);
    }

    @JsonValue
    public String toString() {
        return this.uri.toString();
    }

    public String toIdentifier() {
        return UnixPath.fromString((String)this.uri.getPath()).removeRoot().toString();
    }

    public URI getStandardizedUri() {
        return this.isDoiUri() ? this.convertDoiUriToHttpsUri() : this.convertHttpBasedUri();
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Doi)) {
            return false;
        }
        Doi doi = (Doi)o;
        return Objects.equals(this.getUri(), doi.getUri());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getUri());
    }

    private URI convertHttpBasedUri() {
        return new Doi(UriWrapper.fromHost((String)DEFAULT_HOST).addChild(new String[]{this.uri.getPath()}).getUri()).getUri();
    }

    private URI convertDoiUriToHttpsUri() {
        return UriWrapper.fromHost((String)DEFAULT_HOST).addChild(new String[]{this.uri.getSchemeSpecificPart()}).getUri();
    }

    private boolean isDoiUri() {
        return DOI_SCHEME.equalsIgnoreCase(this.uri.getScheme()) || DOC_SCHEME.equalsIgnoreCase(this.uri.getScheme());
    }

    public String getPrefix() {
        return UriWrapper.fromUri((URI)this.uri).getPath().getPathElementByIndexFromEnd(1);
    }
}

