/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.secrets;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.secrets.ErrorWritingSecretException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse;

public class SecretsWriter {
    public static final String COULD_NOT_WRITE_SECRET_ERROR = "Could not write secret: ";
    private static final Logger logger = LoggerFactory.getLogger(SecretsWriter.class);
    private static final String AWS_REGION = new Environment().readEnvOpt("AWS_REGION").orElse(Region.EU_WEST_1.id());
    private static final String EMPTY_STRING = "";
    private final SecretsManagerClient awsSecretsManager;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @JacocoGenerated
    public SecretsWriter() {
        this(SecretsWriter.defaultSecretsManagerClient());
    }

    public SecretsWriter(SecretsManagerClient awsSecretsManager) {
        this.awsSecretsManager = awsSecretsManager;
    }

    public String updateSecretKey(String secretName, String secretKey, String secretValue) {
        GetSecretValueResponse valueResponse = this.awsSecretsManager.getSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build());
        return (String)Try.attempt(() -> this.upsertValueResponse(valueResponse, secretKey, secretValue)).map(PutSecretValueResponse::name).orElseThrow(this::logErrorAndThrowException);
    }

    public <T> String updateSecretObject(String secretName, T secretClassInstance) {
        return (String)Try.attempt(() -> this.updateSecretJsonToAws(secretName, secretClassInstance)).map(PutSecretValueResponse::name).orElseThrow(this::logErrorAndThrowException);
    }

    @JacocoGenerated
    public static SecretsManagerClient defaultSecretsManagerClient() {
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)AWS_REGION))).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).httpClient(UrlConnectionHttpClient.create())).build();
    }

    private PutSecretValueResponse upsertValueResponse(GetSecretValueResponse secretValueResponse, String secretKey, String secretValue) {
        return (PutSecretValueResponse)Try.of((Object)secretValueResponse).map(GetSecretValueResponse::secretString).map(arg_0 -> ((ObjectMapper)this.objectMapper).readTree(arg_0)).map(secretJson -> {
            ((ObjectNode)secretJson).put(secretKey, secretValue);
            return this.updateSecretJsonToAws(secretValueResponse.name(), secretJson);
        }).orElseThrow(this::logErrorAndThrowException);
    }

    private <T> PutSecretValueResponse updateSecretJsonToAws(String secreName, T node) {
        return this.awsSecretsManager.putSecretValue((PutSecretValueRequest)PutSecretValueRequest.builder().secretId(secreName).secretString(this.toJsonCompact(node)).build());
    }

    private DefaultPrettyPrinter getPrettyPrinterCompact() {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        DefaultIndenter indenter = new DefaultIndenter(EMPTY_STRING, EMPTY_STRING);
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        return prettyPrinter;
    }

    public <T> String toJsonCompact(T toJsonObject) {
        return (String)Try.attempt(() -> this.objectMapper.writer((PrettyPrinter)this.getPrettyPrinterCompact()).writeValueAsString(toJsonObject)).orElseThrow();
    }

    private <I> ErrorWritingSecretException logErrorAndThrowException(Failure<I> failure) {
        logger.error(failure.getException().getMessage(), (Throwable)failure.getException());
        return new ErrorWritingSecretException();
    }
}

