package me.chanjar.weixin.cp.bean.external;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

/**
 * <pre>
 * 批量获取客户详情
 * Created by Binary Wang on 2020/10/22.
 * 参考文档：https://work.weixin.qq.com/api/doc/90000/90135/92994
 * </pre>
 *
 * @author <a href="https://github.com/alucardxh">alucardxh</a>
 */
@Getter
@Setter
public class WxCpUserExternalContactBatchInfo extends WxCpBaseResp implements Serializable {
  private static final long serialVersionUID = -5166048319463473186L;

  @SerializedName("external_contact_list")
  private List<ExternalContactInfo> externalContactList;

  @SerializedName("next_cursor")
  private String nextCursor;

  @Getter
  @Setter
  public static class ExternalContactInfo {
    @SerializedName("external_contact")
    private ExternalContact externalContact;

    @SerializedName("follow_info")
    private FollowedUser followInfo;
  }

  @Getter
  @Setter
  public static class ExternalContact {
    @SerializedName("external_userid")
    private String externalUserId;

    @SerializedName("position")
    private String position;

    @SerializedName("name")
    private String name;

    @SerializedName("avatar")
    private String avatar;

    @SerializedName("corp_name")
    private String corpName;

    @SerializedName("corp_full_name")
    private String corpFullName;

    @SerializedName("type")
    private Integer type;

    @SerializedName("gender")
    private Integer gender;

    @SerializedName("unionid")
    private String unionId;

    @SerializedName("external_profile")
    private ExternalProfile externalProfile;
  }

  @Setter
  @Getter
  public static class ExternalProfile {
    @SerializedName("external_attr")
    private List<ExternalAttribute> externalAttrs;
  }

  @Data
  @Builder
  @NoArgsConstructor
  @AllArgsConstructor
  public static class ExternalAttribute {
    @Setter
    @Getter
    public static class Text {
      private String value;
    }

    @Setter
    @Getter
    public static class Web {
      private String title;
      private String url;
    }

    @Setter
    @Getter
    public static class MiniProgram {
      @SerializedName("pagepath")
      private String pagePath;
      private String appid;
      private String title;
    }

    private int type;

    private String name;

    private Text text;

    private Web web;

    @SerializedName("miniprogram")
    private MiniProgram miniProgram;
  }

  @Setter
  @Getter
  public static class FollowedUser {
    @SerializedName("userid")
    private String userId;
    private String remark;
    private String description;
    @SerializedName("createtime")
    private Long createTime;
    private String state;
    @SerializedName("remark_company")
    private String remarkCompany;
    @SerializedName("remark_mobiles")
    private String[] remarkMobiles;
    private Tag[] tags;
    @SerializedName("remark_corp_name")
    private String remarkCorpName;
    @SerializedName("add_way")
    private String addWay;
    @SerializedName("oper_userid")
    private String operUserId;

  }

  public static WxCpUserExternalContactBatchInfo fromJson(String json) {
    return WxCpGsonBuilder.create().fromJson(json, WxCpUserExternalContactBatchInfo.class);
  }

  @Setter
  @Getter
  public static class Tag {
    @SerializedName("group_name")
    private String groupName;
    @SerializedName("tag_name")
    private String tagName;
    private int type;
  }

}
