/*
 * Decompiled with CFR 0.152.
 */
package com.github.brutils.javabrutils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataUtil {
    private static final Logger LOGGER = Logger.getLogger(DataUtil.class.getName());
    private static final String FORMATO_DATA_BR = "dd/MM/yyyy";

    private DataUtil() {
    }

    public static Date stringParaDate(String data) throws ParseException {
        Date resultado = null;
        if (data == null || "".equals(data)) {
            return null;
        }
        SimpleDateFormat dataEntrada = new SimpleDateFormat(FORMATO_DATA_BR);
        try {
            resultado = dataEntrada.parse(data);
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a data. Informe uma data v\u00e1lida no formato dd/mm/yyyy. Data enviada " + data);
            throw parseException;
        }
        return resultado;
    }

    public static Date stringParaDate(String data, String formatoDeEntrada) throws ParseException {
        Date resultado = null;
        SimpleDateFormat dataEntrada = new SimpleDateFormat(formatoDeEntrada);
        SimpleDateFormat dataSaida = new SimpleDateFormat(FORMATO_DATA_BR);
        try {
            resultado = dataSaida.parse(dataSaida.format(dataEntrada.parse(data)));
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a data. Informe uma data e formato v\u00e1lidos. Data enviada " + data + " , formato enviado " + formatoDeEntrada);
            throw parseException;
        }
        return resultado;
    }
}

