/*
 * Decompiled with CFR 0.152.
 */
package com.github.brutils.javabrutils;

import com.github.brutils.javabrutils.StringUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentoUtil {
    private static final Logger LOGGER = Logger.getLogger(DocumentoUtil.class.getName());

    private DocumentoUtil() {
    }

    public static boolean isCpfOuCnpjValido(String cpfOuCnpj) {
        LOGGER.log(Level.FINEST, "Verificando se a String " + cpfOuCnpj + " \u00e9 um CPF ou CNPJ v\u00e1lido.");
        String cpfOuCnpjTemporario = cpfOuCnpj;
        int tamanhoCpf = 11;
        int tamanhoCnpj = 14;
        cpfOuCnpjTemporario = StringUtil.substituir(cpfOuCnpjTemporario, ".", "");
        cpfOuCnpjTemporario = StringUtil.substituir(cpfOuCnpjTemporario, "-", "");
        cpfOuCnpjTemporario = StringUtil.substituir(cpfOuCnpjTemporario, "/", "");
        if (cpfOuCnpjTemporario.length() == 11) {
            int d1 = 0;
            int d2 = 0;
            int digito1 = 0;
            int digito2 = 0;
            int resto = 0;
            for (int numeroContador = 1; numeroContador < cpfOuCnpjTemporario.length() - 1; ++numeroContador) {
                int digitoCpf = Integer.valueOf(cpfOuCnpjTemporario.substring(numeroContador - 1, numeroContador));
                d1 += (11 - numeroContador) * digitoCpf;
                d2 += (12 - numeroContador) * digitoCpf;
            }
            resto = d1 % 11;
            digito1 = resto < 2 ? 0 : 11 - resto;
            resto = (d2 += 2 * digito1) % 11;
            digito2 = resto < 2 ? 0 : 11 - resto;
            String numeroDigitoVerificador = cpfOuCnpjTemporario.substring(cpfOuCnpjTemporario.length() - 2, cpfOuCnpjTemporario.length());
            String numeroDigitoResult = String.valueOf(digito1) + String.valueOf(digito2);
            return numeroDigitoVerificador.equals(numeroDigitoResult);
        }
        if (cpfOuCnpjTemporario.length() == 14) {
            int i;
            int i2;
            int soma = 0;
            int dig = 0;
            char[] chrCnpj = cpfOuCnpjTemporario.toCharArray();
            String resultadoCalcCnpj = "0";
            int numeroQuatro = 4;
            int numeroQuarentaOito = 48;
            int numeroNove = 9;
            int numeroSeis = 6;
            int numeroOito = 8;
            int numeroDez = 10;
            int numeroOnze = 11;
            int numeroCinco = 5;
            int numeroSete = 7;
            for (i2 = 0; i2 < 4; ++i2) {
                if (chrCnpj[i2] - 48 < 0 || chrCnpj[i2] - 48 > 9) continue;
                soma += (chrCnpj[i2] - 48) * (6 - (i2 + 1));
            }
            for (i2 = 0; i2 < 8; ++i2) {
                if (chrCnpj[i2 + 4] - 48 < 0 || chrCnpj[i2 + 4] - 48 > 9) continue;
                soma += (chrCnpj[i2 + 4] - 48) * (10 - (i2 + 1));
            }
            dig = 11 - soma % 11;
            resultadoCalcCnpj = dig == 10 || dig == 11 ? "0" : Integer.toString(dig);
            String cnpjCalc = cpfOuCnpjTemporario.substring(0, 12);
            cnpjCalc = cnpjCalc + resultadoCalcCnpj;
            soma = 0;
            for (i = 0; i < 5; ++i) {
                if (chrCnpj[i] - 48 < 0 || chrCnpj[i] - 48 > 9) continue;
                soma += (chrCnpj[i] - 48) * (7 - (i + 1));
            }
            for (i = 0; i < 8; ++i) {
                if (chrCnpj[i + 5] - 48 < 0 || chrCnpj[i + 5] - 48 > 9) continue;
                soma += (chrCnpj[i + 5] - 48) * (10 - (i + 1));
            }
            dig = 11 - soma % 11;
            resultadoCalcCnpj = dig == 10 || dig == 11 ? "0" : Integer.toString(dig);
            cnpjCalc = cnpjCalc + resultadoCalcCnpj;
            return cpfOuCnpjTemporario.equals(cnpjCalc);
        }
        return false;
    }
}

