/*
 * Decompiled with CFR 0.152.
 */
package com.github.brutils.javabrutils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class StringUtil {
    private static final Logger LOGGER = Logger.getLogger(StringUtil.class.getName());

    private StringUtil() {
    }

    public static String nuloParaVazio(String string) {
        LOGGER.log(Level.FINEST, "Convertendo a String " + string + " para nulo ou vazio.");
        String retorno = string == null ? "" : string;
        return retorno;
    }

    public static Character nuloParaVazio(Character character) {
        LOGGER.log(Level.FINEST, "Convertendo o Character " + character + " para nulo ou vazio.");
        Character retorno = character == null ? Character.valueOf(' ') : character;
        return retorno;
    }

    public static boolean isVazio(String string) {
        LOGGER.log(Level.FINEST, "Verificando se a String " + string + " \u00e9 nula ou vazia.");
        return "".equals(StringUtil.nuloParaVazio(string).trim());
    }

    public static boolean isVazio(Character character) {
        LOGGER.log(Level.FINEST, "Verificando se o Character " + character + " \u00e9 nulo ou vazio.");
        return ' ' == StringUtil.nuloParaVazio(character).charValue();
    }

    public static String substituir(String stringCompleta, String stringAhSerSubstituida, String stringSubstituta) {
        LOGGER.log(Level.FINEST, "Substituindo " + stringAhSerSubstituida + " por " + stringSubstituta + " na string " + stringCompleta);
        if (stringCompleta == null || stringAhSerSubstituida == null || stringSubstituta == null) {
            return null;
        }
        StringBuilder conteudo = new StringBuilder(stringCompleta);
        StringBuilder conteudoTemp = new StringBuilder();
        boolean replace = true;
        do {
            int posicao;
            if ((posicao = conteudo.indexOf(stringAhSerSubstituida)) == -1) {
                replace = false;
                continue;
            }
            conteudoTemp = new StringBuilder(conteudo.subSequence(0, posicao));
            conteudoTemp.append(stringSubstituta);
            conteudoTemp.append(conteudo.subSequence(posicao + stringAhSerSubstituida.length(), conteudo.length()));
            conteudo = conteudoTemp;
        } while (replace);
        return conteudo.toString();
    }

    public static String adicionarZeroEsquerda(String string, int tamanho) {
        LOGGER.log(Level.FINEST, "Adicionando Zeros \u00e0 esquerda da String " + string + " at\u00e9 que atinja o tamanho m\u00e1ximo de " + tamanho);
        if (string == null) {
            return null;
        }
        if (tamanho <= string.length()) {
            return string;
        }
        StringBuilder resultado = new StringBuilder(string);
        for (int i = string.length(); i <= tamanho - 1; ++i) {
            resultado.insert(0, "0");
        }
        return resultado.toString();
    }

    public static String adicionarZeroDireita(String string, int tamanho) {
        LOGGER.log(Level.FINEST, "Adicionando Zeros \u00e0 direita da String " + string + " at\u00e9 que atinja o tamanho m\u00e1ximo de " + tamanho);
        if (string == null) {
            return null;
        }
        if (tamanho <= string.length()) {
            return string;
        }
        StringBuilder resultado = new StringBuilder(string);
        for (int i = string.length(); i <= tamanho - 1; ++i) {
            resultado.append('0');
        }
        return resultado.toString();
    }

    public static String adicionarEspacoEsquerda(String string, int tamanho) {
        LOGGER.log(Level.FINEST, "Adicionando Espa\u00e7os \u00e0 esquerda da String " + string + " at\u00e9 que atinja o tamanho m\u00e1ximo de " + tamanho);
        if (string == null) {
            return null;
        }
        if (tamanho <= string.length()) {
            return string;
        }
        StringBuilder resultado = new StringBuilder(string);
        for (int i = string.length(); i <= tamanho - 1; ++i) {
            resultado.insert(0, " ");
        }
        return resultado.toString();
    }

    public static String adicionarEspacoDireita(String string, int tamanho) {
        LOGGER.log(Level.FINEST, "Adicionando Espa\u00e7os \u00e0 direita da String " + string + " at\u00e9 que atinja o tamanho m\u00e1ximo de " + tamanho);
        if (string == null) {
            return null;
        }
        if (tamanho <= string.length()) {
            return string;
        }
        StringBuilder resultado = new StringBuilder(string);
        for (int i = string.length(); i <= tamanho - 1; ++i) {
            resultado.append(' ');
        }
        return resultado.toString();
    }

    public static String removerEspacoDireita(String string) {
        LOGGER.log(Level.FINEST, "Remove todos os espa\u00e7os \u00e0 direita da String " + string);
        if (string == null) {
            return null;
        }
        String resultado = "";
        for (int indice = string.length() - 1; indice >= 0; --indice) {
            if (string.charAt(indice) == ' ') continue;
            resultado = string.substring(0, indice + 1);
            break;
        }
        return resultado;
    }

    public static String removerEspacoEsquerda(String string) {
        LOGGER.log(Level.FINEST, "Remove todos os espa\u00e7os \u00e0 esquerda da String " + string);
        if (string == null) {
            return null;
        }
        String resultado = "";
        for (int indice = 0; indice < string.length(); ++indice) {
            if (string.charAt(indice) == ' ') continue;
            resultado = string.substring(indice, string.length());
            break;
        }
        return resultado;
    }

    public static String adicionarChar(char caracter, int tamanhoMaximo, String texto, boolean noInicio) {
        LOGGER.log(Level.FINEST, "Adicionando o Character " + caracter + " no texto " + texto + ", at\u00e9 que atinja o tamanho m\u00e1ximo " + tamanhoMaximo);
        StringBuilder resultado = new StringBuilder();
        StringBuilder caracterAdd = new StringBuilder();
        if (texto != null && !"".equals(texto)) {
            resultado.append(texto.trim());
        }
        if (resultado.length() <= tamanhoMaximo) {
            for (int i = 0; i < tamanhoMaximo - resultado.length(); ++i) {
                caracterAdd.append(caracter);
            }
        } else {
            return StringUtil.nuloParaVazio(texto).substring(0, tamanhoMaximo);
        }
        if (noInicio) {
            resultado = new StringBuilder(caracterAdd + resultado.toString());
        } else {
            resultado.append((CharSequence)caracterAdd);
        }
        return resultado.toString();
    }

    public static String removerCharEsquerda(String string, char character) {
        LOGGER.log(Level.FINEST, "Removendo o Character " + character + " que est\u00e3o \u00e0 esquerda da String " + string);
        String resultado = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == character) continue;
            resultado = resultado + string.substring(i);
            return resultado;
        }
        return resultado;
    }

    public static String removerCharDireita(String string, char character) {
        LOGGER.log(Level.FINEST, "Removendo o Character " + character + " que est\u00e3o \u00e0 direita da String " + string);
        String resultado = "";
        String stringReversa = new StringBuilder(string).reverse().toString();
        for (int i = 0; i < stringReversa.length(); ++i) {
            if (stringReversa.charAt(i) == character) continue;
            resultado = resultado + stringReversa.substring(i);
            return resultado;
        }
        return new StringBuilder(resultado).reverse().toString();
    }

    public static String removerQuebraDeLinha(String string) {
        LOGGER.log(Level.FINEST, "Removendo as quebras de linha da String " + string);
        return string.replaceAll("(\n|\r)+", "");
    }
}

