/*
 * Decompiled with CFR 0.152.
 */
package com.github.charithe.fjp;

import fj.data.Either;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Try<T> {
    private final Either<Throwable, T> tryState;

    private Try(Either<Throwable, T> tryState) {
        this.tryState = tryState;
    }

    public boolean isSuccess() {
        return this.tryState.isRight();
    }

    public boolean isFailure() {
        return this.tryState.isLeft();
    }

    public T success() {
        if (this.tryState.isRight()) {
            return (T)this.tryState.right().value();
        }
        throw new CallingSuccessOnFailureValue();
    }

    public Throwable failure() {
        if (this.tryState.isLeft()) {
            return (Throwable)this.tryState.left().value();
        }
        throw new CallingFailureOnSuccessValue();
    }

    public <A> Try<A> flatMap(Function<T, Try<A>> fn) {
        if (this.isFailure()) {
            return Try.fromFailure(this.failure());
        }
        return fn.apply(this.success());
    }

    public <A> Try<A> map(Function<T, A> fn) {
        return this.flatMap(t -> Try.fromSuccess(fn.apply(t)));
    }

    public T get() throws Throwable {
        if (this.isFailure()) {
            throw this.failure();
        }
        return this.success();
    }

    public T getOrElse(T defaultVal) {
        if (this.isFailure()) {
            return defaultVal;
        }
        return this.success();
    }

    public Try<T> orElse(Try<T> defaultVal) {
        if (this.isFailure()) {
            return defaultVal;
        }
        return this;
    }

    public Optional<T> toOptional() {
        if (this.isFailure()) {
            return Optional.empty();
        }
        return Optional.of(this.success());
    }

    public Try<T> filter(Predicate<T> predicate) {
        return this.flatMap(t -> {
            if (predicate.test(t)) {
                return this;
            }
            return Try.fromFailure(new UnmatchedFilterPredicate());
        });
    }

    public void foreach(Consumer<T> consumer) {
        this.map(t -> {
            consumer.accept(t);
            return null;
        });
    }

    public static <A> Try<A> fromSuccess(A successVal) {
        return new Try(Either.right(successVal));
    }

    public static <A> Try<A> fromFailure(Throwable failureVal) {
        return new Try(Either.left((Object)failureVal));
    }

    public static <A> Try<A> doTry(FunctionThrowingException<A> fn) {
        try {
            return Try.fromSuccess(fn.apply());
        }
        catch (LambdaException e) {
            return Try.fromFailure(e.getCause());
        }
    }

    public static final class LambdaException
    extends RuntimeException {
        public LambdaException(Throwable cause) {
            super(cause);
        }
    }

    public static final class CallingSuccessOnFailureValue
    extends RuntimeException {
    }

    public static final class CallingFailureOnSuccessValue
    extends RuntimeException {
    }

    public static final class UnmatchedFilterPredicate
    extends Exception {
    }

    @FunctionalInterface
    public static interface FunctionThrowingException<A> {
        public A doApply() throws Throwable;

        default public A apply() {
            try {
                return this.doApply();
            }
            catch (Throwable t) {
                throw new LambdaException(t);
            }
        }
    }
}

