/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.BasicDataRow;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.frame.InputDataColumn;
import com.github.chen0040.data.frame.OutputDataColumn;
import com.github.chen0040.data.utils.CollectionUtils;
import com.github.chen0040.data.utils.TupleTwo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BasicDataFrame
implements DataFrame {
    private final List<DataRow> rows = new ArrayList<DataRow>();
    private final List<InputDataColumn> inputDataColumns = new ArrayList<InputDataColumn>();
    private final List<OutputDataColumn> outputDataColumns = new ArrayList<OutputDataColumn>();
    private boolean locked = false;

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public DataRow row(int i) {
        return this.rows.get(i);
    }

    @Override
    public List<InputDataColumn> getInputColumns() {
        return this.inputDataColumns;
    }

    @Override
    public List<OutputDataColumn> getOutputColumns() {
        return this.outputDataColumns;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() {
        HashMap counts = new HashMap();
        HashSet<String> numericOutputs = new HashSet<String>();
        HashSet<String> categoricalOutputs = new HashSet<String>();
        for (DataRow dataRow : this.rows) {
            List<String> keys = dataRow.getColumnNames();
            for (String key : keys) {
                Set<Double> set;
                if (counts.containsKey(key)) {
                    set = (Set)counts.get(key);
                } else {
                    set = new HashSet();
                    counts.put(key, set);
                }
                set.add(dataRow.getCell(key));
            }
            numericOutputs.addAll(dataRow.getTargetColumnNames());
            categoricalOutputs.addAll(dataRow.getCategoricalTargetColumnNames());
        }
        this.inputDataColumns.clear();
        for (Map.Entry entry : counts.entrySet()) {
            Set set = (Set)entry.getValue();
            InputDataColumn inputDataColumn = new InputDataColumn();
            inputDataColumn.setColumnName((String)entry.getKey());
            if (set.size() < this.rowCount() / 3) {
                inputDataColumn.setLevels(set);
            }
            this.inputDataColumns.add(inputDataColumn);
        }
        this.outputDataColumns.clear();
        this.outputDataColumns.addAll(numericOutputs.stream().map(o -> new OutputDataColumn((String)o, false)).collect(Collectors.toList()));
        this.outputDataColumns.addAll(categoricalOutputs.stream().map(o -> new OutputDataColumn((String)o, true)).collect(Collectors.toList()));
        this.inputDataColumns.sort((a, b) -> a.getColumnName().compareTo(b.getColumnName()));
        this.outputDataColumns.sort((a, b) -> a.getColumnName().compareTo(b.getColumnName()));
        List<String> inputColumns = this.inputDataColumns.stream().map(InputDataColumn::getColumnName).collect(Collectors.toList());
        List<String> list = this.outputDataColumns.stream().filter(c -> !c.isCategorical()).map(OutputDataColumn::getColumnName).collect(Collectors.toList());
        List<String> categoricalOutputColumns = this.outputDataColumns.stream().filter(OutputDataColumn::isCategorical).map(OutputDataColumn::getColumnName).collect(Collectors.toList());
        inputColumns.sort(String::compareTo);
        list.sort(String::compareTo);
        categoricalOutputColumns.sort(String::compareTo);
        for (int i = 0; i < this.rowCount(); ++i) {
            DataRow row = this.row(i);
            row.setColumnNames(inputColumns);
            row.setTargetColumnNames(list);
            row.setCategoricalTargetColumnNames(categoricalOutputColumns);
        }
        this.locked = true;
    }

    @Override
    public DataRow newRow() {
        return new BasicDataRow();
    }

    @Override
    public void addRow(DataRow row) {
        if (this.locked) {
            throw new RuntimeException("Data frame is currently locked, please unlock first");
        }
        this.rows.add(row);
    }

    @Override
    public String head(int limit) {
        StringBuilder sb = new StringBuilder();
        int max = Math.min(limit, this.rowCount());
        for (int i = 0; i < max; ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(this.row(i));
        }
        return sb.toString();
    }

    @Override
    public DataFrame shuffle() {
        Random random = new Random(System.currentTimeMillis());
        for (int i = 1; i < this.rows.size(); ++i) {
            int j = random.nextInt(i + 1);
            CollectionUtils.exchange(this.rows, i, j);
        }
        return this;
    }

    @Override
    public TupleTwo<DataFrame, DataFrame> split(double ratio) {
        int i;
        assert (this.locked);
        BasicDataFrame frame1 = new BasicDataFrame();
        BasicDataFrame frame2 = new BasicDataFrame();
        frame1.inputDataColumns.addAll(this.inputDataColumns.stream().map(InputDataColumn::makeCopy).collect(Collectors.toList()));
        frame2.inputDataColumns.addAll(this.inputDataColumns.stream().map(InputDataColumn::makeCopy).collect(Collectors.toList()));
        frame1.outputDataColumns.addAll(this.outputDataColumns.stream().map(OutputDataColumn::makeCopy).collect(Collectors.toList()));
        frame2.outputDataColumns.addAll(this.outputDataColumns.stream().map(OutputDataColumn::makeCopy).collect(Collectors.toList()));
        int split = (int)((double)this.rows.size() * ratio);
        for (i = 0; i < split; ++i) {
            frame1.addRow(this.rows.get(i).makeCopy());
        }
        for (i = split; i < this.rows.size(); ++i) {
            frame2.addRow(this.rows.get(i).makeCopy());
        }
        return new TupleTwo<DataFrame, DataFrame>(frame1, frame2);
    }

    @Override
    public Stream<DataRow> stream() {
        return this.rows.stream();
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }
}

