/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.frame.OutputDataColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class Sampler {
    public ColumnBuilder forColumn(String column) {
        return new SampleBuilder().forColumn(column);
    }

    private static class SampleBuilder
    implements RowBuilder,
    ColumnBuilder,
    DataSampleBuilder {
        private int count;
        private String currentColumnName;
        private Map<String, BiFunction<String, Integer, Double>> generators = new HashMap<String, BiFunction<String, Integer, Double>>();

        @Override
        public RowBuilder generate(BiFunction<String, Integer, Double> generator) {
            this.generators.put(this.currentColumnName, generator);
            return this;
        }

        @Override
        public ColumnBuilder forColumn(String columnName) {
            this.currentColumnName = columnName;
            return this;
        }

        @Override
        public DataSampleBuilder end() {
            return this;
        }

        @Override
        public DataFrame sample(DataFrame dataFrame, int count) {
            if (this.generators.isEmpty()) {
                throw new RuntimeException("No column generators are designed to build a row!");
            }
            this.count = count;
            this.currentColumnName = null;
            dataFrame.unlock();
            Set outputColumns = dataFrame.getOutputColumns().stream().map(OutputDataColumn::getColumnName).collect(Collectors.toSet());
            for (int i = 0; i < count; ++i) {
                DataRow newRow = dataFrame.newRow();
                for (Map.Entry<String, BiFunction<String, Integer, Double>> entry : this.generators.entrySet()) {
                    String columnName = entry.getKey();
                    BiFunction<String, Integer, Double> generator = entry.getValue();
                    if (outputColumns.contains(columnName)) {
                        newRow.setTargetCell(columnName, generator.apply(columnName, i));
                        continue;
                    }
                    newRow.setCell(columnName, generator.apply(columnName, i));
                }
                dataFrame.addRow(newRow);
            }
            dataFrame.lock();
            return dataFrame;
        }
    }

    public static interface DataSampleBuilder {
        public DataFrame sample(DataFrame var1, int var2);
    }

    public static interface ColumnBuilder {
        public RowBuilder generate(BiFunction<String, Integer, Double> var1);
    }

    public static interface RowBuilder {
        public ColumnBuilder forColumn(String var1);

        public DataSampleBuilder end();
    }
}

