/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.text;

import com.github.chen0040.data.text.TextFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PorterStemmer
implements TextFilter,
Serializable {
    private static final long serialVersionUID = -283938886140264059L;

    @Override
    public List<String> filter(List<String> words) {
        ArrayList<String> result = new ArrayList<String>();
        for (String word : words) {
            result.add(PorterStemmer.Stem(word));
        }
        return result;
    }

    public static String Stem(String word) {
        char[] b = word.toCharArray();
        int[] jk = new int[]{0, 0};
        jk[1] = b.length - 1;
        if (jk[1] > 1) {
            PorterStemmer.Step1(b, jk);
            PorterStemmer.Step2(b, jk);
            PorterStemmer.Step3(b, jk);
            PorterStemmer.Step4(b, jk);
            PorterStemmer.Step5(b, jk);
            PorterStemmer.Step6(b, jk);
        }
        return new String(b, 0, jk[1] + 1);
    }

    private static int GetConsonantSeqCount(char[] b, int j) {
        int n = 0;
        int i = 0;
        while (true) {
            if (i > j) {
                return n;
            }
            if (!PorterStemmer.IsConsonant(b, i)) break;
            ++i;
        }
        ++i;
        while (i <= j) {
            if (!PorterStemmer.IsConsonant(b, i)) {
                ++i;
                continue;
            }
            ++i;
            ++n;
            while (true) {
                if (i > j) {
                    return n;
                }
                if (!PorterStemmer.IsConsonant(b, i)) break;
                ++i;
            }
            ++i;
        }
        return n;
    }

    private static boolean IsConsonant(char[] b, int i) {
        switch (b[i]) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return false;
            }
            case 'y': {
                return i == 0 ? true : !PorterStemmer.IsConsonant(b, i - 1);
            }
        }
        return true;
    }

    private static boolean ContainsVowel(char[] b, int j) {
        for (int i = 0; i <= j; ++i) {
            if (PorterStemmer.IsConsonant(b, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean IsConsonantVowelConsonant(char[] b, int i) {
        if (i < 2 || !PorterStemmer.IsConsonant(b, i) || PorterStemmer.IsConsonant(b, i - 1) || !PorterStemmer.IsConsonant(b, i - 2)) {
            return false;
        }
        char ch = b[i];
        return ch != 'w' && ch != 'x' && ch != 'y';
    }

    private static boolean EndsWith(char[] b, int[] jk, String s) {
        int l = s.length();
        int o = jk[1] - l + 1;
        if (o < 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (b[o + i] == s.charAt(i)) continue;
            return false;
        }
        jk[0] = jk[1] - l;
        return true;
    }

    private static void Replace(char[] b, int[] jk, String s) {
        int l = s.length();
        int o = jk[0] + 1;
        for (int i = 0; i < l; ++i) {
            b[o + i] = s.charAt(i);
        }
        jk[1] = jk[0] + l;
    }

    private static boolean IsDoubleConsonant(char[] b, int j) {
        if (j < 1) {
            return false;
        }
        if (b[j] != b[j - 1]) {
            return false;
        }
        return PorterStemmer.IsConsonant(b, j);
    }

    private static void Step1(char[] b, int[] jk) {
        if (b[jk[1]] == 's') {
            if (PorterStemmer.EndsWith(b, jk, "sses")) {
                jk[1] = jk[1] - 2;
            } else if (PorterStemmer.EndsWith(b, jk, "ies")) {
                PorterStemmer.Replace(b, jk, "i");
            } else if (b[jk[1] - 1] != 's') {
                jk[1] = jk[1] - 1;
            }
        }
        if (PorterStemmer.EndsWith(b, jk, "eed")) {
            if (PorterStemmer.GetConsonantSeqCount(b, jk[0]) > 0) {
                jk[1] = jk[1] - 1;
            }
        } else if ((PorterStemmer.EndsWith(b, jk, "ed") || PorterStemmer.EndsWith(b, jk, "ing")) && PorterStemmer.ContainsVowel(b, jk[0])) {
            jk[1] = jk[0];
            if (PorterStemmer.EndsWith(b, jk, "at")) {
                PorterStemmer.Replace(b, jk, "ate");
            } else if (PorterStemmer.EndsWith(b, jk, "bl")) {
                PorterStemmer.Replace(b, jk, "ble");
            } else if (PorterStemmer.EndsWith(b, jk, "iz")) {
                PorterStemmer.Replace(b, jk, "ize");
            } else if (PorterStemmer.IsDoubleConsonant(b, jk[1])) {
                jk[1] = jk[1] - 1;
                char ch = b[jk[1]];
                if (ch == 'l' || ch == 's' || ch == 'z') {
                    jk[1] = jk[1] + 1;
                }
            } else if (PorterStemmer.GetConsonantSeqCount(b, jk[0]) == 1 && PorterStemmer.IsConsonantVowelConsonant(b, jk[1])) {
                PorterStemmer.Replace(b, jk, "e");
            }
        }
    }

    private static void Step2(char[] b, int[] jk) {
        int j = jk[0];
        int k = jk[1];
        if (PorterStemmer.EndsWith(b, jk, "y") && PorterStemmer.ContainsVowel(b, j)) {
            b[k] = 105;
        }
    }

    private static void r(char[] b, int[] jk, String s) {
        int j = jk[0];
        int k = jk[1];
        if (PorterStemmer.GetConsonantSeqCount(b, j) > 0) {
            PorterStemmer.Replace(b, jk, s);
        }
    }

    private static void Step3(char[] b, int[] jk) {
        if (jk[1] == 0) {
            return;
        }
        switch (b[jk[1] - 1]) {
            case 'a': {
                if (PorterStemmer.EndsWith(b, jk, "ational")) {
                    PorterStemmer.r(b, jk, "ate");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "tional")) break;
                PorterStemmer.r(b, jk, "tion");
                break;
            }
            case 'c': {
                if (PorterStemmer.EndsWith(b, jk, "enci")) {
                    PorterStemmer.r(b, jk, "ence");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "anci")) break;
                PorterStemmer.r(b, jk, "ance");
                break;
            }
            case 'e': {
                if (!PorterStemmer.EndsWith(b, jk, "izer")) break;
                PorterStemmer.r(b, jk, "ize");
                break;
            }
            case 'l': {
                if (PorterStemmer.EndsWith(b, jk, "bli")) {
                    PorterStemmer.r(b, jk, "ble");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "alli")) {
                    PorterStemmer.r(b, jk, "al");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "entli")) {
                    PorterStemmer.r(b, jk, "ent");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "eli")) {
                    PorterStemmer.r(b, jk, "e");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "ousli")) break;
                PorterStemmer.r(b, jk, "ous");
                break;
            }
            case 'o': {
                if (PorterStemmer.EndsWith(b, jk, "ization")) {
                    PorterStemmer.r(b, jk, "ize");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "ation")) {
                    PorterStemmer.r(b, jk, "ate");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "ator")) break;
                PorterStemmer.r(b, jk, "ate");
                break;
            }
            case 's': {
                if (PorterStemmer.EndsWith(b, jk, "alism")) {
                    PorterStemmer.r(b, jk, "al");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "iveness")) {
                    PorterStemmer.r(b, jk, "ive");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "fulness")) {
                    PorterStemmer.r(b, jk, "ful");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "ousness")) break;
                PorterStemmer.r(b, jk, "ous");
                break;
            }
            case 't': {
                if (PorterStemmer.EndsWith(b, jk, "aliti")) {
                    PorterStemmer.r(b, jk, "al");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "iviti")) {
                    PorterStemmer.r(b, jk, "ive");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "biliti")) break;
                PorterStemmer.r(b, jk, "ble");
                break;
            }
            case 'g': {
                if (!PorterStemmer.EndsWith(b, jk, "logi")) break;
                PorterStemmer.r(b, jk, "log");
            }
        }
    }

    private static void Step4(char[] b, int[] jk) {
        switch (b[jk[1]]) {
            case 'e': {
                if (PorterStemmer.EndsWith(b, jk, "icate")) {
                    PorterStemmer.r(b, jk, "ic");
                    break;
                }
                if (PorterStemmer.EndsWith(b, jk, "ative")) {
                    PorterStemmer.r(b, jk, "");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "alize")) break;
                PorterStemmer.r(b, jk, "al");
                break;
            }
            case 'i': {
                if (!PorterStemmer.EndsWith(b, jk, "iciti")) break;
                PorterStemmer.r(b, jk, "ic");
                break;
            }
            case 'l': {
                if (PorterStemmer.EndsWith(b, jk, "ical")) {
                    PorterStemmer.r(b, jk, "ic");
                    break;
                }
                if (!PorterStemmer.EndsWith(b, jk, "ful")) break;
                PorterStemmer.r(b, jk, "");
                break;
            }
            case 's': {
                if (!PorterStemmer.EndsWith(b, jk, "ness")) break;
                PorterStemmer.r(b, jk, "");
            }
        }
    }

    private static void Step5(char[] b, int[] jk) {
        if (jk[1] == 0) {
            return;
        }
        switch (b[jk[1] - 1]) {
            case 'a': {
                if (PorterStemmer.EndsWith(b, jk, "al")) break;
                return;
            }
            case 'c': {
                if (PorterStemmer.EndsWith(b, jk, "ance") || PorterStemmer.EndsWith(b, jk, "ence")) break;
                return;
            }
            case 'e': {
                if (PorterStemmer.EndsWith(b, jk, "er")) break;
                return;
            }
            case 'i': {
                if (PorterStemmer.EndsWith(b, jk, "ic")) break;
                return;
            }
            case 'l': {
                if (PorterStemmer.EndsWith(b, jk, "able") || PorterStemmer.EndsWith(b, jk, "ible")) break;
                return;
            }
            case 'n': {
                if (PorterStemmer.EndsWith(b, jk, "ant") || PorterStemmer.EndsWith(b, jk, "ement") || PorterStemmer.EndsWith(b, jk, "ment") || PorterStemmer.EndsWith(b, jk, "ent")) break;
                return;
            }
            case 'o': {
                if (PorterStemmer.EndsWith(b, jk, "ion") && jk[0] >= 0 && (b[jk[0]] == 's' || b[jk[0]] == 't') || PorterStemmer.EndsWith(b, jk, "ou")) break;
                return;
            }
            case 's': {
                if (PorterStemmer.EndsWith(b, jk, "ism")) break;
                return;
            }
            case 't': {
                if (PorterStemmer.EndsWith(b, jk, "ate") || PorterStemmer.EndsWith(b, jk, "iti")) break;
                return;
            }
            case 'u': {
                if (PorterStemmer.EndsWith(b, jk, "ous")) break;
                return;
            }
            case 'v': {
                if (PorterStemmer.EndsWith(b, jk, "ive")) break;
                return;
            }
            case 'z': {
                if (PorterStemmer.EndsWith(b, jk, "ize")) break;
                return;
            }
            default: {
                return;
            }
        }
        if (PorterStemmer.GetConsonantSeqCount(b, jk[0]) > 1) {
            jk[1] = jk[0];
        }
    }

    private static void Step6(char[] b, int[] jk) {
        int a;
        jk[0] = jk[1];
        if (b[jk[1]] == 'e' && ((a = PorterStemmer.GetConsonantSeqCount(b, jk[0])) > 1 || a == 1 && !PorterStemmer.IsConsonantVowelConsonant(b, jk[1] - 1))) {
            jk[1] = jk[1] - 1;
        }
        if (b[jk[1]] == 'l' && PorterStemmer.IsDoubleConsonant(b, jk[1]) && PorterStemmer.GetConsonantSeqCount(b, jk[0]) > 1) {
            jk[1] = jk[1] - 1;
        }
    }

    public Object clone() {
        return new PorterStemmer();
    }
}

