/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.teststeps;

import java.io.Serializable;
import se.claremont.taf.core.gui.teststructure.TestCaseManager;
import se.claremont.taf.core.gui.teststructure.TestStepResult;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.gui.teststeps.JavaTestStep;

public class JavaStartApplicationTestStep
extends JavaTestStep
implements Serializable {
    ApplicationUnderTest applicationUnderTest;

    public JavaStartApplicationTestStep() {
    }

    public JavaStartApplicationTestStep(String name, String description) {
        super(name, description);
    }

    public JavaStartApplicationTestStep(ApplicationUnderTest applicationUnderTest) {
        this.applicationUnderTest = applicationUnderTest;
        this.setName("Start " + applicationUnderTest.friendlyName);
        this.setActionName("Start");
        this.setElementName(applicationUnderTest.friendlyName);
        this.setAssociatedData(applicationUnderTest.startMechanism.startUrlOrPathToJarFile + " " + applicationUnderTest.startMechanism.mainClass + " " + String.join((CharSequence)" ", applicationUnderTest.startMechanism.arguments));
    }

    @Override
    public JavaStartApplicationTestStep clone() {
        JavaStartApplicationTestStep clonedStep = new JavaStartApplicationTestStep(this.getName(), this.getDescription());
        clonedStep.setActionName(this.actionName);
        clonedStep.setElementName(this.elementName);
        clonedStep.setAssociatedData(this.data);
        clonedStep.applicationUnderTest = this.applicationUnderTest;
        return clonedStep;
    }

    @Override
    public String asCode() {
        TestCaseManager.testSetCode.makeSureRequiredImportIsAdded("import se.claremont.autotest.javasupport.applicationundertest.*;");
        String code = "ApplicationStartMechanism asm = new ApplicationStartMechanism(currentTestCase());" + System.lineSeparator();
        code = code + "asm.startUrlOrPathToJarFile = \"" + this.applicationUnderTest.startMechanism.startUrlOrPathToJarFile + "\";" + System.lineSeparator();
        code = code + "asm.mainClass = \"" + this.applicationUnderTest.startMechanism.mainClass + "\";" + System.lineSeparator();
        code = code + "asm.arguments = new String[]{\"" + String.join((CharSequence)"\", \"", this.applicationUnderTest.startMechanism.arguments) + "\"};" + System.lineSeparator();
        code = code + "ApplicationUnderTest aut = new ApplicationUnderTest(currentTestCase(), asm);" + System.lineSeparator();
        code = code + "aut.start();";
        return code;
    }

    @Override
    public TestStepResult execute() {
        TestCaseManager.startTestStep();
        this.applicationUnderTest.reAssignTestCase(TestCaseManager.getTestCase());
        TestStepResult result = new TestStepResult();
        result.updateResultStatus(TestStepResult.Result.NOT_RUN);
        try {
            this.applicationUnderTest.start();
            result.updateResultStatus(TestStepResult.Result.PASS);
        }
        catch (Exception e) {
            result.updateResultStatus(TestStepResult.Result.FAIL);
        }
        TestCaseManager.wrapUpTestCase();
        return result;
    }
}

