/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.teststeps;

import java.io.Serializable;
import se.claremont.taf.core.gui.teststructure.TestCaseManager;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.core.gui.teststructure.TestStepResult;
import se.claremont.taf.javasupport.gui.teststeps.JavaTestStep;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;

public class JavaTextTypedTestStep
extends JavaTestStep
implements Serializable {
    JavaGuiElement javaGuiElement;

    public JavaTextTypedTestStep(String name, String description) {
        super(name, description);
    }

    public JavaTextTypedTestStep(String text, JavaGuiElement javaGuiElement) {
        this.setActionName("Type");
        this.setDescription("Typing text '" + text + "' to element '" + javaGuiElement.getName() + "'.");
        this.setElementName(javaGuiElement.getName());
        this.setAssociatedData(text);
        this.javaGuiElement = javaGuiElement;
    }

    @Override
    public JavaTextTypedTestStep clone() {
        JavaTextTypedTestStep clonedStep = new JavaTextTypedTestStep(this.getName(), this.getDescription());
        clonedStep.setActionName(this.actionName);
        clonedStep.setElementName(this.elementName);
        clonedStep.setAssociatedData(this.data);
        clonedStep.javaGuiElement = this.javaGuiElement;
        return clonedStep;
    }

    @Override
    public String asCode() {
        TestCaseManager.testSetCode.makeSureRequiredImportIsAdded("import se.claremont.autotest.javasupport.interaction.*;");
        TestCaseManager.testSetCode.makeSureClassVariableIsDeclared("GenericInteractionMethods java;");
        TestCaseManager.testSetCode.makeSureBeginTestSectionDeclarationExist("java = new GenericInteractionMethods(currentTestCase());");
        return "java.write(" + this.data + ", " + this.javaGuiElement.getName() + ");";
    }

    @Override
    public TestStepResult execute() {
        TestStepResult testStepResult;
        TestCaseManager.startTestStep();
        GenericInteractionMethods java = new GenericInteractionMethods(TestCaseManager.getTestCase());
        try {
            java.write(this.javaGuiElement, (String)this.data);
            testStepResult = new TestStepResult((TestStep)this, TestStepResult.Result.PASS);
        }
        catch (Exception e) {
            testStepResult = new TestStepResult((TestStep)this, TestStepResult.Result.FAIL);
        }
        TestCaseManager.wrapUpTestCase();
        return testStepResult;
    }
}

