/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.interaction;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import se.claremont.taf.core.logging.LogFolder;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.logging.LogPost;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.core.testrun.TestRun;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.javasupport.objectstructure.GuiComponent;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;
import se.claremont.taf.javasupport.objectstructure.JavaWindow;

public class GenericInteractionMethods {
    public TestCase testCase;
    public int standardTimeout = 5;
    MethodInvoker methodInvoker;
    ApplicationUnderTest app;

    public GenericInteractionMethods(TestCase testCase) {
        this.testCase = testCase;
        this.methodInvoker = new MethodInvoker(testCase);
    }

    public void setApplicationUnderTest(ApplicationUnderTest app) {
        this.app = app;
    }

    public Object getParentComponent(Object component) {
        Object parent = this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.componentParentGetterMethodsInAttemptOrder);
        if (parent == null) {
            this.log(LogLevel.DEBUG, "Could not find any parent for element " + component.toString() + ".");
        } else {
            this.log(LogLevel.DEBUG, "Found parent for element.");
        }
        return parent;
    }

    public Object getContainerComponent(Object component) {
        Object parent = this.getParentComponent(component);
        if (parent == null) {
            this.log(LogLevel.DEBUG, "Could not get any contaner component since no parent element could be identified.");
            return null;
        }
        if (this.methodInvoker.invokeTheFirstEncounteredMethod(parent, MethodDeclarations.subComponentGetterMethodsInAttemptOrder) != null) {
            this.log(LogLevel.DEBUG, "Found container component.");
            return parent;
        }
        return this.getContainerComponent(parent);
    }

    public ArrayList<Object> allSubElementsOf(Object component) {
        if (component.getClass().equals(JavaGuiElement.class)) {
            component = ((JavaGuiElement)component).getRuntimeComponent();
        }
        ArrayList<Object> componentList = new ArrayList<Object>();
        Object[] returnList = (Object[])MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(component, MethodDeclarations.subAllComponentsGettersMethodsInAttemptOrder);
        if (returnList != null && returnList.length > 0) {
            for (Object object : returnList) {
                componentList.add(object);
                componentList.addAll(this.addSubComponents(object));
            }
            return componentList;
        }
        Integer componentCount = (Integer)MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(component, MethodDeclarations.subComponentCountMethodsInAttemptOrder);
        if (componentCount == null) {
            return componentList;
        }
        for (int i = 0; i < componentCount; ++i) {
            Object subElement = MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder, i);
            if (subElement == null) continue;
            componentList.add(subElement);
            componentList.addAll(this.addSubComponents(subElement));
        }
        return componentList;
    }

    public void debug_LogCurrentActiveWindows() {
        if (this.app == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "You need to use the method setApplicationUnderTest() in the GenericInteractionMethods class in order to use the logCurrentActiveWindows() method.");
            return;
        }
        ApplicationUnderTest.logCurrentWindows(this.testCase);
    }

    public String getName(Object component) {
        return (String)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.componentNameGetterMethodsInAttemptOrder);
    }

    public static void takeScreenshot(TestCase testCase) {
        GenericInteractionMethods g = new GenericInteractionMethods(testCase);
        g.takeScreenshot();
    }

    private BufferedImage GrabAllScreens() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        Rectangle allScreenBounds = new Rectangle();
        for (GraphicsDevice screen : screens) {
            Rectangle screenBounds = screen.getDefaultConfiguration().getBounds();
            allScreenBounds.width += screenBounds.width;
            allScreenBounds.height = Math.max(allScreenBounds.height, screenBounds.height);
        }
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            this.log(LogLevel.DEBUG, "Could not start Robot framework for taking desktop screenshot.");
            return null;
        }
        BufferedImage screenShot = robot.createScreenCapture(allScreenBounds);
        return screenShot;
    }

    private String saveScreenshotToFile(BufferedImage screenShot) {
        String filePath = LogFolder.testRunLogFolder + this.testCase.testName + TestRun.getFileCounter() + ".png";
        TestRun.increaseFileCounter();
        try {
            if (screenShot == null) {
                this.log(LogLevel.INFO, "Could not take desktop screenshot.");
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)screenShot, "png", baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            SupportMethods.saveToFile((byte[])imageInByte, (String)filePath);
        }
        catch (Exception e) {
            this.log(LogLevel.INFO, "Could not save desktop screenshot. Error: " + e.toString());
            return null;
        }
        return filePath;
    }

    public void takeScreenshot() {
        BufferedImage screenShot = this.GrabAllScreens();
        String fileName = this.saveScreenshotToFile(screenShot);
        this.logDesktopScreenshot(fileName);
    }

    private void logDesktopScreenshot(String filePath) {
        String htmlFilePath = filePath.replace("\\", "/");
        String[] parts = htmlFilePath.split("/");
        htmlFilePath = parts[parts.length - 1];
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.INFO, "Saved desktop screenshot as '" + filePath + "'.", "Saved desktop screenshot as <a href=\"" + htmlFilePath + "\" target=\"_blank\"><span class=\"screenshotfile\">" + filePath + "</span></a><br><a href=\"" + htmlFilePath + "\" target=\"_blank\"><img src=\"" + htmlFilePath + "\" alt=\"browser screenshot\" class=\"screenshot\"></a>");
    }

    public List<String> getSelected(GuiComponent guiComponent) {
        long startTime = System.currentTimeMillis();
        if (guiComponent == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Attempting to get selected value from a null component.");
            this.takeScreenshot();
            return null;
        }
        JavaGuiElement javaGuiElement = (JavaGuiElement)guiComponent;
        javaGuiElement.clearCache();
        Component component = javaGuiElement.getRuntimeComponent();
        while (component == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            component = javaGuiElement.getRuntimeComponent();
        }
        if (component == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Cannot identify element '" + guiComponent.getName() + "' to retrieve selected value(s) from.");
            javaGuiElement.logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            return null;
        }
        javaGuiElement.logIdentification(LogLevel.DEBUG, this.testCase);
        ArrayList<String> returnValues = new ArrayList<String>();
        if (JSpinner.class.isAssignableFrom(component.getClass())) {
            JSpinner spinner = (JSpinner)component;
            returnValues.add(spinner.getModel().getValue().toString());
            this.testCase.log(LogLevel.DEBUG, "Identified '" + String.join((CharSequence)"', '", returnValues) + "' as selected for JSpinner '" + guiComponent.getName() + "'.");
            return returnValues;
        }
        if (JComboBox.class.isAssignableFrom(component.getClass())) {
            JComboBox comboBox = (JComboBox)component;
            for (Object selection : comboBox.getSelectedObjects()) {
                returnValues.add(selection.toString());
            }
            this.testCase.log(LogLevel.DEBUG, "Identified '" + String.join((CharSequence)"', '", returnValues) + "' as selected for JComboBoc '" + guiComponent.getName() + "'.");
            return returnValues;
        }
        this.testCase.log(LogLevel.DEBUG, "No getSelected() method implemented for class '" + component.getClass() + "'.");
        return null;
    }

    public String getText(Object component) {
        String returnText = null;
        if (component == null) {
            this.log(LogLevel.DEBUG, "Could not retrieve any text from a null object.");
            return null;
        }
        returnText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.textGettingMethodsInAttemptOrder);
        return returnText;
    }

    public void bringWindowOfElementToFront(GuiComponent component) {
        if (component == null) {
            this.testCase.log(LogLevel.DEBUG, "Cannot bring the window of a null element to the front of the GUI. Skipping that.");
            return;
        }
        Component window = (Component)component.getRuntimeComponent();
        if (window == null) {
            this.testCase.log(LogLevel.DEBUG, "Cannot bring the window of a null element to the front of the GUI. Skipping that.");
            return;
        }
        while (!Window.class.isAssignableFrom(window.getClass()) && (window = window.getParent()) != null) {
        }
        if (window == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not bring window of '" + component.getName() + "' to the front of the GUI.");
            return;
        }
        this.testCase.log(LogLevel.DEBUG, "Bringing window of component '" + component.getName() + "' to the front of the GUI.");
        ((Window)window).toFront();
    }

    public void click(GuiComponent guiElement) {
        long startTime = System.currentTimeMillis();
        JavaGuiElement javaGuiElement = (JavaGuiElement)guiElement;
        javaGuiElement.clearCache();
        Component component = javaGuiElement.getRuntimeComponent();
        javaGuiElement.logIdentification(LogLevel.DEBUG, this.testCase);
        while (component == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            component = javaGuiElement.getRuntimeComponent();
        }
        if (component == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not click on element " + guiElement.getName() + " since it could not be identified.");
            ((JavaGuiElement)guiElement).logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            if (this.testCase != null) {
                this.testCase.report();
            }
            return;
        }
        try {
            while (!component.isEnabled() && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
                this.wait(50);
            }
            if (!component.isEnabled()) {
                this.log(LogLevel.DEBUG, "Element '" + guiElement.getName() + "' was identified but it never became enabled within the timeout of " + this.standardTimeout + " seconds.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (JButton.class.isAssignableFrom(component.getClass())) {
            JButton button = (JButton)component;
            if (!button.isEnabled()) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Button '" + guiElement.getName() + "' is not enabled. Attempting to click it anyway.");
            }
            for (ActionListener al : button.getActionListeners()) {
                al.actionPerformed(new ActionEvent(button, 16, "ACTION_PERFORMED"));
            }
            this.testCase.log(LogLevel.EXECUTED, "Clicked the " + guiElement.getName() + " component.");
            return;
        }
        if (Button.class.isAssignableFrom(component.getClass())) {
            Button button = (Button)component;
            while (!button.isEnabled() && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
                this.wait(50);
            }
            if (!button.isEnabled()) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Button '" + guiElement.getName() + "' is not enabled. Attempting to click it anyway.");
            }
            for (ActionListener al : button.getActionListeners()) {
                al.actionPerformed(new ActionEvent(button, 16, "ACTION_PERFORMED"));
            }
            this.testCase.log(LogLevel.EXECUTED, "Clicked the " + guiElement.getName() + " component.");
            return;
        }
        this.bringWindowOfElementToFront(guiElement);
        Point clickPoint = this.getClickablePoint(guiElement);
        if (clickPoint == null) {
            return;
        }
        Robot r = null;
        try {
            r = new Robot();
            r.mouseMove(clickPoint.x, clickPoint.y);
            r.mousePress(16);
            r.mouseRelease(16);
            this.log(LogLevel.EXECUTED, "Clicked the " + guiElement.getName() + " component.");
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void clickByRawMouseAction(GuiComponent guiElement) {
        long startTime = System.currentTimeMillis();
        Object c = guiElement.getRuntimeComponent();
        while (c == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            c = guiElement.getRuntimeComponent();
        }
        if (c == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not click on element " + guiElement.getName() + " since it could not be identified.");
            ((JavaGuiElement)guiElement).logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            if (this.testCase != null) {
                this.testCase.report();
            }
            return;
        }
        ((JavaGuiElement)guiElement).logIdentification(LogLevel.DEBUG, this.testCase);
        this.bringWindowOfElementToFront(guiElement);
        Point clickPoint = this.getClickablePoint(guiElement);
        if (clickPoint == null) {
            return;
        }
        Robot r = null;
        try {
            r = new Robot();
            r.mouseMove(clickPoint.x, clickPoint.y);
            r.mousePress(16);
            r.mouseRelease(16);
            this.log(LogLevel.EXECUTED, "Clicked the " + guiElement.getName() + " component.");
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void clickElementWithText(JavaWindow window, String textOfElementToClick) {
        String objectText;
        for (Component object : window.getComponents()) {
            try {
                objectText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                if (objectText == null || !objectText.equals(textOfElementToClick)) continue;
                this.click(new JavaGuiElement(object));
                return;
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not retrieve text from object " + ((Object)object).toString() + " or could turn it into a JavaGuiElement, or could not click it. Error: " + e.toString());
            }
        }
        for (Component object : window.getComponents()) {
            try {
                objectText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                if (objectText == null || !objectText.contains(textOfElementToClick)) continue;
                this.click(new JavaGuiElement(object));
                return;
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not retrieve text from object " + ((Object)object).toString() + " or could turn it into a JavaGuiElement, or could not click it. Error: " + e.toString());
            }
        }
        for (Component object : window.getComponents()) {
            try {
                objectText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                if (objectText == null || !SupportMethods.isRegexMatch((String)objectText, (String)textOfElementToClick)) continue;
                this.click(new JavaGuiElement(object));
                return;
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not retrieve text from object " + ((Object)object).toString() + " or could turn it into a JavaGuiElement, or could not click it. Error: " + e.toString());
            }
        }
    }

    public void clickElementWithText(GuiComponent parentElement, String textOfElementToClick) {
        String objectText;
        String elementText = this.getText(parentElement);
        if (elementText != null && (elementText.equals(textOfElementToClick) || elementText.contains(textOfElementToClick) || SupportMethods.isRegexMatch((String)elementText, (String)textOfElementToClick))) {
            this.click(parentElement);
            this.log(LogLevel.EXECUTED, "Choosed '" + textOfElementToClick + "' in radiobutton " + parentElement.getName() + ".");
            return;
        }
        JavaGuiElement javaGuiElement = (JavaGuiElement)parentElement;
        for (JavaGuiElement object : javaGuiElement.getSubElements()) {
            try {
                objectText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                if (objectText == null || !objectText.equals(textOfElementToClick)) continue;
                this.click(new JavaGuiElement((Object)object));
                return;
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not retrieve text from object " + ((Object)object).toString() + " or could turn it into a JavaGuiElement, or could not click it. Error: " + e.toString());
            }
        }
        for (JavaGuiElement object : javaGuiElement.getSubElements()) {
            try {
                objectText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                if (objectText == null || !objectText.contains(textOfElementToClick)) continue;
                this.click(new JavaGuiElement((Object)object));
                return;
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not retrieve text from object " + ((Object)object).toString() + " or could turn it into a JavaGuiElement, or could not click it. Error: " + e.toString());
            }
        }
        for (JavaGuiElement object : javaGuiElement.getSubElements()) {
            try {
                objectText = (String)this.methodInvoker.invokeTheFirstEncounteredMethod((Object)object, MethodDeclarations.textGettingMethodsInAttemptOrder);
                if (objectText == null || !SupportMethods.isRegexMatch((String)objectText, (String)textOfElementToClick)) continue;
                this.click(new JavaGuiElement((Object)object));
                return;
            }
            catch (Exception e) {
                this.log(LogLevel.DEBUG, "Could not retrieve text from object " + ((Object)object).toString() + " or could turn it into a JavaGuiElement, or could not click it. Error: " + e.toString());
            }
        }
    }

    public void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void write(GuiComponent guiComponent, String textToWrite) {
        this.performWrite(guiComponent, textToWrite, true);
    }

    public void writeWithoutCheck(GuiComponent guiComponent, String textToWrite) {
        this.performWrite(guiComponent, textToWrite, false);
    }

    public void chooseRadioButton(GuiComponent guiElement, String textOfElementToChoose) {
        JavaGuiElement javaGuiElement = null;
        try {
            javaGuiElement = (JavaGuiElement)guiElement;
        }
        catch (Exception e) {
            this.log(LogLevel.DEBUG, "Could not convert element " + guiElement.getName() + " to a JavaGuiElement to use it as a RadioButton.");
            this.takeScreenshot();
            return;
        }
        this.clickElementWithText(javaGuiElement, textOfElementToChoose);
        this.log(LogLevel.EXECUTED, "Choosed '" + textOfElementToChoose + "' in radiobutton " + javaGuiElement.getName() + ".");
    }

    public void selectInDropdown(GuiComponent guiElement, String selection) {
        String option;
        Object optionObject;
        int i;
        Object component = guiElement.getRuntimeComponent();
        if (component == null) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not identify " + guiElement.getName() + ". Tried by identification procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Could not identify " + guiElement.getName() + ". Tried by identification procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
            return;
        }
        this.bringWindowOfElementToFront(guiElement);
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Identified element " + guiElement.getName() + " by: " + guiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Identified element " + guiElement.getName() + " by:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
        Integer optionCount = (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.getItemCountOfComboBoxOptions);
        if (optionCount == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not retrieve item count of combobox " + guiElement.getName() + ".");
            return;
        }
        ArrayList<String> options = new ArrayList<String>();
        for (i = 0; i < optionCount; ++i) {
            optionObject = MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.getSpecificComboBoxItemBasedOnIndex, i);
            if (optionObject == null) continue;
            option = optionObject.toString();
            options.add(option);
        }
        this.log(LogLevel.DEBUG, "Available options in dropdown " + guiElement.getName() + ": '" + String.join((CharSequence)"', '", options + "'."));
        for (i = 0; i < optionCount; ++i) {
            optionObject = MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.getSpecificComboBoxItemBasedOnIndex, i);
            if (optionObject == null || !(option = optionObject.toString()).equals(selection)) continue;
            this.log(LogLevel.EXECUTED, "Selecting '" + selection + "' in dropdown " + guiElement.getName() + ".");
            MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.setSelectionItemBasedOnIndex, i);
            return;
        }
        for (i = 0; i < optionCount; ++i) {
            optionObject = MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.getSpecificComboBoxItemBasedOnIndex, i);
            if (optionObject == null || !(option = optionObject.toString()).contains(selection)) continue;
            this.log(LogLevel.EXECUTED, "Selecting '" + selection + "' in dropdown " + guiElement.getName() + ". Actual selection option was '" + option + "'.");
            MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.setSelectionItemBasedOnIndex, i);
            return;
        }
        for (i = 0; i < optionCount; ++i) {
            optionObject = MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.getSpecificComboBoxItemBasedOnIndex, i);
            if (optionObject == null || !SupportMethods.isRegexMatch((String)(option = optionObject.toString()), (String)selection)) continue;
            this.log(LogLevel.EXECUTED, "Selecting '" + option + "' in dropdown " + guiElement.getName() + " based on regular expression pattern '" + selection + "'.");
            MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.setSelectionItemBasedOnIndex, i);
            return;
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Could not select '" + selection + "' in dropdown " + guiElement.getName() + "'. Identified available choices were:" + System.lineSeparator() + "'" + String.join((CharSequence)("'" + System.lineSeparator() + "'"), options) + "'");
    }

    public String getDropDownSelectedOption(GuiComponent guiComponent) {
        List<String> selections = this.getDropDownSelectedOptions(guiComponent);
        if (selections.size() == 1) {
            return selections.get(0);
        }
        this.log(LogLevel.DEBUG, "Several selections of dropdown " + guiComponent.getName() + ". Selected values are '" + String.join((CharSequence)"', '", selections) + "'. Returning all selections.");
        return "[" + String.join((CharSequence)"], [", selections) + "]";
    }

    public List<String> getDropDownSelectedOptions(GuiComponent guiElement) {
        ArrayList<String> selections = new ArrayList<String>();
        Object component = guiElement.getRuntimeComponent();
        if (component == null) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTION_PROBLEM, "Could not identify " + guiElement.getName() + ". Tried by identification procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Could not identify " + guiElement.getName() + ". Tried by identification procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
            return selections;
        }
        ((JavaGuiElement)guiElement).logIdentification(LogLevel.DEBUG, this.testCase);
        Object[] selectedObjects = (Object[])MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component, MethodDeclarations.getAllSelectedObjectsInComboBox);
        if (selectedObjects == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not identify any selections in " + guiElement.getName() + ".");
            return selections;
        }
        if (selectedObjects.length == 0) {
            this.log(LogLevel.DEBUG, "Nothing seem to be selected in " + guiElement.getName() + ".");
        }
        for (Object o : selectedObjects) {
            selections.add(o.toString());
        }
        if (selections.size() > 0) {
            this.log(LogLevel.DEBUG, "DropDown " + guiElement.getName() + " contained selected element(s) '" + String.join((CharSequence)"', '", selections) + "'.");
        }
        return selections;
    }

    public void verifyElementTextIsExactly(GuiComponent guiElement, String expectedText) {
        String text = this.getText(guiElement);
        if (text == null) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Cannot find any text in element " + guiElement.getName() + ".");
        } else if (text.equals(expectedText)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Found text '" + text + "' in element " + guiElement.getName() + ".");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Expected to find the text '" + expectedText + "' in element " + guiElement.getName() + " but the actual value was '" + text + "'.");
            this.takeScreenshot();
        }
    }

    public void verifyElementTextContains(GuiComponent guiElement, String expectedText) {
        String text = this.getText(guiElement);
        if (text == null) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Cannot find any text in element " + guiElement.getName() + ".");
        } else if (text.contains(expectedText)) {
            this.log(LogLevel.VERIFICATION_PASSED, "The text '" + expectedText + "' was found in element " + guiElement.getName() + ". Full text was: '" + text + "'.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Expected to find the text '" + expectedText + "' in element " + guiElement.getName() + " but the actual value was '" + text + "'.");
            this.takeScreenshot();
        }
    }

    public void verifyElementTextIsRegexMatch(GuiComponent guiElement, String pattern) {
        String text = this.getText(guiElement);
        if (text == null) {
            this.log(LogLevel.VERIFICATION_PROBLEM, "Cannot find any text in element " + guiElement.getName() + ".");
        } else if (SupportMethods.isRegexMatch((String)text, (String)pattern)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Found text matching the pattern '" + pattern + "' in element " + guiElement.getName() + ". Full text was: '" + text + "'.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Expected to find text matching the regular expression pattern '" + pattern + "' in element " + guiElement.getName() + " but the actual value was '" + text + "'.");
            this.takeScreenshot();
        }
    }

    public String getText(GuiComponent guiElement) {
        return this.getText(guiElement, this.standardTimeout * 1000);
    }

    public String getText(GuiComponent guiElement, int timeoutInMilliseconds) {
        List<String> selections;
        long startTime = System.currentTimeMillis();
        if (guiElement == null) {
            this.testCase.log(LogLevel.DEBUG, "Attempting to retrieve current text from null element.");
            return null;
        }
        JavaGuiElement javaGuiElement = (JavaGuiElement)guiElement;
        javaGuiElement.clearCache();
        Component component = javaGuiElement.getRuntimeComponent();
        while (component == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            component = javaGuiElement.getRuntimeComponent();
        }
        if (component == null) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.INFO, "Could not identify " + guiElement.getName() + ". Tried by identification procedure:" + javaGuiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Could not identify " + guiElement.getName() + ". Tried by identification procedure:" + javaGuiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
            return null;
        }
        javaGuiElement.logIdentification(LogLevel.DEBUG, this.testCase);
        String text = this.getText(component);
        if (text == null && (selections = this.getSelected(guiElement)).size() > 0) {
            text = "'" + String.join((CharSequence)"', '", selections) + "'";
        }
        if (text == null) {
            this.log(LogLevel.DEBUG, "Tried retrieving text from element " + guiElement.getName() + " but got null.");
        } else {
            this.log(LogLevel.DEBUG, "Retrieved the text '" + text + "' from element " + guiElement.getName() + ".");
        }
        return text;
    }

    public boolean exists(GuiComponent guiElement) {
        if (guiElement.getRuntimeComponent() != null) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Checked if element " + guiElement.getName() + " could be identified and it was, by the procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Checked if element " + guiElement.getName() + " could be identified and it was, by the procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
            return true;
        }
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Checked if element " + guiElement.getName() + " could be identified and it was not. Identification attempts by the procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Checked if element " + guiElement.getName() + " could be identified and it was not. Identification attempts by the procedure:" + guiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
        return false;
    }

    public boolean existsWithTimeout(GuiComponent guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        if (guiElement == null) {
            this.log(LogLevel.DEBUG, "Could not check existance of null element.");
            return false;
        }
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            if (guiElement.getRuntimeComponent() != null) {
                ((JavaGuiElement)guiElement).logIdentification(LogLevel.DEBUG, this.testCase);
                return true;
            }
            this.wait(50);
        }
        this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.DEBUG, "Checked if element " + guiElement.getName() + " could be identified within a " + timeoutInSeconds + " second timeout, and it did not. Identification attempts procedure: " + guiElement.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Checked if element " + guiElement.getName() + " could be identified within a " + timeoutInSeconds + " second timeout, and it did not. Identification attempts procedure: " + guiElement.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
        return false;
    }

    public boolean doesNotExist(GuiComponent guiElement) {
        boolean found = this.exists(guiElement);
        if (found) {
            this.log(LogLevel.DEBUG, "Checked if element " + guiElement.getName() + " did not exist, but it does indeed exist.");
        } else {
            this.log(LogLevel.DEBUG, "Checked if element " + guiElement.getName() + " did not exist, and it did not.");
        }
        return !found;
    }

    public boolean doesNotExistWithTimeout(GuiComponent guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            if (!this.exists(guiElement)) {
                return true;
            }
            this.wait(50);
        }
        return false;
    }

    public boolean isDisplayedWithinTimeout(GuiComponent guiElement, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        if (!this.existsWithTimeout(guiElement, timeoutInSeconds)) {
            this.log(LogLevel.DEBUG, "Checked if element " + guiElement.getName() + " is displayed, but it does not exist.");
            return false;
        }
        Boolean shown = (Boolean)this.methodInvoker.invokeTheFirstEncounteredMethod(guiElement.getRuntimeComponent(), MethodDeclarations.componentIsVisibleMethodsInAttemptOrder);
        if (shown == null) {
            this.log(LogLevel.DEBUG, "Check if element " + guiElement.getName() + " is displayed, and applicable method does not exist.");
            return false;
        }
        if (shown.booleanValue()) {
            this.log(LogLevel.DEBUG, "Check if element " + guiElement.getName() + " is displayed, and it is.");
            return true;
        }
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            shown = (Boolean)this.methodInvoker.invokeTheFirstEncounteredMethod(guiElement.getRuntimeComponent(), MethodDeclarations.componentIsVisibleMethodsInAttemptOrder);
            if (shown.booleanValue()) {
                this.log(LogLevel.DEBUG, "Check if element " + guiElement.getName() + " is displayed, and it is.");
                return true;
            }
            this.wait(50);
        }
        this.log(LogLevel.DEBUG, "Check if element " + guiElement.getName() + " is displayed, and it is not displayed.");
        return false;
    }

    public boolean isDisplayed(GuiComponent guiElement) {
        Boolean displayed = (Boolean)this.methodInvoker.invokeTheFirstEncounteredMethod(guiElement.getRuntimeComponent(), MethodDeclarations.componentIsVisibleMethodsInAttemptOrder);
        if (displayed == null) {
            this.log(LogLevel.FRAMEWORK_ERROR, "No applicable method seemed to be found for checking if " + guiElement.getName() + " was displayed.");
            return false;
        }
        if (displayed.booleanValue()) {
            this.log(LogLevel.DEBUG, "Checked if " + guiElement.getName() + " was displayed and it was.");
            return true;
        }
        this.log(LogLevel.DEBUG, "Checked if " + guiElement.getName() + " was displayed and it was not.");
        return false;
    }

    public boolean isNotDisplayed(GuiComponent guiElement) {
        return !this.isDisplayed(guiElement);
    }

    public boolean isNotDisplayedWithTimeout(GuiComponent guiComponent, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            if (this.isNotDisplayed(guiComponent)) {
                return true;
            }
            this.wait(50);
        }
        return false;
    }

    public void verifyObjectIsDisplayed(GuiComponent guiElement) {
        if (this.isDisplayedWithinTimeout(guiElement, this.standardTimeout)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Verified that element " + guiElement.getName() + " is displayed.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Tried to verify that element " + guiElement.getName() + " was displayed, but it does not seem to be displayed.");
            this.takeScreenshot();
        }
    }

    public void verifyObjectIsNotDisplayed(GuiComponent guiElement) {
        if (!this.isDisplayedWithinTimeout(guiElement, this.standardTimeout)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Verified that element " + guiElement.getName() + " is not displayed.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Tried to verify that element " + guiElement.getName() + " was not displayed, but it seem to be displayed.");
            this.takeScreenshot();
        }
    }

    public void verifyObjectExistence(GuiComponent guiElement) {
        if (this.existsWithTimeout(guiElement, this.standardTimeout)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Existance of " + guiElement.getName() + " verified.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Verification of existance of " + guiElement.getName() + " failed. Could not find element.");
            this.takeScreenshot();
        }
    }

    public void verifyObjectExistenceWithTimeout(GuiComponent guiElement, int timeoutInSeconds) {
        if (this.existsWithTimeout(guiElement, timeoutInSeconds)) {
            this.log(LogLevel.VERIFICATION_PASSED, "Existance of " + guiElement.getName() + " verified.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Verification of existance of " + guiElement.getName() + " failed. Could not find element.");
            this.takeScreenshot();
        }
    }

    public void setCheckboxToChecked(GuiComponent component) {
        this.setCheckboxToState(component, true, this.standardTimeout);
    }

    public void setCheckboxToUnChecked(GuiComponent component) {
        this.setCheckboxToState(component, false, this.standardTimeout);
    }

    public void setCheckboxToState(GuiComponent component, boolean expectedEndState) {
        this.setCheckboxToState(component, expectedEndState, this.standardTimeout);
    }

    public void setCheckboxToState(GuiComponent component, boolean expectedEndState, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        JavaGuiElement javaGuiElement = null;
        try {
            javaGuiElement = (JavaGuiElement)component;
        }
        catch (Exception e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not identify " + component.getName() + " as any object with implementation to interact with. The class is " + component.getClass().toString() + ".");
            this.takeScreenshot();
            return;
        }
        if (!this.existsWithTimeout(javaGuiElement, timeoutInSeconds)) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not make sure checkbox " + component.getName() + " was checked since it could not be identified within the timeout of " + timeoutInSeconds + " seconds.");
            this.takeScreenshot();
            return;
        }
        Boolean selected = !expectedEndState;
        while (selected != expectedEndState && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            selected = (Boolean)MethodInvoker.invokeTheFirstEncounteredMethod(null, component.getRuntimeComponent(), MethodDeclarations.getCheckboxCurrentStatus);
            if (selected == null) {
                selected = !expectedEndState;
            } else if (selected != expectedEndState) {
                MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, component.getRuntimeComponent(), MethodDeclarations.setCheckboxCurrentStatus, expectedEndState);
                selected = (Boolean)MethodInvoker.invokeTheFirstEncounteredMethod(null, component.getRuntimeComponent(), MethodDeclarations.getCheckboxCurrentStatus);
                if (selected == expectedEndState) {
                    this.log(LogLevel.EXECUTED, "Made sure checkbox " + javaGuiElement.getName() + " was " + String.valueOf(expectedEndState).toLowerCase().replace("false", "un-").replace("true", "") + "checked.");
                    return;
                }
                this.log(LogLevel.EXECUTION_PROBLEM, "Could not set checkbox " + javaGuiElement.getName() + " to " + String.valueOf(expectedEndState).replace("true", "checked.").replace("false", "un-checked."));
                this.takeScreenshot();
                return;
            }
            this.wait(50);
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Could not make sure checkbox " + javaGuiElement.getName() + " was in state " + String.valueOf(expectedEndState).toLowerCase().replace("false", "un-").replace("true", "") + "checked.");
        if (!this.methodInvoker.objectHasAnyOfTheMethods(javaGuiElement.getRuntimeElementCacheable(), MethodDeclarations.getCheckboxCurrentStatus)) {
            this.log(LogLevel.INFO, "Element of class " + javaGuiElement.getRuntimeElementCacheable().getClass().toString() + " has the following methods implemented '" + String.join((CharSequence)"', '", this.methodInvoker.getAvalableMethods(javaGuiElement.getRuntimeElementCacheable())) + "'. Tried invoking the methods '" + String.join((CharSequence)"', '", MethodDeclarations.getCheckboxCurrentStatus) + "'.");
        }
        this.takeScreenshot();
    }

    public boolean checkboxIsChecked(GuiComponent component, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            Boolean isChecked = (Boolean)MethodInvoker.invokeTheFirstEncounteredMethod(null, component.getRuntimeComponent(), MethodDeclarations.getCheckboxCurrentStatus);
            if (isChecked != null) {
                this.log(LogLevel.DEBUG, "Checkbox " + component.getName() + " identified and was identified as " + String.valueOf(isChecked).toLowerCase().replace("true", "checked.").replace("false", "un-checked."));
                return isChecked;
            }
            this.wait(50);
        }
        if (this.methodInvoker.objectHasAnyOfTheMethods(component.getRuntimeComponent(), MethodDeclarations.getCheckboxCurrentStatus)) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Something went wrong trying to get checkbox status for " + component.getName() + ".");
        } else {
            this.log(LogLevel.EXECUTION_PROBLEM, "Checkbox " + component.getName() + " did not have any implementations of the methods '" + String.join((CharSequence)"', '", MethodDeclarations.getCheckboxCurrentStatus) + "'. Available methods are:" + System.lineSeparator() + this.methodInvoker.getAvalableMethods(component.getRuntimeComponent()));
        }
        return false;
    }

    public void verifyCheckboxStatus(GuiComponent component, boolean expectedStatus, int timeoutInSeconds) {
        if (this.checkboxIsChecked(component, timeoutInSeconds) == expectedStatus) {
            this.log(LogLevel.VERIFICATION_PASSED, "Checkbox " + component.getName() + " was " + String.valueOf(expectedStatus).toLowerCase().replace("true", "checked").replace("false", "un-checked") + " as expected.");
        } else {
            this.log(LogLevel.VERIFICATION_FAILED, "Checkbox " + component.getName() + " was not " + String.valueOf(expectedStatus).toLowerCase().replace("true", "checked").replace("false", "un-checked") + " as expected.");
            this.takeScreenshot();
        }
    }

    public void verifyCheckboxStatus(GuiComponent component, boolean expectedStatus) {
        this.verifyCheckboxStatus(component, expectedStatus, this.standardTimeout);
    }

    public void verifyCheckboxIsChecked(GuiComponent component) {
        this.verifyCheckboxStatus(component, true);
    }

    public void verifyCheckboxIsUnChecked(GuiComponent component) {
        this.verifyCheckboxStatus(component, false);
    }

    public void verifyImage(GuiComponent guiElement, String s) {
        this.log(LogLevel.FRAMEWORK_ERROR, "The image verification method is not yet implemented. Sorry. Please contribute by implementing it.");
    }

    private Point getClickablePoint(GuiComponent guiElement) {
        Object component = guiElement.getRuntimeComponent();
        if (component == null) {
            this.log(LogLevel.DEBUG, "Could not get clickable point from " + guiElement.getName() + " since it could not be identified.");
            return null;
        }
        Point clickPoint = null;
        try {
            Point upperLeftCorner = (Point)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.componentLocationGetterMethodsInAttemptOrder);
            int width = (Integer)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.componentWidthGetterMethodsInAttemptOrder);
            int height = (Integer)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.componentHightGetterMethodsInAttemptOrder);
            clickPoint = new Point(upperLeftCorner.x + width / 2, upperLeftCorner.y + height / 2);
            this.log(LogLevel.DEBUG, "Found clickable point for component " + guiElement.getName() + ": " + clickPoint.x + "x" + clickPoint.y + ".");
        }
        catch (Exception e) {
            this.log(LogLevel.DEBUG, "Could not retrieve clickable point from component " + guiElement.getName() + " of class '" + component.getClass().toString() + "'");
        }
        return clickPoint;
    }

    private void log(LogLevel logLevel, String message) {
        System.out.println(new LogPost(logLevel, message, "", "", "", "").toString());
        if (this.testCase != null) {
            this.testCase.log(logLevel, message);
        }
    }

    public void type(String text) {
        this.type(null, text);
    }

    public void tabToNext() {
        try {
            Robot robot = new Robot();
            robot.keyPress(9);
            robot.keyRelease(9);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private void setFocus(GuiComponent guiComponent) {
        Component c = null;
        if (guiComponent == null) {
            return;
        }
        Component o = ((JavaGuiElement)guiComponent).getRuntimeComponent();
        if (o == null) {
            return;
        }
        c = o;
        if (c.isFocusable()) {
            this.testCase.log(LogLevel.DEBUG, "Requesting focus to element '" + guiComponent.getName() + "'.");
            c.requestFocus();
        } else {
            this.click(guiComponent);
        }
    }

    public void type(int javaAwtEventKeyEvent) {
        this.type(null, javaAwtEventKeyEvent);
    }

    public void type(GuiComponent guiComponent, int javaAwtEventKeyEvent) {
        if (guiComponent != null) {
            this.bringWindowOfElementToFront(guiComponent);
            this.setFocus(guiComponent);
        }
        try {
            Robot robot = new Robot();
            robot.keyPress(javaAwtEventKeyEvent);
            robot.keyRelease(javaAwtEventKeyEvent);
            if (guiComponent != null) {
                this.testCase.log(LogLevel.EXECUTED, "Pressed the " + KeyEvent.getKeyText(javaAwtEventKeyEvent) + " key on element " + guiComponent.getName() + ".");
            } else {
                this.testCase.log(LogLevel.EXECUTED, "Pressed the " + KeyEvent.getKeyText(javaAwtEventKeyEvent) + " key.");
            }
        }
        catch (AWTException e) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not press key " + KeyEvent.getKeyText(javaAwtEventKeyEvent) + ". Error: " + e.toString());
        }
    }

    public void type(GuiComponent guiComponent, String text) {
        if (guiComponent != null) {
            this.bringWindowOfElementToFront(guiComponent);
        }
        this.setFocus(guiComponent);
        if (guiComponent == null) {
            this.testCase.log(LogLevel.DEBUG, "null component for typing text '" + text + "'. Typing anyway.");
        } else {
            Component o = ((JavaGuiElement)guiComponent).getRuntimeComponent();
            if (o == null) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Cannot identify element '" + guiComponent.getName() + "' to type the text '" + text + "' to.");
                this.takeScreenshot();
                return;
            }
            Component c = o;
            if (c.isFocusable()) {
                this.testCase.log(LogLevel.DEBUG, "Requesting focus to element '" + guiComponent.getName() + "'.");
                c.requestFocus();
            } else {
                this.testCase.log(LogLevel.DEBUG, "Requesting focus to element '" + guiComponent.getName() + "', but first setting it as focusable.");
                this.testCase.log(LogLevel.INFO, "Will click the element '" + guiComponent.getName() + "' to request focus for typing text '" + text + "', since it is not focusable.");
                this.click(guiComponent);
            }
        }
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        if (robot == null) {
            this.testCase.log(LogLevel.FRAMEWORK_ERROR, "Cannot start Robot for key presses.");
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            char letter = text.charAt(i);
            if (Character.isUpperCase(letter)) {
                robot.keyPress(16);
            }
            robot.keyPress(Character.toUpperCase(letter));
            robot.keyRelease(Character.toUpperCase(letter));
            if (!Character.isUpperCase(letter)) continue;
            robot.keyRelease(16);
        }
        robot.delay(100);
        String actualText = this.getText(guiComponent);
        if (actualText != null && actualText.equals(text)) {
            this.log(LogLevel.EXECUTED, "Typed '" + text + "' to component " + guiComponent.getName() + ".");
            return;
        }
        if (actualText != null && this.allCharactersExistAndInCorrectOrder(actualText, text)) {
            this.log(LogLevel.EXECUTED, "Typed '" + text + "' to component " + guiComponent.getName() + ". Text after write is '" + actualText + "'.");
            return;
        }
        if (actualText != null && guiComponent != null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Tried typing the text '" + text + "' to " + guiComponent.getName() + "' but the resulting text is '" + actualText + ". If this still is correct you could use the write method not performing checks afterwards.");
        } else {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not retrieve the text from element after type.");
        }
    }

    private void performWrite(GuiComponent guiElement, String textToWrite, boolean performCheckAfterwards) {
        if (guiElement == null) {
            this.log(LogLevel.INFO, "Attempting to write text '" + textToWrite + "' to null element.");
            return;
        }
        Object component = guiElement.getRuntimeComponent();
        if (component == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not write '" + textToWrite + "' to component " + guiElement.getName() + " since it could not be identified.");
            ((JavaGuiElement)guiElement).logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            return;
        }
        if (performCheckAfterwards) {
            for (String methodName : MethodDeclarations.componentWriteMethodsInAttemptOrder) {
                this.methodInvoker.invokeMethod(component, methodName, textToWrite);
                String actualText = this.getText(guiElement);
                if (actualText.equals(textToWrite)) {
                    this.log(LogLevel.EXECUTED, "Wrote '" + textToWrite + "' to component " + guiElement.getName() + ".");
                    return;
                }
                if (this.allCharactersExistAndInCorrectOrder(actualText, textToWrite)) {
                    this.log(LogLevel.EXECUTED, "Wrote '" + textToWrite + "' to component " + guiElement.getName() + ". Text after write is '" + actualText + "'.");
                    return;
                }
                this.log(LogLevel.DEBUG, "Tried writing the text '" + textToWrite + "' to " + guiElement.getName() + " with the method '" + methodName + "' but the resulting text is '" + actualText + ". If this still is correct you could use the write method not performing checks afterwards.");
            }
        } else {
            this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.componentWriteMethodsInAttemptOrder, textToWrite);
            this.log(LogLevel.EXECUTED, "Wrote '" + textToWrite + "' to component " + guiElement.getName() + ", without making sure text was correct.");
            return;
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "Could not write '" + textToWrite + "' to " + guiElement.getName() + ". Text in element after operation is '" + this.getText(guiElement) + "'.");
    }

    private boolean allCharactersExistAndInCorrectOrder(String actualText, String expectedText) {
        StringBuilder matchingString = new StringBuilder(".*");
        for (int i = 0; i < expectedText.length(); ++i) {
            matchingString.append(expectedText.substring(i, i + 1)).append(".*");
        }
        return SupportMethods.isRegexMatch((String)actualText, (String)matchingString.toString());
    }

    private List<Object> addSubComponents(Object component) {
        ArrayList<Object> componentList = new ArrayList<Object>();
        if (!this.methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subComponentCountMethodsInAttemptOrder) || !this.methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder)) {
            return componentList;
        }
        int numberOfSubItems = (Integer)this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.subComponentCountMethodsInAttemptOrder);
        for (int i = 0; i < numberOfSubItems; ++i) {
            Object o = this.methodInvoker.invokeTheFirstEncounteredMethod(component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder, i);
            componentList.add(o);
            componentList.addAll(this.addSubComponents(o));
        }
        return componentList;
    }

    public void verifyWindowIsDisplayed(JavaWindow javaWindow) {
        this.verifyWindowIsDisplayed(javaWindow, this.standardTimeout);
    }

    public void verifyWindowIsDisplayed(JavaWindow javaWindow, int timeoutInSeconds) {
        if (javaWindow == null) {
            this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Cannot verify existence of null window.");
            this.takeScreenshot();
            return;
        }
        long startTime = System.currentTimeMillis();
        boolean isShown = javaWindow.isShown();
        while (!isShown && System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isShown = javaWindow.isShown();
        }
        if (!isShown) {
            ArrayList<String> existingWindowTitles = new ArrayList<String>();
            for (Window w : ApplicationUnderTest.getWindows()) {
                existingWindowTitles.add(new JavaWindow(w).getTitle());
            }
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Could not identify window '" + javaWindow.getName() + "' within the timeout." + System.lineSeparator() + "Titles of existing windows::" + System.lineSeparator() + "'" + String.join((CharSequence)("'" + System.lineSeparator() + "'" + existingWindowTitles), new CharSequence[0]) + "'");
            this.takeScreenshot();
        } else {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Verified the existance of window '" + javaWindow.getName() + ".");
        }
    }

    public void verifyElementDoesNotExist(GuiComponent guiComponent) {
        JavaGuiElement javaGuiElement = (JavaGuiElement)guiComponent;
        if (javaGuiElement.getRuntimeComponent() == null) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Component '" + guiComponent.getName() + "' does not exist, as expected.");
        } else {
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Component '" + guiComponent.getName() + "' existed in spite it should not.");
            this.bringWindowOfElementToFront(guiComponent);
            this.takeScreenshot();
        }
    }

    public void verifyText(String actualText, String expectedTest) {
        if (actualText == null && expectedTest == null || actualText.equals(expectedTest)) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Text verification passed for text '" + expectedTest + "'.");
        } else {
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Expected the text to be '" + expectedTest + "' but it was '" + actualText + "'.");
        }
    }

    public void verifyWindowIsNotDisplayed(JavaWindow window) {
        this.verifyWindowIsNotDisplayed(window, this.standardTimeout);
    }

    public void verifyWindowIsNotDisplayed(JavaWindow window, int timeoutInSecondsForWindowToDisappear) {
        long startTime = System.currentTimeMillis();
        boolean windowIsShown = window.isShown();
        while (windowIsShown && System.currentTimeMillis() - startTime < (long)(timeoutInSecondsForWindowToDisappear * 1000)) {
            this.wait(50);
            windowIsShown = window.isShown();
        }
        if (windowIsShown) {
            this.log(LogLevel.VERIFICATION_FAILED, "Expected window '" + window.getName() + "' to be non-displayed, but it never became non existing within the timeout of " + timeoutInSecondsForWindowToDisappear + " seconds.");
            this.takeScreenshot();
        } else {
            this.log(LogLevel.VERIFICATION_PASSED, "Window '" + window.getName() + "' found to be non-displayed as expected.");
        }
    }

    public void closeAllWindows() {
        ArrayList<String> windowNames = new ArrayList<String>();
        for (Window w : Window.getWindows()) {
            windowNames.addAll(this.closeSubWindows(w));
            w.dispose();
        }
        if (windowNames.size() > 0) {
            this.testCase.logDifferentlyToTextLogAndHtmlLog(LogLevel.EXECUTED, "Closing window(s) '" + String.join((CharSequence)"', '", windowNames) + "'.", "Closing window(s):<br>" + String.join((CharSequence)"<br>", windowNames));
        } else {
            this.testCase.log(LogLevel.INFO, "Attempted to close all Java windows, but none found.");
        }
    }

    private List<String> closeSubWindows(Window window) {
        ArrayList<String> windowNames = new ArrayList<String>();
        for (Window subWindow : window.getOwnedWindows()) {
            windowNames.addAll(this.closeSubWindows(subWindow));
        }
        windowNames.add(new JavaWindow(window).getName());
        window.dispose();
        return windowNames;
    }

    public void setSelected(GuiComponent guiComponent, String ... strings) {
        long startTime = System.currentTimeMillis();
        JavaGuiElement javaGuiElement = (JavaGuiElement)guiComponent;
        Component component = javaGuiElement.getRuntimeComponent();
        while (component == null && System.currentTimeMillis() < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            component = javaGuiElement.getRuntimeComponent();
        }
        if (component == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not identify the element '" + javaGuiElement.getName() + "' to select '" + String.join((CharSequence)"', '", strings) + "' in.");
            javaGuiElement.logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            this.haltFurtherExecution();
        } else {
            javaGuiElement.logIdentification(LogLevel.DEBUG, this.testCase);
        }
        while (!component.isEnabled() && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
        }
        if (!component.isEnabled()) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Component '" + javaGuiElement.getName() + "' never got enabled within the timeout.");
        }
        if (JSpinner.class.isAssignableFrom(component.getClass())) {
            JSpinner spinner = (JSpinner)component;
            for (String value : strings) {
                this.testCase.log(LogLevel.DEBUG, "Set value '" + value + "' to element '" + javaGuiElement.getName() + "'.");
                spinner.setValue(value);
            }
            this.testCase.log(LogLevel.EXECUTED, "Set value(s) '" + String.join((CharSequence)"', '", strings) + "' to element '" + javaGuiElement.getName() + "'.");
        } else {
            this.testCase.log(LogLevel.FRAMEWORK_ERROR, "No setSelcted() mechanism implemented for elements of class '" + component.getClass() + "'." + System.lineSeparator() + "Element: " + component.toString());
        }
    }

    public void haltFurtherExecution() {
        this.testCase.report();
    }

    public void verifyCheckboxSelectionStatus(JavaGuiElement guiElement, boolean expectedToBeSelected) {
        long startTime = System.currentTimeMillis();
        if (guiElement == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Cannot verify if null element is selected.");
            this.takeScreenshot();
            return;
        }
        JavaGuiElement javaGuiElement = guiElement;
        javaGuiElement.clearCache();
        Component component = javaGuiElement.getRuntimeComponent();
        while (component == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            component = javaGuiElement.getRuntimeComponent();
        }
        if (component == null) {
            javaGuiElement.logIdentification(LogLevel.VERIFICATION_PROBLEM, this.testCase);
            this.takeScreenshot();
            return;
        }
        javaGuiElement.logIdentification(LogLevel.DEBUG, this.testCase);
        if (Checkbox.class.isAssignableFrom(component.getClass())) {
            Checkbox checkbox = (Checkbox)component;
            if (checkbox.getState() == expectedToBeSelected) {
                this.testCase.log(LogLevel.VERIFICATION_PASSED, "Checkbox '" + javaGuiElement.getName() + "' passed status check.");
            } else {
                this.testCase.log(LogLevel.VERIFICATION_FAILED, "Checkbox '" + javaGuiElement.getName() + "' failed status check.");
                this.takeScreenshot();
            }
        } else {
            this.testCase.log(LogLevel.FRAMEWORK_ERROR, "Method verifyCheckboxSelectionStatus() not yet implemented for class '" + component.getClass().getName() + "'.");
        }
    }

    public void closeWindow(JavaWindow window) {
        if (window == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Was instructed to close null window. Cannot do that.");
            this.takeScreenshot();
            return;
        }
        Object object = window.getWindow();
        if (object == null) {
            this.testCase.log(LogLevel.INFO, "Attempted to close window '" + window.getName() + "', but it could not be found.");
            return;
        }
        Window w = (Window)object;
        w.dispatchEvent(new WindowEvent(w, 201));
        if (w != null) {
            w.setVisible(false);
            w.dispose();
        }
    }

    public void activateTab(JavaWindow window, String tabText) {
        ArrayList<String> identifiedTabNames = new ArrayList<String>();
        for (Component component : window.getComponents()) {
            if (!JTabbedPane.class.isAssignableFrom(component.getClass())) continue;
            JTabbedPane panel = (JTabbedPane)component;
            for (int i = 0; i < panel.getTabCount(); ++i) {
                identifiedTabNames.add(panel.getTitleAt(i));
                if (!panel.getTitleAt(i).contains(tabText)) continue;
                panel.setSelectedIndex(i);
                this.testCase.log(LogLevel.EXECUTED, "Activated tab '" + panel.getTitleAt(i) + "' in window '" + window.getName() + "'.");
                return;
            }
        }
        this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not activate tab with tab text '" + tabText + "' in window '" + window.getName() + "'. Identified tabs: '" + String.join((CharSequence)"', '", identifiedTabNames) + "'.");
        this.takeScreenshot();
        this.haltFurtherExecution();
    }

    public void trackMousePosition(int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        Point lastPosition = MouseInfo.getPointerInfo().getLocation();
        while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000)) {
            Point newPoint = MouseInfo.getPointerInfo().getLocation();
            if (newPoint.x != lastPosition.x || newPoint.y != lastPosition.y) {
                System.out.println("Current mouse position: " + MouseInfo.getPointerInfo().getLocation().x + "x" + MouseInfo.getPointerInfo().getLocation().y);
                lastPosition = newPoint;
            }
            this.wait(50);
        }
    }

    public void hover(GuiComponent guiElement) {
        long startTime = System.currentTimeMillis();
        Object c = guiElement.getRuntimeComponent();
        while (c == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            c = guiElement.getRuntimeComponent();
        }
        if (c == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not move mouse to element " + guiElement.getName() + " since it could not be identified.");
            ((JavaGuiElement)guiElement).logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            if (this.testCase != null) {
                this.testCase.report();
            }
            return;
        }
        ((JavaGuiElement)guiElement).logIdentification(LogLevel.DEBUG, this.testCase);
        this.bringWindowOfElementToFront(guiElement);
        Point clickPoint = this.getClickablePoint(guiElement);
        if (clickPoint == null) {
            return;
        }
        Robot r = null;
        try {
            r = new Robot();
            r.mouseMove(clickPoint.x, clickPoint.y);
            this.log(LogLevel.EXECUTED, "Moved mouse to the " + guiElement.getName() + " component at point " + clickPoint.x + "x" + clickPoint.y + ".");
            this.wait(50);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    private void verifyElementEnabledStatus(GuiComponent guiComponent, boolean expectedToBeEndabled) {
        long startTime = System.currentTimeMillis();
        if (guiComponent == null) {
            this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Cannot verify enabled status of null element");
            this.takeScreenshot();
            return;
        }
        JavaGuiElement javaGuiElement = (JavaGuiElement)guiComponent;
        Component c = javaGuiElement.getRuntimeComponent();
        while (c == null && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            c = javaGuiElement.getRuntimeComponent();
        }
        if (c == null) {
            this.testCase.log(LogLevel.VERIFICATION_PROBLEM, "Cannot verify enabled status of element '" + javaGuiElement.getName() + "'. It cannot be identified.");
            javaGuiElement.logIdentification(LogLevel.INFO, this.testCase);
            this.takeScreenshot();
            return;
        }
        javaGuiElement.logIdentification(LogLevel.DEBUG, this.testCase);
        boolean isEnabled = c.isEnabled();
        while (isEnabled != expectedToBeEndabled && System.currentTimeMillis() - startTime < (long)(this.standardTimeout * 1000)) {
            this.wait(50);
            isEnabled = c.isEnabled();
        }
        if (isEnabled == expectedToBeEndabled) {
            this.testCase.log(LogLevel.VERIFICATION_PASSED, "Element '" + javaGuiElement.getName() + "' was " + String.valueOf(expectedToBeEndabled).toLowerCase().replace("true", "").replace("false", "not ") + "enabled. As expected.");
        } else {
            this.testCase.log(LogLevel.VERIFICATION_FAILED, "Element '" + javaGuiElement.getName() + "' never became " + String.valueOf(expectedToBeEndabled).toLowerCase().replace("true", "enabled").replace("false", "disabled") + " within the timeout of " + this.standardTimeout + " seconds.");
        }
    }

    public void verifyElementIsEnabled(GuiComponent guiComponent) {
        this.verifyElementEnabledStatus(guiComponent, true);
    }

    public void verifyElementIsDisabled(GuiComponent guiComponent) {
        this.verifyElementEnabledStatus(guiComponent, false);
    }
}

