/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.objectstructure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.ElementsList;
import se.claremont.taf.core.guidriverpluginstructure.PositionBasedIdentification.PositionBasedGuiElement;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.javasupport.interaction.elementidentification.By;
import se.claremont.taf.javasupport.interaction.elementidentification.SearchCondition;
import se.claremont.taf.javasupport.interaction.elementidentification.SearchConditionType;
import se.claremont.taf.javasupport.objectstructure.GuiComponent;
import se.claremont.taf.javasupport.objectstructure.JavaWindow;

public class JavaGuiElement
implements GuiComponent,
PositionBasedGuiElement,
Serializable {
    @JsonProperty
    String name;
    @JsonProperty
    JavaWindow window = null;
    @JsonProperty
    public By by;
    @JsonIgnore
    private boolean cacheIsEssential = false;
    @JsonIgnore
    List<String> recognitionDescription = new ArrayList<String>();
    @JsonIgnore
    TestCase testCase;
    @JsonIgnore
    Component cachedElement = null;

    public JavaGuiElement(JavaWindow window, By by, String name, TestCase testCase) {
        this.window = window;
        this.name = name;
        this.by = by;
        this.testCase = testCase;
    }

    public JavaGuiElement(JavaWindow window, By by, String name) {
        this(window, by, name, null);
    }

    public JavaGuiElement(By by, String name) {
        this.by = by;
        this.name = name;
    }

    public JavaGuiElement(Object object) {
        this(object, null);
        this.cacheIsEssential = true;
    }

    public JavaGuiElement(PositionBasedGuiElement positionBasedGuiElement) {
        if (positionBasedGuiElement.runtimeElement() == null) {
            return;
        }
        this.cachedElement = (Component)positionBasedGuiElement.runtimeElement();
        this.cacheIsEssential = true;
        this.name = "NoNamed" + this.cachedElement.getClass().getSimpleName();
    }

    public JavaGuiElement(Object object, TestCase testCase) {
        this.testCase = testCase;
        if (object == null) {
            return;
        }
        this.cacheIsEssential = true;
        if (By.class.isAssignableFrom(object.getClass())) {
            this.by = (By)object;
            return;
        }
        if (PositionBasedGuiElement.class.isAssignableFrom(object.getClass())) {
            this.cachedElement = (Component)((PositionBasedGuiElement)object).runtimeElement();
            this.name = "NoNamed" + ((PositionBasedGuiElement)object).getTypeName() + "Element";
            return;
        }
        if (JavaGuiElement.class.isAssignableFrom(object.getClass())) {
            JavaGuiElement element = (JavaGuiElement)object;
            this.by = element.by;
            this.name = element.name;
            this.cachedElement = element.cachedElement;
            this.testCase = element.testCase;
            this.window = element.window;
            this.recognitionDescription = element.recognitionDescription;
        }
        String nameSuggestion = "";
        try {
            String text;
            this.by = By.byClass(object.getClass().getName());
            String elementName = (String)MethodInvoker.invokeTheFirstEncounteredMethod(testCase, object, MethodDeclarations.componentNameGetterMethodsInAttemptOrder);
            if (elementName != null && elementName.length() > 0) {
                nameSuggestion = elementName;
                this.by.andByName(elementName);
            }
            if ((text = (String)MethodInvoker.invokeTheFirstEncounteredMethod(null, object, MethodDeclarations.textGettingMethodsInAttemptOrder)) != null && text.length() > 0) {
                if (nameSuggestion == "") {
                    nameSuggestion = text;
                }
                this.by.andByExactText(text);
            }
            this.name = StringManagement.safeVariableName((String)StringManagement.stringToCapitalInitialCharacterForEachWordAndNoSpaces((String)(nameSuggestion + object.getClass().getSimpleName())));
            if (this.name.length() == 0) {
                this.name = "NoNameElement";
            }
            this.cachedElement = (Component)object;
        }
        catch (Exception e) {
            this.log(LogLevel.DEBUG, "Could not create JavaGuiElement from Object. Error: " + e.toString());
            this.log(LogLevel.DEBUG, "Possible methods of object are:" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), MethodInvoker.getAvailableMethods(object)));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Component getRuntimeComponent() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        long startTime = System.currentTimeMillis();
        this.recognitionDescription.clear();
        List<Component> windowComponents = this.getWindowComponents();
        List<Component> matchingComponents = new ArrayList<Component>();
        if (this.by != null) {
            List<? extends PositionBasedGuiElement> positionBasedElement = this.getElementFromRelativePositionReferenceIfApplicable();
            if (positionBasedElement != null) {
                windowComponents.add((Component)((Object)positionBasedElement));
            }
            windowComponents = this.filterByAncestorElementIfApplicable(windowComponents);
            this.recognitionDescription.add("Attempting to identify runtime object for " + this.getName() + " by By statement:" + System.lineSeparator() + this.by.toString());
            matchingComponents.addAll(this.attemptToIdentifyElementByByStatement(windowComponents));
            matchingComponents = this.filterObjectByOrdinalNumber(matchingComponents);
        }
        if (matchingComponents.size() == 0) {
            this.recognitionDescription.add("Could not identify any matching runtime object for " + this.getName() + ". Time for identification: " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            return null;
        }
        if (matchingComponents.size() == 1) {
            this.recognitionDescription.add("Identified exactly one matching runtime object for " + this.getName() + ". Returning this object. Time for identification: " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            this.cachedElement = (Component)matchingComponents.get(0);
            return (Component)matchingComponents.get(0);
        }
        this.recognitionDescription.add("Identified " + matchingComponents.size() + " matching runtime object for " + this.getName() + ".  Time for identification: " + (System.currentTimeMillis() - startTime) + " milliseconds. The objects were: ");
        for (Object e : matchingComponents) {
            this.recognitionDescription.add(e.toString());
        }
        this.recognitionDescription.add("Returning the first object.");
        this.cachedElement = matchingComponents.get(0);
        return matchingComponents.get(0);
    }

    private List<Component> filterObjectByOrdinalNumber(List<Component> objects) {
        ArrayList<Component> returnObjects = new ArrayList<Component>(objects);
        for (SearchCondition searchCondition : this.by.searchConditions) {
            if (searchCondition.searchConditionType != SearchConditionType.ORDINAL_NUMBER) continue;
            returnObjects.clear();
            Integer ordinalNumber = (int)((Integer)searchCondition.objects[0]);
            if (ordinalNumber == null) {
                this.recognitionDescription.add("Wrong format of ordinal number encountered. Was '" + searchCondition.objects[0] + "'.");
                break;
            }
            if (ordinalNumber > objects.size()) {
                this.recognitionDescription.add("Attempting to get element number " + ordinalNumber + " but there are only " + objects.size() + " element(s) to choose from. Returning last match.");
                returnObjects.add(objects.get((Integer)searchCondition.objects[objects.size()]));
                break;
            }
            if (ordinalNumber < 0) {
                this.recognitionDescription.add("Ordinal number should not be negative. Was " + ordinalNumber + ". Returning first match.");
                returnObjects.add(objects.get(0));
                break;
            }
            this.recognitionDescription.add("Out of the " + objects.size() + " elements that are left, the " + ordinalNumber + " is chosen. Removing the other ones.");
            returnObjects.add(objects.get(ordinalNumber));
            break;
        }
        return returnObjects;
    }

    private List<Component> filterByAncestorElementIfApplicable(List<Component> objects) {
        List<Component> returnObjects = new ArrayList<Component>(objects);
        for (SearchCondition searchCondition : this.by.searchConditions) {
            if (searchCondition.searchConditionType != SearchConditionType.BEING_DESCENDANT_OF) continue;
            JavaGuiElement ancestor = (JavaGuiElement)searchCondition.objects[0];
            returnObjects = ancestor.getDescendants();
            if (returnObjects == null) {
                this.recognitionDescription.add("Could not get descendants from element '" + ancestor.name + "'.");
                returnObjects = new ArrayList();
                break;
            }
            this.recognitionDescription.add("Removed " + (objects.size() - returnObjects.size()) + " elements that waa not descendants of element '" + ancestor.name + "'.");
            break;
        }
        return returnObjects;
    }

    private List<Component> getDescendants() {
        Object element = this.getRuntimeElementCacheable();
        MethodInvoker methodInvoker = new MethodInvoker();
        ArrayList<Component> componentList = new ArrayList<Component>();
        if (!methodInvoker.objectHasAnyOfTheMethods(element, MethodDeclarations.subComponentCountMethodsInAttemptOrder) || !methodInvoker.objectHasAnyOfTheMethods(element, MethodDeclarations.subComponentGetterMethodsInAttemptOrder)) {
            return componentList;
        }
        Integer windowComponentCount = (Integer)methodInvoker.invokeTheFirstEncounteredMethod(element, MethodDeclarations.subComponentCountMethodsInAttemptOrder);
        if (windowComponentCount == null) {
            return componentList;
        }
        Component[] returnList = (Component[])methodInvoker.invokeTheFirstEncounteredMethod(element, MethodDeclarations.subAllComponentsGettersMethodsInAttemptOrder);
        if (returnList != null && returnList.length > 0) {
            for (Component object : returnList) {
                componentList.add(object);
                componentList.addAll(this.addSubComponents(methodInvoker, object));
            }
            return componentList;
        }
        for (int i = 0; i < windowComponentCount; ++i) {
            Component component = (Component)methodInvoker.invokeTheFirstEncounteredMethod(element, MethodDeclarations.subComponentGetterMethodsInAttemptOrder, i);
            if (component == null) continue;
            componentList.add(component);
            componentList.addAll(this.addSubComponents(methodInvoker, component));
        }
        return componentList;
    }

    private List<Component> addSubComponents(MethodInvoker methodInvoker, Component component) {
        ArrayList<Component> componentList = new ArrayList<Component>();
        if (!methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subComponentCountMethodsInAttemptOrder) || !methodInvoker.objectHasAnyOfTheMethods(component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder)) {
            return componentList;
        }
        int numberOfSubItems = (Integer)methodInvoker.invokeTheFirstEncounteredMethod((Object)component, MethodDeclarations.subComponentCountMethodsInAttemptOrder);
        for (int i = 0; i < numberOfSubItems; ++i) {
            Component o = (Component)methodInvoker.invokeTheFirstEncounteredMethod((Object)component, MethodDeclarations.subComponentGetterMethodsInAttemptOrder, i);
            componentList.add(o);
            componentList.addAll(this.addSubComponents(methodInvoker, o));
        }
        return componentList;
    }

    private List<? extends PositionBasedGuiElement> getElementFromRelativePositionReferenceIfApplicable() {
        for (SearchCondition sc : this.by.searchConditions) {
            if (sc.searchConditionType == null || sc.objects == null || sc.objects[0] == null || !sc.searchConditionType.equals((Object)SearchConditionType.POSITION_BASED)) continue;
            if (ElementsList.class.isAssignableFrom(sc.objects[0].getClass())) {
                ElementsList elementsList = (ElementsList)sc.objects[0];
                return elementsList.elements;
            }
            JavaGuiElement positionBasedGuiElement = (JavaGuiElement)sc.objects[0];
            ArrayList<JavaGuiElement> tempList = new ArrayList<JavaGuiElement>();
            tempList.add(positionBasedGuiElement);
            return tempList;
        }
        return null;
    }

    private Collection<Component> attemptToIdentifyElementByByStatement(List<Component> componentList) {
        ArrayList<Component> returnElements = new ArrayList<Component>(componentList);
        this.recognitionDescription.add("Identifying " + componentList.size() + " elements in window.");
        ArrayList<Component> removeElements = new ArrayList<Component>();
        GenericInteractionMethods jim = new GenericInteractionMethods(null);
        block7: for (SearchCondition searchCondition : this.by.searchConditions) {
            switch (searchCondition.searchConditionType) {
                case CLASS: {
                    for (Component o : componentList) {
                        if (o.getClass().getSimpleName().equals((String)searchCondition.objects[0])) continue;
                        removeElements.add(o);
                    }
                    this.recognitionDescription.add("Removing " + removeElements.size() + " elements not being of class '" + (String)searchCondition.objects[0] + "'.");
                    returnElements.removeAll(removeElements);
                    removeElements.clear();
                    continue block7;
                }
                case NAME: {
                    for (Component o : componentList) {
                        String name = jim.getName(o);
                        if (name != null && name.equals((String)searchCondition.objects[0])) continue;
                        removeElements.add(o);
                    }
                    this.recognitionDescription.add("Removing " + removeElements.size() + " elements not being named '" + (String)searchCondition.objects[0] + "'.");
                    returnElements.removeAll(removeElements);
                    removeElements.clear();
                    continue block7;
                }
                case EXACT_TEXT: {
                    String elementText;
                    for (Component o : componentList) {
                        boolean toBeRemoved = true;
                        for (Object acceptedText : searchCondition.objects) {
                            elementText = jim.getText(o);
                            if (elementText == null || !elementText.equals((String)acceptedText)) continue;
                            toBeRemoved = false;
                            break;
                        }
                        if (!toBeRemoved) continue;
                        removeElements.add(o);
                    }
                    this.recognitionDescription.add("Removing " + removeElements.size() + " elements not having any of the exact texts '" + searchCondition.toString() + "'.");
                    returnElements.removeAll(removeElements);
                    removeElements.clear();
                    continue block7;
                }
                case TEXT_CONTAINS: {
                    String elementText;
                    for (Component o : componentList) {
                        int toBeRemoved = 1;
                        for (Object acceptedText : searchCondition.objects) {
                            elementText = jim.getText(o);
                            if (elementText == null || !elementText.contains((String)acceptedText)) continue;
                            toBeRemoved = 0;
                            break;
                        }
                        if (toBeRemoved == 0) continue;
                        removeElements.add(o);
                    }
                    ArrayList<String> descriptions = new ArrayList<String>();
                    for (Object o : searchCondition.objects) {
                        descriptions.add(o.toString());
                    }
                    this.recognitionDescription.add("Removing " + removeElements.size() + " elements not containing any of the exact texts '" + String.join((CharSequence)"', '", descriptions) + "'.");
                    returnElements.removeAll(removeElements);
                    removeElements.clear();
                    continue block7;
                }
                case TEXT_REGEX_MATCH: {
                    for (Component o : componentList) {
                        String elementText = jim.getText(o);
                        if (elementText != null && elementText.matches((String)searchCondition.objects[0])) continue;
                        removeElements.add(o);
                    }
                    this.recognitionDescription.add("Removing " + removeElements.size() + " elements not matching pattern '" + (String[])searchCondition.objects[0] + "'.");
                    returnElements.removeAll(removeElements);
                    removeElements.clear();
                    continue block7;
                }
            }
            this.recognitionDescription.add("No By statement implementation for SearchCondition " + searchCondition.toString() + ". Ignoring this.");
        }
        return returnElements;
    }

    public Object getRuntimeElementCacheable() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        return this.getRuntimeComponent();
    }

    public void logIdentification(LogLevel logLevel, TestCase testCase) {
        testCase.logDifferentlyToTextLogAndHtmlLog(logLevel, "Identification procedure for " + this.name + ":" + this.getRecognitionDescription().replace(System.lineSeparator(), ", "), "Identification procedure for " + this.name + ":" + this.getRecognitionDescription().replace(System.lineSeparator(), "<br>"));
    }

    @Override
    public String getRecognitionDescription() {
        int counter = 1;
        String recognitionString = System.lineSeparator();
        for (String descLine : this.recognitionDescription) {
            recognitionString = recognitionString + counter + "). " + descLine + System.lineSeparator();
            ++counter;
        }
        return recognitionString;
    }

    public void clearCache() {
        if (this.cacheIsEssential) {
            return;
        }
        this.cachedElement = null;
    }

    public JavaWindow getJavaWindow() {
        if (this.window != null) {
            return this.window;
        }
        return new JavaWindow((Window)this.getWindow());
    }

    public Object getWindow() {
        Object thisElement = this.getRuntimeElementCacheable();
        if (this.window != null) {
            return this.window.getWindow();
        }
        ArrayList objects = new ArrayList();
        Window[] windows = Window.getOwnerlessWindows();
        ArrayList<Window> nonDisplayedWindows = new ArrayList<Window>();
        for (Window w : windows) {
            if (!w.isShowing()) {
                nonDisplayedWindows.add(w);
                continue;
            }
            JavaWindow javaWindow = new JavaWindow(w);
            List<Component> objectList = javaWindow.getComponents();
            for (Component o : objectList) {
                if (!o.equals(thisElement)) continue;
                return w;
            }
        }
        if (objects.size() == 0 && nonDisplayedWindows.size() > 0) {
            for (Window w : nonDisplayedWindows) {
                JavaWindow javaWindow = new JavaWindow((Window)nonDisplayedWindows.get(0));
                List<Component> objectList = javaWindow.getComponents();
                for (Component o : objectList) {
                    if (!o.equals(thisElement)) continue;
                    return w;
                }
            }
        }
        return null;
    }

    public ArrayList<JavaGuiElement> getSubElements() {
        ArrayList<JavaGuiElement> javaGuiElements = new ArrayList<JavaGuiElement>();
        GenericInteractionMethods genericInteractionMethods = new GenericInteractionMethods(null);
        Object component = this.getRuntimeElementCacheable();
        if (component == null) {
            this.log(LogLevel.DEBUG, "Could not identify runtime element for element " + this.getName() + ". Cannot retrieve subelements from this element.");
            return javaGuiElements;
        }
        ArrayList<Object> subElements = genericInteractionMethods.allSubElementsOf(component);
        for (Object e : subElements) {
            try {
                JavaGuiElement javaGuiElement = new JavaGuiElement(e);
                javaGuiElements.add(javaGuiElement);
                try {
                    javaGuiElements.addAll(javaGuiElement.getSubElements());
                }
                catch (Exception e2) {
                    this.log(LogLevel.DEBUG, "Could not retrieve subElements from " + javaGuiElement.getName() + ".");
                    return javaGuiElements;
                }
            }
            catch (Exception ignored) {
                this.log(LogLevel.DEBUG, "Could not cast element of type '" + e.getClass().toString() + "' to JavaGuiElement. Error: " + ignored.toString());
                return javaGuiElements;
            }
        }
        return javaGuiElements;
    }

    public JavaGuiElement getParent() {
        Object object = MethodInvoker.invokeTheFirstEncounteredMethod(null, this.getRuntimeComponent(), MethodDeclarations.componentParentGetterMethodsInAttemptOrder);
        if (object == null) {
            return null;
        }
        return new JavaGuiElement(object);
    }

    public List<JavaGuiElement> getAllElementsInSameContainer() {
        ArrayList<JavaGuiElement> elements = new ArrayList<JavaGuiElement>();
        ArrayList<JavaGuiElement> subElements = this.getSubElements();
        if (subElements.size() > 0) {
            return subElements;
        }
        JavaGuiElement parent = this.getParent();
        if (parent == null) {
            return elements;
        }
        return parent.getSubElements();
    }

    public Integer getLeftPosition() {
        Object element = this.getRuntimeElementCacheable();
        return (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, element, MethodDeclarations.methodsToGetLeftPositionInOrder);
    }

    public Integer getRightPosition() {
        Object element = this.getRuntimeElementCacheable();
        if (element == null) {
            return null;
        }
        Integer location = (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, element, MethodDeclarations.methodsToGetLeftPositionInOrder);
        Integer width = (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, element, MethodDeclarations.componentWidthGetterMethodsInAttemptOrder);
        return location + width;
    }

    public Integer getTopPosition() {
        Object element = this.getRuntimeElementCacheable();
        if (element == null) {
            return null;
        }
        return (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, element, MethodDeclarations.methodsToGetTopPositionInOrder);
    }

    public Integer getBottomPosition() {
        Object element = this.getRuntimeElementCacheable();
        if (element == null) {
            return null;
        }
        Integer location = (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, element, MethodDeclarations.methodsToGetTopPositionInOrder);
        Integer height = (Integer)MethodInvoker.invokeTheFirstEncounteredMethod(this.testCase, element, MethodDeclarations.componentHightGetterMethodsInAttemptOrder);
        return location + height;
    }

    public String getTypeName() {
        Object element = this.getRuntimeElementCacheable();
        if (element == null) {
            return null;
        }
        if (element != null) {
            return element.getClass().toString();
        }
        return null;
    }

    public Object runtimeElement() {
        return this.cachedElement;
    }

    public ArrayList<PositionBasedGuiElement> childElements() {
        ArrayList<PositionBasedGuiElement> list = new ArrayList<PositionBasedGuiElement>();
        for (JavaGuiElement javaGuiElement : this.getSubElements()) {
            list.add(javaGuiElement);
        }
        return list;
    }

    private List<Component> getWindowComponents() {
        List<Object> objects = new ArrayList();
        if (this.window != null && this.window.isShown()) {
            objects = this.window.getComponents();
            this.recognitionDescription.add("Identified " + objects.size() + " objects in the window.");
        } else {
            JavaWindow javaWindow;
            this.recognitionDescription.add("No window was given for object. Trying to identify java windows.");
            Set<Window> windows = ApplicationUnderTest.getWindows();
            ArrayList<Window> nonDisplayedWindows = new ArrayList<Window>();
            for (Window w : windows) {
                if (!w.isShowing()) {
                    javaWindow = new JavaWindow(w);
                    nonDisplayedWindows.add(w);
                    this.recognitionDescription.add("Identified running java window with title '" + javaWindow.getTitle() + "' but it was suppressed from displaying. No elements added.");
                    continue;
                }
                javaWindow = new JavaWindow(w);
                List<Component> objectList = javaWindow.getComponents();
                this.recognitionDescription.add("Identified java window with title '" + javaWindow.getTitle() + "' and " + objectList.size() + " objects.");
                objects.addAll(objectList);
            }
            if (objects.size() == 0 && nonDisplayedWindows.size() > 0) {
                this.recognitionDescription.add("Found zero objects in displaying windows. Assuming a window with suppressed display is meant to be used. Adding elements from all suppressed windows.");
                for (Window w : nonDisplayedWindows) {
                    javaWindow = new JavaWindow((Window)nonDisplayedWindows.get(0));
                    objects.addAll(javaWindow.getComponents());
                }
            }
            this.recognitionDescription.add("Identified " + objects.size() + " relevant java objects.");
        }
        return objects;
    }

    private ArrayList<Object> returnElementByText(List<Object> componentList) {
        ArrayList<Object> returnElementList = new ArrayList<Object>();
        returnElementList.addAll(this.getElementByExactMatchOfText(componentList));
        if (returnElementList.size() > 0) {
            return returnElementList;
        }
        returnElementList.addAll(this.getElementByContainsMatchOfText(componentList));
        if (returnElementList.size() > 0) {
            return returnElementList;
        }
        return this.getElementByRegexMatchOfText(componentList);
    }

    private ArrayList<Object> getElementByRegexMatchOfText(List<Object> componentList) {
        ArrayList<Object> returnElements = new ArrayList<Object>();
        GenericInteractionMethods jim = new GenericInteractionMethods(null);
        String regexPattern = null;
        for (SearchCondition sc : this.by.searchConditions) {
            if (!sc.searchConditionType.equals((Object)SearchConditionType.TEXT_REGEX_MATCH)) continue;
            regexPattern = sc.objects.toString();
        }
        if (regexPattern == null) {
            return returnElements;
        }
        for (Object c : componentList) {
            if (!SupportMethods.isRegexMatch((String)jim.getText(c), (String)regexPattern)) continue;
            this.recognitionDescription.add("Found regular expression match for text '" + jim.getText(c) + "' in element of class '" + c.getClass().toString() + "' with expected regular expression pattern '" + regexPattern + "'. Adding this object to possible matches list.");
            returnElements.add(c);
        }
        return returnElements;
    }

    private ArrayList<Object> getElementByExactMatchOfText(List<Object> componentList) {
        ArrayList<Object> returnElements = new ArrayList<Object>();
        String expectedText = null;
        for (SearchCondition sc : this.by.searchConditions) {
            if (!sc.searchConditionType.equals((Object)SearchConditionType.TEXT_REGEX_MATCH)) continue;
            expectedText = sc.objects.toString();
        }
        if (expectedText == null) {
            return returnElements;
        }
        GenericInteractionMethods jim = new GenericInteractionMethods(null);
        for (Object c : componentList) {
            if (jim.getText(c) == null || !jim.getText(c).equals(expectedText)) continue;
            this.recognitionDescription.add("Found exact text match in element of class '" + c.getClass().toString() + "'. Adding this object to possible matches list.");
            returnElements.add(c);
        }
        return returnElements;
    }

    private ArrayList<Object> getElementByContainsMatchOfText(List<Object> componentList) {
        ArrayList<Object> returnElements = new ArrayList<Object>();
        String expectedText = null;
        for (SearchCondition sc : this.by.searchConditions) {
            if (!sc.searchConditionType.equals((Object)SearchConditionType.TEXT_REGEX_MATCH)) continue;
            expectedText = sc.objects.toString();
        }
        if (expectedText == null) {
            return returnElements;
        }
        GenericInteractionMethods jim = new GenericInteractionMethods(null);
        for (Object c : componentList) {
            if (jim.getText(c) == null || !jim.getText(c).contains(expectedText)) continue;
            this.recognitionDescription.add("Found partial match for text '" + expectedText + "' in object with text '" + jim.getText(c) + "' of class '" + c.getClass().toString() + "'. Adding this object to possible matches list.");
            returnElements.add(c);
        }
        return returnElements;
    }

    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ": " + message);
            return;
        }
        this.testCase.log(logLevel, message);
    }

    public String toString() {
        String description = "[";
        description = this.name == null ? description + "name: null" : description + "name: '" + this.name + "'";
        description = this.by == null ? description + ", by: null" : description + ", by: " + this.by.toString();
        description = description + "', cached object stored: " + String.valueOf(this.cachedElement != null) + "]";
        return description;
    }
}

