/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationcontext.ApplicationContextManager;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.ApplicationStartMechanism;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.ApplicationThreadRunner;

public class ApplicationUnderTest
implements Serializable {
    @JsonProperty
    public String friendlyName;
    @JsonProperty
    public ApplicationContextManager context;
    @JsonProperty
    public ApplicationStartMechanism startMechanism;
    @JsonIgnore
    transient TestCase testCase;
    @JsonIgnore
    static transient ArrayList<Window> windowsStartedBeforeStartingSut = new ArrayList();

    private ApplicationUnderTest() {
        TestCase testCase = new TestCase();
        this.context = new ApplicationContextManager(testCase);
        this.startMechanism = new ApplicationStartMechanism(testCase);
        this.testCase = testCase;
    }

    public ApplicationUnderTest(TestCase testCase, ApplicationStartMechanism startMechanism) {
        this.context = new ApplicationContextManager(testCase);
        this.startMechanism = startMechanism;
        this.testCase = testCase;
    }

    public ApplicationUnderTest(ApplicationUnderTest aut) {
        this.testCase = aut.testCase;
        this.context = new ApplicationContextManager(this.testCase);
        this.startMechanism = new ApplicationStartMechanism(this.testCase);
        this.context.jvmSettings.appliedSetting = new ArrayList<String>(aut.context.jvmSettings.appliedSetting);
        this.context.loadedLibraries.appliedFiles = new ArrayList<String>(aut.context.loadedLibraries.appliedFiles);
        this.context.properties.appliedProperties = new ArrayList<String>(aut.context.properties.appliedProperties);
        this.context.environmentVariables.appliedVariableChanges = new ArrayList<String>(aut.context.environmentVariables.appliedVariableChanges);
        this.startMechanism.mainClass = aut.startMechanism.mainClass;
        this.startMechanism.startUrlOrPathToJarFile = aut.startMechanism.startUrlOrPathToJarFile;
        this.startMechanism.arguments = aut.startMechanism.arguments;
    }

    public ApplicationUnderTest(ApplicationStartMechanism startMechanism, ApplicationContextManager context) {
        this.context = context;
        this.startMechanism = startMechanism;
    }

    public void reAssignTestCase(TestCase testCase) {
        this.testCase = testCase;
    }

    public void setName(String name) {
        this.friendlyName = name;
    }

    @JsonIgnore
    public void setProgramArguments(String[] args) {
        for (String arg : args) {
            this.startMechanism.arguments.add(arg);
        }
    }

    @JsonIgnore
    public void addProgramArgument(String arg) {
        this.startMechanism.arguments.add(arg);
    }

    @JsonIgnore
    public void setMainClass(String mainClassName) {
        this.startMechanism.mainClass = mainClassName;
    }

    @JsonIgnore
    public void loadLibrary(String path) {
        this.context.loadedLibraries.loadLibrary(path);
    }

    @JsonIgnore
    public void loadAllLibrariesInFolder(String path) {
        this.context.loadedLibraries.loadAllDllsInFolder(path);
    }

    @JsonIgnore
    public void setEnvironmentVariableValue(String variableName, String variableValue) {
        this.context.environmentVariables.setEnvironmentVariable(variableName, variableValue);
    }

    @JsonIgnore
    public void setSystemPropertyValue(String name, String value) {
        this.context.properties.setProperty(name, value);
    }

    @JsonIgnore
    public void attemptToAddJVMSetting(String name, String value) {
        this.context.jvmSettings.setVMOption(name, value);
    }

    @JsonIgnore
    public void setMainJarOrUrl(String jarFilePathOrUrl) {
        this.startMechanism.startUrlOrPathToJarFile = jarFilePathOrUrl;
    }

    @JsonIgnore
    public void start() {
        windowsStartedBeforeStartingSut.addAll(ApplicationUnderTest.getWindows());
        Thread t = ApplicationThreadRunner.start(this.startMechanism);
    }

    @JsonIgnore
    public void stop() {
        ApplicationUnderTest.closeAllWindows();
    }

    @JsonIgnore
    public Object getWindow() {
        Set<Window> windows = ApplicationUnderTest.getWindows();
        this.log(LogLevel.DEBUG, "Found " + windows.size() + " windows in JVM.");
        if (windows.size() == 0) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not find any windows.");
            return null;
        }
        if (windows.size() == 1) {
            this.log(LogLevel.DEBUG, "Found one window.");
            return windows.toArray()[0];
        }
        if (windows.size() > 1) {
            this.log(LogLevel.INFO, "Found more than one window. Returning the first one. Consider using the enumerator method implementation for specific window.");
            return windows.toArray()[0];
        }
        return null;
    }

    @JsonIgnore
    public static Set<Window> getWindows() {
        HashSet<Window> windows = new HashSet<Window>();
        Collections.addAll(windows, Window.getWindows());
        Collections.addAll(windows, Window.getOwnerlessWindows());
        ArrayList<Window> subWindows = new ArrayList<Window>();
        for (Window window : windows) {
            for (Window subWindow : ApplicationUnderTest.getSubWindowsRevursive(window)) {
                subWindows.add(subWindow);
            }
        }
        for (Window subWindow : subWindows) {
            windows.add(subWindow);
        }
        for (Frame frame : Frame.getFrames()) {
            windows.add(frame);
            windows.addAll(ApplicationUnderTest.getSubWindowsRevursive(frame));
        }
        return windows;
    }

    private static ArrayList<Window> getSubWindowsRevursive(Window window) {
        ArrayList<Window> windows = new ArrayList<Window>();
        Collections.addAll(windows, window.getOwnedWindows());
        for (Window subWindow : windows) {
            Collections.addAll(ApplicationUnderTest.getSubWindowsRevursive(subWindow), new Window[0]);
        }
        return windows;
    }

    @JsonIgnore
    public static ArrayList<Window> getWindowsForSUT() {
        ArrayList<Window> windows = new ArrayList<Window>();
        Window[] swingWindows = Window.getOwnerlessWindows();
        Collections.addAll(windows, swingWindows);
        windows.removeAll(windowsStartedBeforeStartingSut);
        return windows;
    }

    @JsonIgnore
    public static void closeAllWindows() {
        for (Window window : ApplicationUnderTest.getWindows()) {
            ApplicationUnderTest.closeSubWindows(window);
        }
    }

    @JsonIgnore
    private static void closeSubWindows(Window window) {
        Window[] subWindows;
        for (Window w : subWindows = window.getOwnedWindows()) {
            ApplicationUnderTest.closeSubWindows(w);
        }
        window.dispose();
    }

    @JsonIgnore
    public Object getWindow(int windowCount) {
        Set<Window> windows = ApplicationUnderTest.getWindows();
        this.log(LogLevel.DEBUG, "Found " + windows.size() + " windows in JVM.");
        if (windows.size() < windowCount) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Only found " + windows.size() + " open windows, and request was for window " + windowCount + ".");
            return null;
        }
        if (windows.size() == 1) {
            this.log(LogLevel.DEBUG, "Found one window returning this although window count " + windowCount + " was requested.");
            return windows.toArray()[0];
        }
        return windows.toArray()[windowCount];
    }

    @JsonIgnore
    public void logCurrentWindows() {
        ApplicationUnderTest.logCurrentWindows(this.testCase);
    }

    @JsonIgnore
    public static void logCurrentWindows(TestCase testCase) {
        StringBuilder logMessage = new StringBuilder("Current active windows:" + System.lineSeparator());
        for (Window w : ApplicationUnderTest.getWindows()) {
            Frame frame;
            try {
                frame = (Frame)w;
                logMessage.append("Window title: '").append(frame.getTitle()).append("'. Shown:").append(frame.isShowing()).append(System.lineSeparator());
            }
            catch (Exception ignored) {
                testCase.log(LogLevel.DEBUG, "Could not retrieve title of Window as Frame. Error: " + ignored.getMessage());
                try {
                    frame = (JFrame)w;
                    logMessage.append("Window title: '").append(frame.getTitle()).append("'. Shown:").append(frame.isShowing()).append(System.lineSeparator());
                }
                catch (Exception ignored2) {
                    testCase.log(LogLevel.DEBUG, "Could not retrieve title of Window as JFrame. Error: " + ignored2.getMessage());
                    logMessage.append("Could not find title of element of class '").append(w.getClass().toString()).append("' since it is not implemented");
                }
            }
        }
        if (testCase == null) {
            System.out.println(logMessage.toString());
        } else {
            testCase.log(LogLevel.INFO, logMessage.toString());
        }
    }

    @JsonIgnore
    public String saveToJsonFile(String filePath) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue(new File(filePath), (Object)this);
        }
        catch (IOException e) {
            return e.toString();
        }
        return "ok";
    }

    @JsonIgnore
    public static ApplicationUnderTest readFromJsonFile(String filePath) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (ApplicationUnderTest)mapper.readValue(new File(filePath), ApplicationUnderTest.class);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            TestCase testCase = new TestCase();
            return new ApplicationUnderTest(testCase, new ApplicationStartMechanism(testCase));
        }
    }

    @JsonIgnore
    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }
}

