/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationstarters.javawebstart;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;

public class SslFileDownloader {
    TestCase testCase;

    public SslFileDownloader(TestCase testCase) {
        this.testCase = testCase;
    }

    public void downloadFileOverSSLAndPotentiallyBadCertificate(String url, String pathToSaveTo) {
        this.log(LogLevel.DEBUG, "Attempting to download the resource at url '" + url + "' and save it to '" + pathToSaveTo + "'.");
        Response response = this.sslFileDownloader(url);
        File downloadedFile = new File(pathToSaveTo);
        BufferedSink sink = null;
        try {
            sink = Okio.buffer((Sink)Okio.sink((File)downloadedFile));
            sink.writeAll((Source)response.body().source());
            sink.close();
        }
        catch (IOException e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Could not save resource content to file. " + e.getMessage());
            e.printStackTrace();
            return;
        }
        this.log(LogLevel.EXECUTED, "Downloaded the resource at url '" + url + "' to file '" + pathToSaveTo + "'.");
    }

    public Response sslFileDownloader(String url) {
        Response response = null;
        OkHttpClient client = new OkHttpClient();
        OkHttpClient.Builder clientBuilder = client.newBuilder();
        Request request = new Request.Builder().get().url(url).build();
        this.log(LogLevel.DEBUG, "Attempting to download resource from '" + url + "'.");
        boolean allowUntrusted = true;
        if (allowUntrusted) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    X509Certificate[] cArrr = new X509Certificate[]{};
                    return cArrr;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            try {
                sslContext.init(null, trustAllCerts, new SecureRandom());
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory());
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        Call call = clientBuilder.build().newCall(request);
        try {
            response = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ":" + message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }
}

