/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import se.claremont.taf.core.gui.Gui;
import se.claremont.taf.core.gui.createtesttab.TestStepListManager;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafFrame;
import se.claremont.taf.core.gui.guistyle.TafHeadline;
import se.claremont.taf.core.gui.guistyle.TafPanel;
import se.claremont.taf.core.gui.guistyle.TafTextArea;
import se.claremont.taf.core.gui.plugins.IGuiTab;
import se.claremont.taf.core.gui.teststructure.TestStep;
import se.claremont.taf.core.gui.teststructure.TestStepList;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.ApplicationStartMechanism;
import se.claremont.taf.javasupport.gui.StandaloneJavaSupportGui;
import se.claremont.taf.javasupport.gui.applicationdeclarationwindow.DeclareApplicationDialog;
import se.claremont.taf.javasupport.gui.guirecordingwindow.RecordWindow;
import se.claremont.taf.javasupport.gui.guispywindow.GuiSpyingWindow;

public class JavaSupportTab
implements IGuiTab {
    private Font appFont;
    JFrame parentWindow;
    TafPanel panel;
    private TafTextArea explanationText = new TafTextArea("ExplanationText");
    private TestStepListManager testStepListManager = new TestStepListManager("^Java.*", this.getCurrentApplicationFrame());
    private TafButton declareApplicationButton = new TafButton("Declare application");
    private TafButton tryStartSutButton = new TafButton("Start application");
    private TafButton guiSpyButton = new TafButton("GUI Spy");
    private TafButton recordScriptButton = new TafButton("Record script");
    public static ApplicationUnderTest applicationUnderTest;

    public JavaSupportTab() {
        this((JFrame)Gui.applicationWindow);
    }

    public JavaSupportTab(JFrame parentWindow) {
        TestCase testCase = new TestCase();
        applicationUnderTest = new ApplicationUnderTest(testCase, new ApplicationStartMechanism(testCase));
        if (Gui.preferences.get("LastJavaSutApplicationDescription") != null) {
            applicationUnderTest = (ApplicationUnderTest)Gui.preferences.get("LastJavaSutApplicationDescription");
        }
        this.parentWindow = parentWindow;
        this.panel = new TafPanel("JavaSupportTabPanal");
        GroupLayout groupLayout = new GroupLayout((Container)this.panel);
        this.panel.setLayout((LayoutManager)groupLayout);
        this.setFontSize();
        TafHeadline text = new TafHeadline("Java support tab");
        this.explanationText.setText("Testing a java application is a bit tricky since the JVM (Java Virtual Machine) that runs the pre-compiled program is a closed box." + System.lineSeparator() + "In TAF we mitigate that by starting the application from the test code, but in a child classloader. This makes the application accessible for TAF, without compromising the context for the system under test.");
        this.explanationText.setLineWrap(true);
        if (parentWindow != null) {
            this.explanationText.setSize(parentWindow.getWidth() * 9 / 10, parentWindow.getHeight() / 2);
        }
        JScrollPane explanationtextScrollPane = new JScrollPane((Component)this.explanationText);
        explanationtextScrollPane.setName("ExplanationTextScrollBar");
        Gui.addChangeListenerToListOfAvailableTestSteps((TestStepList.TestStepListChangeListener)new TestStepList.TestStepListChangeListener(){

            public void isAdded(TestStep testStep) {
                JavaSupportTab.this.testStepListManager.update();
            }

            public void isRemoved(TestStep testStep) {
                JavaSupportTab.this.testStepListManager.update();
            }
        });
        this.declareApplicationButton.setMnemonic('d');
        this.declareApplicationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DeclareApplicationDialog();
            }
        });
        this.tryStartSutButton.setMnemonic('s');
        this.tryStartSutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                applicationUnderTest.start();
            }
        });
        this.guiSpyButton.setMnemonic('g');
        this.guiSpyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiSpyingWindow guiSpyingWindow = new GuiSpyingWindow();
            }
        });
        this.recordScriptButton.setMnemonic('r');
        this.recordScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordWindow recordWindow = new RecordWindow();
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent((Component)text).addComponent(explanationtextScrollPane).addComponent((Component)this.testStepListManager).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.declareApplicationButton).addComponent((Component)this.tryStartSutButton).addComponent((Component)this.guiSpyButton).addComponent((Component)this.recordScriptButton))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)text).addComponent(explanationtextScrollPane).addComponent((Component)this.testStepListManager).addGroup(groupLayout.createParallelGroup().addComponent((Component)this.declareApplicationButton).addComponent((Component)this.tryStartSutButton).addComponent((Component)this.guiSpyButton).addComponent((Component)this.recordScriptButton)));
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        this.panel.setVisible(true);
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            return new JavaSupportTab().panel;
        }
        return this.panel;
    }

    private TafFrame getCurrentApplicationFrame() {
        TafFrame applicationFrame = null;
        applicationFrame = StandaloneJavaSupportGui.window != null ? StandaloneJavaSupportGui.window : Gui.applicationWindow;
        return applicationFrame;
    }

    public String getName() {
        return "Java";
    }

    private void setFontSize() {
        this.appFont = new Font("serif", 0, Toolkit.getDefaultToolkit().getScreenSize().height / 50);
    }
}

