/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.guirecordingwindow;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import se.claremont.taf.core.gui.guistyle.AppFont;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafFrame;
import se.claremont.taf.core.gui.guistyle.TafHtmlTextPane;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.javasupport.gui.guirecordingwindow.RecordingListenersManager;
import se.claremont.taf.javasupport.gui.guirecordingwindow.RecordingOptionsWindow;
import se.claremont.taf.javasupport.gui.guirecordingwindow.listeners.RecordingKeyBoardListener;

public class RecordWindow {
    TafFrame frame;
    GroupLayout groupLayout;
    TafButton recordingOptionsButton = new TafButton("Options");
    TafButton closeButton;
    TafLabel headline = new TafLabel("Rich Java GUI recording");
    TafLabel scriptLabel = new TafLabel("Script");
    TafHtmlTextPane scriptTextPane = new TafHtmlTextPane("ScriptTextPane");
    public static List<RecordingKeyBoardListener.KeyPress> keysPressedSinceLastWriteCommand = new ArrayList<RecordingKeyBoardListener.KeyPress>();
    public static Component activeComponent;
    JScrollPane scriptScrollPane;

    public RecordWindow() {
        this.frame = new TafFrame("TAF - Script recorder");
        this.groupLayout = new GroupLayout(this.frame.getContentPane());
        this.groupLayout.setAutoCreateContainerGaps(true);
        this.groupLayout.setAutoCreateGaps(true);
        this.frame.setLayout((LayoutManager)this.groupLayout);
        this.headline.setFont(new Font(AppFont.getInstance().getName(), AppFont.getInstance().getStyle(), AppFont.getInstance().getSize() * 3 / 2));
        this.scriptScrollPane = new JScrollPane((Component)this.scriptTextPane);
        this.recordingOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordingOptionsWindow recordingOptionsWindow = new RecordingOptionsWindow(RecordWindow.this.frame);
                recordingOptionsWindow.dialog.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        RecordWindow.this.stopRecording();
                        RecordWindow.this.startRecording();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }
                });
            }
        });
        this.closeButton = new TafButton("Close");
        this.closeButton.setMnemonic('c');
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordWindow.this.frame.dispose();
            }
        });
        this.groupLayout.setHorizontalGroup(this.groupLayout.createSequentialGroup().addGroup(this.groupLayout.createParallelGroup().addComponent((Component)this.headline).addComponent((Component)this.scriptLabel).addComponent(this.scriptScrollPane).addGroup(this.groupLayout.createSequentialGroup().addComponent((Component)this.recordingOptionsButton).addComponent((Component)this.closeButton))));
        this.groupLayout.setVerticalGroup(this.groupLayout.createSequentialGroup().addComponent((Component)this.headline).addComponent((Component)this.scriptLabel).addComponent(this.scriptScrollPane).addGroup(this.groupLayout.createParallelGroup().addComponent((Component)this.recordingOptionsButton).addComponent((Component)this.closeButton)));
        this.frame.pack();
        this.frame.setSize(Toolkit.getDefaultToolkit().getScreenSize().width / 3, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                RecordWindow.this.startRecording();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                RecordWindow.this.stopRecording();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    private void stopRecording() {
        RecordingListenersManager.stopRecording();
    }

    private void startRecording() {
        RecordingListenersManager.setScriptArea(this.scriptTextPane);
        RecordingListenersManager.startRecording();
    }

    private static boolean componentsAreTheSame(Component component1, Component component2) {
        if (component1.toString().equals(component2.toString())) {
            return true;
        }
        if (component1.getName() == null && component2.getName() != null) {
            return false;
        }
        if (component1.getName() != null && component2.getName() == null) {
            return false;
        }
        if (component1.getName() != null && component2.getName() != null && !component1.getName().equals(component2)) {
            return false;
        }
        return component1.getClass().getName().equals(component2.getClass().getName());
    }
}

