/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationcontext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sun.management.VMOption;
import java.util.ArrayList;
import java.util.List;

class Flag {
    @JsonIgnore
    private String name;
    @JsonIgnore
    private Object value;
    @JsonIgnore
    private VMOption.Origin origin;
    @JsonIgnore
    private boolean writeable;
    @JsonIgnore
    private boolean external;

    private Flag() {
    }

    Flag(String name, Object value, boolean writeable, boolean external, VMOption.Origin origin) {
        this.name = name;
        this.value = value == null ? "" : value;
        this.origin = origin;
        this.writeable = writeable;
        this.external = external;
    }

    @JsonIgnore
    Object getValue() {
        return this.value;
    }

    @JsonIgnore
    boolean isWriteable() {
        return this.writeable;
    }

    @JsonIgnore
    boolean isExternal() {
        return this.external;
    }

    @JsonIgnore
    VMOption getVMOption() {
        return new VMOption(this.name, this.value.toString(), this.writeable, this.origin);
    }

    @JsonIgnore
    static Flag getFlag(String name) {
        String[] names = new String[]{name};
        List<Flag> flags = Flag.getFlags(names, 1);
        if (flags.isEmpty()) {
            return null;
        }
        return flags.get(0);
    }

    @JsonIgnore
    static List<Flag> getAllFlags() {
        int numFlags = Flag.getInternalFlagCount();
        return Flag.getFlags(null, numFlags);
    }

    @JsonIgnore
    private static List<Flag> getFlags(String[] names, int numFlags) {
        Flag[] flags = new Flag[numFlags];
        int count = Flag.getFlags(names, flags, numFlags);
        ArrayList<Flag> result = new ArrayList<Flag>();
        for (Flag f : flags) {
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    @JsonIgnore
    private static native String[] getAllFlagNames();

    @JsonIgnore
    private static native int getFlags(String[] var0, Flag[] var1, int var2);

    @JsonIgnore
    private static native int getInternalFlagCount();

    @JsonIgnore
    static synchronized native void setLongValue(String var0, long var1);

    @JsonIgnore
    static synchronized native void setBooleanValue(String var0, boolean var1);

    @JsonIgnore
    static synchronized native void setStringValue(String var0, String var1);

    @JsonIgnore
    private static native void initialize();

    static {
        Flag.initialize();
    }
}

