/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationcontext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationcontext.Flag;
import se.claremont.taf.javasupport.applicationundertest.applicationcontext.Util;

public class JavaVmRuntimeChanger
implements HotSpotDiagnosticMXBean,
Serializable {
    @JsonIgnore
    private transient TestCase testCase;
    @JsonProperty
    public List<String> appliedSetting = new ArrayList<String>();

    private JavaVmRuntimeChanger() {
        this.testCase = new TestCase();
    }

    public JavaVmRuntimeChanger(TestCase testCase) {
        this.testCase = testCase;
    }

    @Override
    @JsonIgnore
    public native void dumpHeap(String var1, boolean var2) throws IOException;

    @Override
    @JsonIgnore
    public List<VMOption> getDiagnosticOptions() {
        List<Flag> allFlags = Flag.getAllFlags();
        ArrayList<VMOption> result = new ArrayList<VMOption>();
        for (Flag flag : allFlags) {
            if (!flag.isWriteable() || !flag.isExternal()) continue;
            result.add(flag.getVMOption());
        }
        return result;
    }

    @Override
    @JsonIgnore
    public VMOption getVMOption(String name) {
        if (name == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot get JVM option for null.");
            return null;
        }
        Flag f = Flag.getFlag(name);
        if (f == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "VM option '" + name + "' does not exist");
            return null;
        }
        return f.getVMOption();
    }

    @Override
    @JsonIgnore
    public void setVMOption(String name, String value) {
        if (name == null || name.length() == 0) {
            this.log(LogLevel.EXECUTION_PROBLEM, "JVM option name cannot be null or empty when setting option value.");
            return;
        }
        if (value == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot set JVM option value to null. You might want to try with an empty string.");
            return;
        }
        Util.checkControlAccess();
        Flag flag = Flag.getFlag(name);
        if (flag == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot set VM option '" + name + "' since it does not exist");
            return;
        }
        if (!flag.isWriteable()) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot set VM Option '" + name + "' to '" + value + "' since is read-only.");
            return;
        }
        Object v = flag.getValue();
        if (v instanceof Long) {
            try {
                long l = Long.parseLong(value);
                Flag.setLongValue(name, l);
            }
            catch (NumberFormatException e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Cannot set VM Option '" + name + "' to '" + value + "'. Invalid value: VM Option \"" + name + "\" expects numeric value. Error: " + e.toString());
                return;
            }
        } else if (v instanceof Boolean) {
            if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Cannot set VM Option. Invalid value: VM Option \"" + name + "\" expects \"true\" or \"false\".");
                return;
            }
            Flag.setBooleanValue(name, Boolean.parseBoolean(value));
        } else if (v instanceof String) {
            Flag.setStringValue(name, value);
        } else {
            this.log(LogLevel.FRAMEWORK_ERROR, "Cannot set VM Option '" + name + "' to '" + value + "' since it is of an unsupported type: " + v.getClass().getName());
            return;
        }
        this.log(LogLevel.EXECUTED, "VM Option '" + name + "' successfully set to '" + value + "'.");
        this.appliedSetting.add(name + "=" + value);
    }

    @Override
    @JsonIgnore
    public ObjectName getObjectName() {
        return Util.newObjectName("com.sun.management:type=HotSpotDiagnostic");
    }

    @JsonIgnore
    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ": " + message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }
}

