/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationcontext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;

public class LibraryLoader
implements Serializable {
    @JsonIgnore
    private transient URLClassLoader tafClassLoader;
    @JsonProperty
    public List<String> appliedFiles = new ArrayList<String>();
    @JsonIgnore
    private transient TestCase testCase;

    private LibraryLoader() {
        this.testCase = new TestCase();
        this.tafClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
    }

    public LibraryLoader(TestCase testCase) {
        this.testCase = testCase;
        this.tafClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
    }

    @JsonIgnore
    public void loadLibrary(String path) {
        if (path == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot load null library.");
            return;
        }
        if (path.length() == 0) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot load library from empty path.");
            return;
        }
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot find any file at path '" + path + "'.");
            return;
        }
        if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
            this.log(LogLevel.EXECUTION_PROBLEM, "The path '" + path + "' is a directory. Use method loadAllLibrariesInFolder() instead.");
            return;
        }
        if (path.toLowerCase().endsWith(".jar")) {
            this.addJarFileToClassPath(path);
            return;
        }
        if (path.toLowerCase().endsWith(".dll")) {
            this.loadDll(path);
            return;
        }
        this.log(LogLevel.EXECUTION_PROBLEM, "File at path '" + path + "' is neighter a jar file or a DLL. No attempts to load the file.");
    }

    @JsonIgnore
    public void loadAllLibrariesInFolder(String path) {
        if (path == null) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot load libraries from null folder.");
            return;
        }
        if (path.length() == 0) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot load libraries from empty folder path.");
            return;
        }
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot find any folder or file at path '" + path + "'.");
            return;
        }
        if (!Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
            this.log(LogLevel.INFO, "The path '" + path + "' is not a directory. Loading it as a file.");
            this.loadLibrary(path);
            return;
        }
        this.loadAllDllsInFolder(path);
        this.addFolderToClassPath(path);
    }

    @JsonIgnore
    public void loadDll(String path) {
        if (path == null || path.length() == 0 || !path.toLowerCase().endsWith(".dll")) {
            this.log(LogLevel.EXECUTION_PROBLEM, "The file '" + path + "' does not seem to be a DLL file. Loading of this file aborted. If you still want to load this file use the tryLoadLibrary() method.");
            return;
        }
        try {
            System.load(path);
            this.appliedFiles.add(path);
            this.log(LogLevel.EXECUTED, "Successfully loaded code library '" + path + "'.");
        }
        catch (UnsatisfiedLinkError e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Native code library failed to load. Error: " + System.lineSeparator() + e.toString());
        }
    }

    @JsonIgnore
    public void loadAllDllsInFolder(String path) {
        for (String fileName : this.fileNamesInFolder(path)) {
            if (path == null || path.length() == 0 || !path.toLowerCase().endsWith(".dll") || Files.isDirectory(Paths.get(fileName, new String[0]), new LinkOption[0])) continue;
            try {
                System.load(fileName);
                this.log(LogLevel.EXECUTED, "Successfully loaded code library '" + path + "'.");
                this.appliedFiles.add(path + File.pathSeparator + "*");
            }
            catch (UnsatisfiedLinkError e) {
                this.log(LogLevel.EXECUTION_PROBLEM, "Native code library failed to load. Error: " + System.lineSeparator() + e.toString());
            }
        }
    }

    @JsonIgnore
    public void tryLoadLibrary(String path) {
        if (path == null || path.length() == 0 || Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Cannot load file since file path is empty.");
            return;
        }
        try {
            System.load(path);
            this.appliedFiles.add(path);
            this.log(LogLevel.EXECUTED, "Successfully loaded code library '" + path + "'.");
        }
        catch (UnsatisfiedLinkError e) {
            this.log(LogLevel.EXECUTION_PROBLEM, "Native code library failed to load." + System.lineSeparator() + e.toString());
        }
    }

    @JsonIgnore
    public void addJarFileToClassPath(String filePath) {
        try {
            this.testCase.log(LogLevel.EXECUTED, "Adding file '" + filePath + "' to classpath.");
            this.addURL(new File(filePath).toURI().toURL());
            this.appliedFiles.add(filePath);
        }
        catch (Exception e) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not add file '" + filePath + "' to classpath. Error: " + e.getMessage());
        }
    }

    @JsonIgnore
    public void addFolderToClassPath(String folderPath) {
        for (String fileName : this.fileNamesInFolder(folderPath)) {
            if (Files.isDirectory(Paths.get(fileName, new String[0]), new LinkOption[0]) || !fileName.toLowerCase().endsWith(".jar")) continue;
            try {
                this.testCase.log(LogLevel.EXECUTED, "Simulating adding file '" + fileName + "' to classpath by loading it in ClassLoader.");
                this.addURL(new File(fileName).toURI().toURL());
                this.appliedFiles.add(folderPath + File.pathSeparator + "*");
            }
            catch (Exception e) {
                this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not add file '" + fileName + "' to classpath. Error: " + e.getMessage());
            }
        }
    }

    @JsonIgnore
    private List<String> fileNamesInFolder(String foldername) {
        ArrayList<String> filenames = new ArrayList<String>();
        File folder = new File(foldername);
        File[] listOfFiles = folder.listFiles();
        ArrayList<String> nonJarFiles = new ArrayList<String>();
        ArrayList<String> subDirectories = new ArrayList<String>();
        if (listOfFiles == null) {
            return filenames;
        }
        for (File listOfFile : listOfFiles) {
            if (listOfFile.isFile()) {
                if (listOfFile.getName().endsWith(".jar")) {
                    filenames.add(listOfFile.getAbsolutePath());
                    continue;
                }
                nonJarFiles.add(listOfFile.getAbsolutePath());
                continue;
            }
            if (!listOfFile.isDirectory()) continue;
            subDirectories.add(listOfFile.getName());
        }
        StringBuilder logMessage = new StringBuilder();
        if (filenames.size() == 0) {
            logMessage.append("Could not find any jar files in folder '" + foldername + "'.").append(System.lineSeparator());
        } else {
            logMessage.append("Found the following jar files in folder '" + foldername + "':").append(System.lineSeparator()).append(String.join((CharSequence)(System.lineSeparator() + " * "), filenames)).append(System.lineSeparator());
        }
        if (subDirectories.size() > 0) {
            logMessage.append("Found the following sub-directories in the folder:").append(System.lineSeparator()).append(String.join((CharSequence)(System.lineSeparator() + " * "), subDirectories)).append(System.lineSeparator());
        }
        if (nonJarFiles.size() > 0) {
            logMessage.append("Found the following non-jar-files in the folder:").append(System.lineSeparator()).append(String.join((CharSequence)(System.lineSeparator() + " * "), nonJarFiles)).append(System.lineSeparator());
        }
        this.testCase.log(LogLevel.INFO, logMessage.toString());
        if (nonJarFiles.size() == 0) {
            return filenames;
        }
        LibraryLoader libraryLoader = new LibraryLoader(this.testCase);
        for (String nonJarFile : nonJarFiles) {
            libraryLoader.tryLoadLibrary(nonJarFile);
        }
        return filenames;
    }

    @JsonIgnore
    private void addURL(URL url) throws Exception {
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, url);
    }

    @JsonIgnore
    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ": " + message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }
}

