/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationstarters;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationcontext.ApplicationContextManager;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.ApplicationStartMechanism;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.MethodInvoker;

public class ApplicationStartMechanismCli
extends ApplicationStartMechanism {
    private ApplicationContextManager context;

    public ApplicationStartMechanismCli(TestCase testCase) {
        super(testCase);
        this.context = new ApplicationContextManager(testCase);
    }

    public void startProgramFromCLI(String cliStartString) {
        this.testCase.log(LogLevel.DEBUG, "Attempting to start Java program from CLI string '" + cliStartString + "'.");
        if (cliStartString == null || cliStartString.length() == 0) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not start jar from empty string.");
            return;
        }
        CharSequence[] parts = cliStartString.split(" ");
        parts = this.applyJVMSettings((String[])parts);
        parts = this.applyEnvironmentVariables((String[])parts);
        parts = this.applyClassPath((String[])parts);
        parts = this.removeJavaProgramStatement((String[])parts);
        String jarFile = this.identifyJarFile((String[])parts);
        parts = this.removeJarFileParameterFromPars((String[])parts);
        if (jarFile == null) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Could not identify jar start file in CLI string '" + cliStartString + "'.");
            return;
        }
        try {
            this.testCase.log(LogLevel.DEBUG, "Starting jar file '" + jarFile + "' with arguments '" + String.join((CharSequence)" ", parts) + "'.");
            MethodInvoker.invokeMethodOfClass(this.classLoader, this.testCase, this.mainClass, "main", (String[])parts);
        }
        catch (Exception e) {
            this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Error encountered while trying to start jar file. Error: " + e.getMessage());
        }
    }

    private String[] removeJarFileParameterFromPars(String[] parts) {
        ArrayList<String> remainingParts = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.trim().toLowerCase().equals("-jar")) {
                if (parts.length <= i) continue;
                ++i;
                continue;
            }
            remainingParts.add(part);
        }
        return remainingParts.toArray(new String[0]);
    }

    private String identifyJarFile(String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!part.trim().toLowerCase().equals("-jar") || parts.length <= i) continue;
            this.startUrlOrPathToJarFile = parts[i + 1].trim();
            return parts[i + 1];
        }
        return null;
    }

    private String[] removeJavaProgramStatement(String[] parts) {
        ArrayList<String> remainingParts = new ArrayList<String>();
        for (String part : parts) {
            if (part.trim().toLowerCase().equals("java") || part.trim().toLowerCase().equals("javaw") || part.trim().toLowerCase().endsWith(File.separator + "javaw") || part.trim().toLowerCase().endsWith(File.separator + "java") || part.trim().toLowerCase().equals("java.exe") || part.trim().toLowerCase().equals("javaw") || part.trim().toLowerCase().endsWith(File.separator + "javaw.exe") || part.trim().toLowerCase().endsWith(File.separator + "java.exe")) {
                this.testCase.log(LogLevel.DEBUG, "Removed JRE argument from CLI path since JRE is managed through ClassLoaders.");
                continue;
            }
            remainingParts.add(part);
        }
        return remainingParts.toArray(new String[0]);
    }

    private String[] applyClassPath(String[] parts) {
        ArrayList<String> remainingParts = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.trim().toLowerCase().equals("-cp") || part.trim().toLowerCase().equals("-classpath")) {
                String[] classPaths;
                if (parts.length == i) {
                    this.testCase.log(LogLevel.EXECUTION_PROBLEM, "Expecting java classpath since " + part + " was stated. None found.");
                }
                for (String classPath : classPaths = parts[i + 1].split(File.pathSeparator)) {
                    if (Files.isDirectory(new File(classPath).toPath(), new LinkOption[0])) {
                        this.context.loadedLibraries.addFolderToClassPath(classPath);
                        continue;
                    }
                    this.context.loadedLibraries.addJarFileToClassPath(classPath);
                }
                ++i;
                continue;
            }
            remainingParts.add(parts[i]);
        }
        return remainingParts.toArray(new String[0]);
    }

    private String[] applyEnvironmentVariables(String[] parts) {
        ArrayList<String> remainingParts = new ArrayList<String>();
        for (String part : parts) {
            if (part.trim().startsWith("-D")) {
                String[] setting = part.trim().split("=");
                String settingName = setting[0].trim().substring(2);
                String settingValue = "";
                if (setting.length > 1) {
                    for (int i = 1; i < setting.length; ++i) {
                        settingValue = settingValue + setting[i] + "=";
                    }
                    settingValue = settingValue.substring(0, settingValue.length() - 1);
                }
                this.context.environmentVariables.setEnvironmentVariable(settingName, settingValue);
                continue;
            }
            remainingParts.add(part);
        }
        return remainingParts.toArray(new String[0]);
    }

    private String[] applyJVMSettings(String[] parts) {
        ArrayList<String> remainingParts = new ArrayList<String>();
        for (String part : parts) {
            if (part.trim().startsWith("-X")) {
                String[] setting = part.trim().split("=");
                String settingName = setting[0].trim().substring(2);
                String settingValue = "";
                if (setting.length > 1) {
                    for (int i = 1; i < setting.length; ++i) {
                        settingValue = settingValue + setting[i] + "=";
                    }
                    settingValue = settingValue.substring(0, settingValue.length() - 1);
                }
                this.context.jvmSettings.setVMOption(settingName, settingValue);
                continue;
            }
            remainingParts.add(part);
        }
        return remainingParts.toArray(new String[0]);
    }
}

