/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.applicationundertest.applicationstarters.javawebstart;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.claremont.taf.core.logging.LogLevel;
import se.claremont.taf.core.support.SupportMethods;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.applicationundertest.applicationstarters.javawebstart.SslFileDownloader;

public class JnlpFile {
    TestCase testCase;
    String content;
    String applicationEntryPoint;
    String mainJarFile;
    ArrayList<String> jarFiles = new ArrayList();
    String fileNameForJnlpSaveFile;

    public JnlpFile(TestCase testCase) {
        this.testCase = testCase;
    }

    private void log(LogLevel logLevel, String message) {
        if (this.testCase == null) {
            System.out.println(logLevel.toString() + ":" + message);
        } else {
            this.testCase.log(logLevel, message);
        }
    }

    void getJnlpContent(String urlToJnlp, String pathToSaveTo) {
        this.fileNameForJnlpSaveFile = pathToSaveTo;
        this.log(LogLevel.DEBUG, "Getting jnlp file from url '" + urlToJnlp + "'.");
        SslFileDownloader sslFileDownloader = new SslFileDownloader(this.testCase);
        sslFileDownloader.downloadFileOverSSLAndPotentiallyBadCertificate(urlToJnlp, pathToSaveTo);
        this.content = SupportMethods.getFileContent((String)pathToSaveTo);
        this.log(LogLevel.EXECUTED, "Saved the jnlp file as '" + pathToSaveTo + "'.");
        this.getMainJarFilePathFromJnlpFileContent();
        this.getAdditionalJarFilePathsFromJnlpFileContent();
        this.getApplicationEntryPoint();
    }

    private void getMainJarFilePathFromJnlpFileContent() {
        String[] fileRows;
        ArrayList jarFiles = new ArrayList();
        String startString = "<jar href=\"";
        String stopString = "\" main=\"true";
        for (String fileRow : fileRows = this.content.split(System.lineSeparator())) {
            int stopPosition;
            int startPosition = fileRow.indexOf(startString);
            if (startPosition == -1 || (stopPosition = fileRow.substring(startPosition += startString.length()).indexOf(stopString)) == -1) continue;
            stopPosition = startPosition + stopPosition;
            this.mainJarFile = fileRow.substring(startPosition, stopPosition);
        }
    }

    private void getApplicationEntryPoint() {
        String[] lines = this.content.split(System.lineSeparator());
        int lineNumbers = lines.length;
        for (int lineCount = 0; lineCount < lineNumbers; ++lineCount) {
            if (!lines[lineCount].contains("<application-desc main-class=\"")) continue;
            for (int args = lineCount; args < lineNumbers; ++args) {
            }
        }
    }

    public static String getMainClassString(String pathToJnlp) {
        StringBuilder returnString = new StringBuilder();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pathToJnlp);
            doc.getDocumentElement().normalize();
            NodeList applicationDescriptions = doc.getElementsByTagName("application-desc");
            for (int i = 0; i < applicationDescriptions.getLength(); ++i) {
                Node applicationDescription = applicationDescriptions.item(i);
                if (applicationDescription.getNodeType() == 1) {
                    Element element = (Element)applicationDescription;
                    if (element.getAttribute("main-class") != null) {
                        returnString.append(element.getAttribute("main-class"));
                    }
                    NodeList arguments = element.getElementsByTagName("argument");
                    for (int j = 0; j < arguments.getLength(); ++j) {
                        returnString.append(" ").append(arguments.item(j).getTextContent());
                    }
                }
                returnString.append(System.lineSeparator());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnString.toString();
    }

    private void getAdditionalJarFilePathsFromJnlpFileContent() {
        String[] fileRows;
        this.log(LogLevel.DEBUG, "Identifying the jar files in the jnlp file.");
        String startString = "<jar href=\"";
        String stopString = "\" main=\"false";
        for (String fileRow : fileRows = this.content.split(System.lineSeparator())) {
            int stopPosition;
            int startPosition = fileRow.indexOf(startString);
            if (startPosition == -1 || (stopPosition = fileRow.substring(startPosition += startString.length()).indexOf(stopString)) == -1) continue;
            stopPosition = startPosition + stopPosition;
            this.log(LogLevel.DEBUG, "Identified the jar file '" + fileRow.substring(startPosition, stopPosition) + "' in the file row below:" + System.lineSeparator() + fileRow);
            this.jarFiles.add(fileRow.substring(startPosition, stopPosition));
        }
    }
}

