/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.guirecordingwindow;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import se.claremont.taf.core.support.StringManagement;
import se.claremont.taf.core.testcase.TestCase;
import se.claremont.taf.javasupport.interaction.GenericInteractionMethods;
import se.claremont.taf.javasupport.interaction.MethodDeclarations;
import se.claremont.taf.javasupport.interaction.MethodInvoker;
import se.claremont.taf.javasupport.interaction.elementidentification.By;
import se.claremont.taf.javasupport.objectstructure.JavaGuiElement;
import se.claremont.taf.javasupport.objectstructure.JavaWindow;

public class JavaGuiElementDeclarationManager {
    @JsonProperty
    private static Set<String> usedElementNames = new HashSet<String>();
    @JsonProperty
    private static Set<JavaGuiElement> declaredJavaGuiElements = new HashSet<JavaGuiElement>();
    @JsonIgnore
    private JavaGuiElement returnElement = null;
    @JsonIgnore
    private Component component;
    @JsonIgnore
    private By by = new By();
    @JsonIgnore
    private String javaGuiElementName;
    @JsonIgnore
    private JavaWindow javaWindow;
    @JsonIgnore
    private GenericInteractionMethods java = new GenericInteractionMethods(new TestCase());

    @JsonIgnore
    public static JavaGuiElement createJavaGuiElement(Component component) {
        JavaGuiElementDeclarationManager jgedm = new JavaGuiElementDeclarationManager();
        GenericInteractionMethods java = new GenericInteractionMethods(new TestCase());
        JavaGuiElement javaGuiElement = jgedm.getUniqueElementDescription(component);
        if (jgedm.isUniquelyIdentifiable(javaGuiElement)) {
            return javaGuiElement;
        }
        jgedm.addUniquelyIdentifiableAncestorToby();
        return javaGuiElement;
    }

    @JsonIgnore
    public static void addElementNameToSetOfAlreadyDeclaredElementNames(String elementName) {
        usedElementNames.add(elementName);
    }

    @JsonIgnore
    public static void addJavaGuiElementToDeclaredElementsList(JavaGuiElement javaGuiElement) {
        declaredJavaGuiElements.add(javaGuiElement);
        usedElementNames.add(javaGuiElement.getName());
    }

    @JsonIgnore
    public static void addJavaGuiElementsToDeclaredElementsList(Collection<JavaGuiElement> javaGuiElements) {
        declaredJavaGuiElements.addAll(javaGuiElements);
        for (JavaGuiElement javaGuiElement : javaGuiElements) {
            usedElementNames.add(javaGuiElement.getName());
        }
    }

    @JsonIgnore
    public static void addElementNamesToSetOfAlreadyDeclaredElementNames(Collection<String> elementNames) {
        usedElementNames.addAll(elementNames);
    }

    @JsonIgnore
    public static String javaGuiElementAsCodeString(JavaGuiElement javaGuiElement) {
        if (javaGuiElement == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("JavaGuiElement ").append(javaGuiElement.getName()).append(" = new JavaGuiElement(").append(javaGuiElement.by.asCode()).append(");");
        return sb.toString();
    }

    @JsonIgnore
    public static String javaGuiElementAsCodeHtml(JavaGuiElement javaGuiElement) {
        return "<html><body><pre>" + JavaGuiElementDeclarationManager.javaGuiElementAsCodeString(javaGuiElement).replace(" ", "&nbsp;").replace(System.lineSeparator(), "<br>") + "</pre></bodt></html>";
    }

    @JsonIgnore
    private String getUniqueName(String nameSuggestion, String className) {
        if ((nameSuggestion = StringManagement.methodNameWithOnlySafeCharacters((String)nameSuggestion)).length() > 50) {
            nameSuggestion = nameSuggestion.substring(0, 50);
        }
        if (!usedElementNames.contains(nameSuggestion + className)) {
            usedElementNames.add(nameSuggestion + className);
            return nameSuggestion + className;
        }
        int counter = 2;
        while (usedElementNames.contains(nameSuggestion + String.valueOf(counter) + className)) {
            ++counter;
        }
        usedElementNames.add(nameSuggestion + String.valueOf(counter) + className);
        return nameSuggestion + String.valueOf(counter) + className;
    }

    @JsonIgnore
    private JavaGuiElement getUniqueElementDescription(Component component) {
        if (component == null || this.java == null) {
            return null;
        }
        this.component = component;
        String className = component.getClass().getSimpleName();
        String elementName = component.getName();
        String elementText = (String)MethodInvoker.invokeTheFirstEncounteredMethodFromListOfMethodNames(component, MethodDeclarations.textGettingMethodsInAttemptOrder);
        this.by = this.by.andByClass(className);
        if (elementName != null && elementName.length() > 0) {
            this.by = this.by.andByName(elementName);
            this.javaGuiElementName = this.getUniqueName(elementName, component.getClass().getSimpleName());
        }
        if (elementText != null) {
            this.by = this.by.andByExactText(elementText);
            if (this.javaGuiElementName == null) {
                this.javaGuiElementName = this.getUniqueName(elementText, component.getClass().getSimpleName());
            }
        }
        if (this.javaGuiElementName == null) {
            this.javaGuiElementName = this.getUniqueName("NoNameElement", component.getClass().getSimpleName());
        }
        this.javaWindow = this.getElementWindowComponent();
        this.returnElement = new JavaGuiElement(this.by, this.javaGuiElementName);
        return this.returnElement;
    }

    @JsonIgnore
    private boolean isUniquelyIdentifiable(JavaGuiElement javaGuiElement) {
        return this.javaWindow.getElementMatchCount(javaGuiElement) == 1;
    }

    @JsonIgnore
    private void addUniquelyIdentifiableAncestorToby() {
        Container parentElement = this.component.getParent();
        while (!Window.class.isAssignableFrom(parentElement.getClass())) {
            JavaGuiElement parentJavaGuiElement = this.getUniqueElementDescription(parentElement);
            if (this.isUniquelyIdentifiable(parentJavaGuiElement)) {
                declaredJavaGuiElements.add(parentJavaGuiElement);
                By cfr_ignored_0 = this.returnElement.by;
                this.returnElement.by = By.byBeingDescendantOf(parentJavaGuiElement);
                if (this.isUniquelyIdentifiable(this.returnElement)) {
                    declaredJavaGuiElements.add(this.returnElement);
                    return;
                }
                List<Object> potentialSameComponent = this.javaWindow.getMatchingComponents(this.returnElement);
                for (int match = 0; match < this.javaWindow.getElementMatchCount(this.returnElement); ++match) {
                    if (!potentialSameComponent.get(match).toString().equals(this.component.toString())) continue;
                    this.returnElement.by = this.returnElement.by.andByOrdinalNumber(match + 1);
                    declaredJavaGuiElements.add(this.returnElement);
                    return;
                }
                continue;
            }
            parentElement = parentElement.getParent();
        }
        System.out.println("Could not identify component " + this.component.toString() + " uniquely. Current By statement: " + this.returnElement.by.toString() + ". The top parent element reached is " + parentElement.toString());
    }

    @JsonIgnore
    private JavaWindow getElementWindowComponent() {
        Component potentialParent = this.component;
        while (!Window.class.isAssignableFrom(potentialParent.getClass())) {
            potentialParent = potentialParent.getParent();
        }
        return new JavaWindow((Window)potentialParent);
    }
}

