/*
 * Decompiled with CFR 0.152.
 */
package se.claremont.taf.javasupport.gui.guirecordingwindow;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.claremont.taf.core.gui.guistyle.TafButton;
import se.claremont.taf.core.gui.guistyle.TafCheckbox;
import se.claremont.taf.core.gui.guistyle.TafCloseButton;
import se.claremont.taf.core.gui.guistyle.TafDialog;
import se.claremont.taf.core.gui.guistyle.TafFrame;
import se.claremont.taf.core.gui.guistyle.TafHeadline;
import se.claremont.taf.core.gui.guistyle.TafLabel;
import se.claremont.taf.core.gui.guistyle.TafTextField;
import se.claremont.taf.javasupport.applicationundertest.ApplicationUnderTest;
import se.claremont.taf.javasupport.gui.guirecordingwindow.RecordingListenersManager;

public class RecordingOptionsWindow {
    TafDialog dialog;
    public static boolean recordTafWindows = false;
    private static String initialPath = new File(".").getAbsolutePath().substring(0, new File(".").getAbsolutePath().length() - 1) + "capturemanagers";
    public static boolean recordKeyStrokesOutsideOfWindows = true;
    public static String pathToScriptsRoot = initialPath;

    public RecordingOptionsWindow(TafFrame parent) {
        this.dialog = new TafDialog((JFrame)parent, "TAF - Recording options", true);
        GroupLayout groupLayout = new GroupLayout(this.dialog.getContentPane());
        this.dialog.getContentPane().setLayout(groupLayout);
        TafHeadline headline = new TafHeadline("Recording options");
        TafLabel scriptRootPathLabel = new TafLabel("Script root path");
        final TafTextField scriptRootPathTextField = new TafTextField(" < Script root path > ");
        scriptRootPathTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (scriptRootPathTextField.isChangedFromDefault()) {
                    pathToScriptsRoot = scriptRootPathTextField.getText();
                }
            }
        });
        scriptRootPathTextField.setText(initialPath);
        scriptRootPathLabel.setLabelFor((Component)scriptRootPathTextField);
        TafButton selectScriptRootPathButton = new TafButton("Select");
        selectScriptRootPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
            }
        });
        final TafCheckbox recordAllKeyStrolesCheckbox = new TafCheckbox("Record keystrokes outside windows");
        recordAllKeyStrolesCheckbox.setSelected(true);
        recordAllKeyStrolesCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                recordKeyStrokesOutsideOfWindows = recordAllKeyStrolesCheckbox.isSelected();
            }
        });
        final TafCheckbox recordTafWindowsAlsoCheckbox = new TafCheckbox("Also record TAF windows");
        recordTafWindowsAlsoCheckbox.setSelected(false);
        TafCloseButton closeButton = new TafCloseButton((JDialog)this.dialog);
        closeButton.setText("Cancel");
        TafButton saveButton = new TafButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                recordKeyStrokesOutsideOfWindows = recordAllKeyStrolesCheckbox.isSelected();
                for (Window window : ApplicationUnderTest.getWindows()) {
                    if (!window.getClass().equals(TafFrame.class) && !window.getClass().equals(TafDialog.class)) continue;
                    if (!recordTafWindowsAlsoCheckbox.isSelected()) {
                        RecordingListenersManager.removeAllTafRecordingListenersFromWindow(window);
                        continue;
                    }
                    RecordingListenersManager.makeSureAllComponentsHasRegisteredListeners(window);
                }
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent((Component)headline).addGroup(groupLayout.createSequentialGroup().addComponent((Component)scriptRootPathLabel).addComponent((Component)scriptRootPathTextField).addComponent((Component)selectScriptRootPathButton)).addComponent((Component)recordAllKeyStrolesCheckbox).addComponent((Component)recordTafWindowsAlsoCheckbox).addGroup(groupLayout.createSequentialGroup().addComponent((Component)closeButton).addComponent((Component)saveButton)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent((Component)headline).addGroup(groupLayout.createParallelGroup().addComponent((Component)scriptRootPathLabel).addComponent((Component)scriptRootPathTextField).addComponent((Component)selectScriptRootPathButton)).addComponent((Component)recordAllKeyStrolesCheckbox).addComponent((Component)recordTafWindowsAlsoCheckbox).addGroup(groupLayout.createParallelGroup().addComponent((Component)closeButton).addComponent((Component)saveButton)));
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

